<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AdminActivity;
use App\Models\AdminRole;
use App\Models\mobilead;
use App\Models\onpremise;
use App\Models\PermitStepMobile;
use App\Models\PermitStepOnpremise;
use App\Models\PermitStepStreetLamp;
use App\Models\StreetLampsAds;
use App\Models\ThirdPartyMobile;
use App\Models\ThirdPartyMobilePermitStep;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use SimpleSoftwareIO\QrCode\Facades\QrCode;


class FinalApprovalController extends Controller
{
    //


        public function finalDeclineForMobile($mobileId) {
            if(Auth::user()->admin_role_id == 6) {
                $setFinalMobileAds = mobilead::where('id', $mobileId)->update(['final_status' => 'declined']);
                $getMobileAds = mobilead::where('id', $mobileId)->get();
                $mobileObj = mobilead::find($getMobileAds[0]['id']);
                $currentStep = AdminRole::where('id', 5)->get();
                $permitStep = new PermitStepMobile();
                $permitStep->purpose = 'New Mobile Ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $mobileObj->permitStepMobile()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Decline Mobiles  Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getMobileAds], 200);
            } else {
                return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }

        public function finalDeclineForThirdPartyMobile($mobileId) {
            if(Auth::user()->admin_role_id  == 6) {
                $setFinalThirdPartyMobile = ThirdPartyMobile::where('id', $mobileId)->update(['final_status' => 'declined']);
                $getThirdPartyMobileAds = ThirdPartyMobile::where('id', $mobileId)->get();
                $thirdPartyMobileObj = ThirdPartyMobile::find($getThirdPartyMobileAds[0]['id']);
                $currentStep = AdminRole::where('id', 5)->get();
                $permitStep = new ThirdPartyMobilePermitStep();
                $permitStep->purpose = 'New Third Party Mobile ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $thirdPartyMobileObj->thirdPartyMobilePermitStep()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Decline Third Party Mobile Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getThirdPartyMobileAds],200);
            } else {
                return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }

        public function finalDeclineForStreetLamp($streetLampId)
        {
            if (Auth::user()->admin_role_id == 6) {
                $setFinalStreetLamp = StreetLampsAds::where('id', $streetLampId)->update(['final_status' => 'declined']);
                $getStreetLampAds = StreetLampsAds::where('id', $streetLampId)->get();
                $streetLampObj = StreetLampsAds::find($getStreetLampAds[0]['id']);
                $currentStep = AdminRole::where('id', 5)->get();
                $permitStep = new PermitStepStreetLamp();
                $permitStep->purpose = 'New Street Lamps ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $streetLampObj->permitStepStreetLamp()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Decline Street Lamp Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getStreetLampAds], 200);
            } else {
                return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }

        public function finalDeclineForOnpremise($onpremiseId) {
            if(Auth::user()->admin_role_id == 6) {
                $setFinalOnpremise = onpremise::where('id', $onpremiseId)->update(['final_status' => 'declined']);
                $getOnpremiseAds = onpremise::where('id', $onpremiseId)->get();
                $onpremiseObj = onpremise::find($getOnpremiseAds[0]['id']);
                $currentStep = AdminRole::where('id', 5)->get();
                $permitStep = new PermitStepOnpremise();
                $permitStep->purpose = 'New Onpremise Ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $onpremiseObj->permitStepOnpremise()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Decline onpremise Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getOnpremiseAds], 200);
             } else {
                return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }

        public function finalApproveForMobile($mobileId) {
            if(Auth::user()->admin_role_id == 6) {
                $setFinalMobileAds = mobilead::where('id', $mobileId)->update(['final_status' => 'approved']);
                $getMobileAds = mobilead::where('id', $mobileId)->get();
                $getMobileName = $getMobileAds[0]['brand_name'];
                //var_dump($getMobileName); die();
                $mobileObj = mobilead::find($getMobileAds[0]['id']);
                $currentStep = AdminRole::where('id', 6)->get();
                $permitStep = new PermitStepMobile();
                $permitStep->purpose = 'New Mobile Ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $mobileObj->permitStepMobile()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Approve Mobile Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getMobileAds], 200);
            } else {
                return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }

        public function finalApproveForThirdParty($mobileId) {
            if(Auth::user()->admin_role_id == 6) {
                $setFinalThirdPartyMobile = ThirdPartyMobile::where('id', $mobileId)->update(['final_status' => 'approved']);
                $getThirdPartyAds = ThirdPartyMobile::where('id', $mobileId)->get();

                $thirdPartyMobileObj = ThirdPartyMobile::find($getThirdPartyAds[0]['id']);
                $currentStep = AdminRole::where('id', 6)->get();
                $permitStep = new ThirdPartyMobilePermitStep();
                $permitStep->purpose = 'New Third Party Mobile Ads';
                $permitStep->current_steps = $currentStep[0]['role'];
                $thirdPartyMobileObj->thirdPartyMobilePermitStep()->save($permitStep);
                $user = Auth::user();
                $activityInfo = new AdminActivity();
                $fetchActivity ='Approve  Third Party Mobile Ads Application';
                $activityInfo->action = $fetchActivity;
                $activityInfo->user_admin_id = (string)$user->id;
                $activityInfo->save();
                return response()->json(['data' => $getThirdPartyAds],200);
            } else {
                return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
            }
        }


    public function finalApproveForStreetLamp($streetLampId) {
        if(Auth::user()->admin_role_id == 6) {
            $setFinalStreetLamp = StreetLampsAds::where('id', $streetLampId)->update(['final_status' => 'approved']);
            $getStreetLampAds = StreetLampsAds::where('id', $streetLampId)->get();
            $streetLampObj = StreetLampsAds::find($getStreetLampAds[0]['id']);
            $currentStep = AdminRole::where('id', 6)->get();
            $permitStep = new PermitStepStreetLamp();
            $permitStep->purpose = 'New Street Lamps ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $streetLampObj->permitStepStreetLamp()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve  Street Lamp Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            return response()->json(['data' => $getStreetLampAds],200);
        } else {
            return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }

    public function finalApproveForOnpremise($onpremiseId) {
        if(Auth::user()->admin_role_id == 6) {
            $setFinalOnpremise = onpremise::where('id', $onpremiseId)->update(['final_status' => 'approved']);
            $getOnpremiseAds = onpremise::where('id', $onpremiseId)->get();
            $onpremiseObj = onpremise::find($getOnpremiseAds[0]['id']);
            $currentStep = AdminRole::where('id', 6)->get();
            $permitStep = new PermitStepOnpremise();
            $permitStep->purpose = 'New Onpremise Ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $onpremiseObj->permitStepOnpremise()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve onpremise Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            return response()->json(['data' => $getOnpremiseAds], 200);
        } else {
            return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }


//        protected static function generateQrCode($entityObj)
//        {
//            $content = $entityObj;
//            $generatedQrCode = QrCode::size(300)
//                ->backgroundColor(255, 255, 204)
//                ->generate($content);
//            return $generatedQrCode;
//        }


}

