<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Util\UtilMethods;
use App\Models\FirstPartyTemporaryAds;
use App\Models\FirstPartyTemporaryAdsDetails;
use App\Models\kycdetail;
use App\Models\KycThirdParty;
use App\Models\User;
use App\Models\UserAdmin;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use js\tools\numbers2words\Speller;


class FirstPartyTemporaryAdsController extends Controller
{
    private $successStatusCode = 200;
    private $createStatusCode = 201;
    private $errorStatusCode = 422;

    public function __construct() {
        // $this->middleware('auth:api');
        $this->middleware('check.multi.guard'); // Then apply your custom middleware
    }

    public function createTemporaryAds(Request $request) {

        // $userId = Auth::user()->id;
        if(empty($request->type)){
            $userId = Auth::guard('api')->user()->id;
            $udtype = Auth::guard('api')->user()->user_type;
            $udbn = Auth::guard('api')->user()->business_name;
        }elseif($request->type == "admin"){
            $userId = $request->ud;
            $udfind = User::find($userId);
            $udtype = $udfind->user_type;
            $udbn = $udfind->business_name;
        }
        $userObj = User::find($userId);
        $validate = Validator::make($request->all(), [
                'appUserType' => 'required|string',
                'nameService' => 'required|string',
                'location' => 'required|string',
                'startDate' => 'required|date_format:Y-m-d',
                'endDate' => 'nullable|date|after:startDate',
                'durationType' => 'nullable|string',
                'temporaryDetails' => 'present|array',
                'temporaryDetails.temporaryInfo.*.classificationSign' => 'nullable|string|in:movable signs,other temporary signs',
                'temporaryDetails.temporaryInfo.*.typeSign' => 'required|string',
                'temporaryDetails.temporaryInfo.*.size' => 'nullable|numeric',
                'temporaryDetails.temporaryInfo.*.dimension' => 'nullable|string',
                'temporaryDetails.temporaryInfo.*.photo' => 'nullable|string',
                'temporaryDetails.temporaryInfo.*.transitSign' => 'required|boolean',
                'temporaryDetails.temporaryInfo.*.vehicleLicense' => 'nullable|string',
                'temporaryDetails.temporaryInfo.*.licenseNumber' => 'nullable|array',
                'temporaryDetails.temporaryInfo.*.number_of_days' => 'nullable|integer',
                'temporaryDetails.temporaryInfo.*.durationDays' => 'nullable|array',
                'temporaryDetails.temporaryInfo.*.wearableSign' => 'nullable|boolean',
                'temporaryDetails.temporaryInfo.*.amountWearable' => 'nullable|integer',
                'temporaryDetails.temporaryInfo.*.moveableAnimation' => 'nullable|boolean',
                'temporaryDetails.temporaryInfo.*.trafficStatement' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], $this->errorStatusCode);
        }

            $temporaryInput = $request->all();
            $count = count($temporaryInput['temporaryDetails']['temporaryInfo']) - 1;


         $rmRole = [2,3];
        $assignedDepartment = "";
         if($temporaryInput['appUserType'] == 'first_party') {
             $getAssignedOfficer  = UserAdmin::where('department', 'Mobile_advert')->whereIn('admin_role_id', $rmRole)->pluck('id')->toArray();
             $assignedDepartment = 'Mobile_advert';
         } elseif ($temporaryInput['appUserType'] == 'third_party') {
             $getAssignedOfficer  = UserAdmin::where('department', 'Registry')->whereIn('admin_role_id', $rmRole)->pluck('id')->toArray();
             $assignedDepartment = 'Registry';
         }
            $officerCounter = [];
            foreach ($getAssignedOfficer as $officer) {
                $counter = FirstPartyTemporaryAds::where('assigned_officer', (string) $officer)->count();
                $officerCounter[$officer] = $counter;
            }

            $leastOfficer = array_search(min($officerCounter), $officerCounter);
            $getLeastOfficer = UserAdmin::where('id', (string) $leastOfficer)->first();
            
            if($udtype == 'first_party'){
                $kycd = kycdetail::where('user_id', $userId)->first();
                $comp_name = $udbn;
                $comp_address = $kycd->full_address;
                $comp_lga = $kycd->lga;
                
            }elseif($udtype == 'third_party'){
                $kycd = KycThirdParty::where('user_id', $userId)->first();
                $comp_name = $udbn;
                $comp_address = $kycd->office_address;
                $comp_lga = $kycd->lga;
            }
            
            $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki", "Ikorodu", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($comp_lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($comp_lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($comp_lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($comp_lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
            if(!$temporaryInput['endDate'] && isset($temporaryInput['durationType'])){
                if($temporaryInput['durationType'] == "Monthly"){
                    $duru = 1;   
                }elseif($temporaryInput['durationType'] == "Quarterly"){
                    $duru = 3; 
                }elseif($temporaryInput['durationType'] == "Biannual"){
                    $duru = 6; 
                }elseif($temporaryInput['durationType'] == "Annually"){
                    $duru = 12; 
                }
                $startDate = Carbon::parse($temporaryInput['startDate']); // Example start date
                $duration = $duru; // Example duration in months
                
                // Calculate the end date
                $endDate = $startDate->copy()->addMonths($duration);
                
                // Get the last day of the current year
                $lastDayOfYear = $startDate->copy()->endOfYear();
                
                // Compare the calculated end date with the last day of the year
                if ($endDate->greaterThan($lastDayOfYear)) {
                    $endDate = $lastDayOfYear;
                }
            }elseif(isset($temporaryInput['endDate']) && !$temporaryInput['durationType']){
                $endDate = $temporaryInput['endDate'];
            }

            $firstPartyTemporary = new  FirstPartyTemporaryAds();
            $firstPartyTemporary->name_of_company = $comp_name;
            $firstPartyTemporary->company_address = $comp_address;
            $firstPartyTemporary->lga = $comp_lga;
            $firstPartyTemporary->name_of_service = $temporaryInput['nameService'];
            $firstPartyTemporary->site_location = $temporaryInput['location'];
            $firstPartyTemporary->start_date = $temporaryInput['startDate'];
            $firstPartyTemporary->end_date = $endDate;
            $firstPartyTemporary->duration = $temporaryInput['durationType'];
            $firstPartyTemporary->payment_id = $this->firstPartyTemporaryAds();
            if($udtype == 'third_party'){
                $firstPartyTemporary->assigned_officer = (string) $getLeastOfficer->id;
            }
            $firstPartyTemporary->assigned_department = $assignedDepartment;
            if($udtype == 'first_party'){
                $firstPartyTemporary->zone = $zone;
            }
            $saveDetails = $userObj->firstPartyTemporaryAds()->save($firstPartyTemporary);
            $output [] = $saveDetails;

            $utilObj = new UtilMethods();
            for($i=0;$i<=$count; $i++) {
                $firstPartyTemporaryDetails = new FirstPartyTemporaryAdsDetails();
                $firstPartyTemporaryDetails->class_signs = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['classificationSign'];
                $firstPartyTemporaryDetails->type_sign = $this->capitalizeFirstWordInString($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['typeSign']);
                $firstPartyTemporaryDetails->size_ads = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['size'];
                $firstPartyTemporaryDetails->dimension_ads = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['dimension'];
                // Remove the square brackets
                if(isset($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['licenseNumber'])){
                  $licensecleanedString = implode(', ', $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['licenseNumber']);
                  $firstPartyTemporaryDetails->license_number = $licensecleanedString;  
                }
                $firstPartyTemporaryDetails->number_of_days = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['number_of_days'];
                // Remove the square brackets
                if(isset($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['durationDays'])){
                  $cleanedString = implode(', ', $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['durationDays']);
                  $firstPartyTemporaryDetails->days_in_duration = $cleanedString;
                }
                if(isset($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['photo'])){
                    $firstPartyTemporaryDetails->photo_montage = $utilObj->convertBase64toImage($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['photo']);
                }
                $firstPartyTemporaryDetails->transit_sign = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['transitSign'];
                if($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['typeSign'] == "banner on vehicle(car, bus)" || $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['typeSign'] == "banner on a truck") {
                    $firstPartyTemporaryDetails->vehicle_license = $utilObj->convertBase64toImage($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['vehicleLicense']);
                }
                $firstPartyTemporaryDetails->wearable_sign = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['wearableSign'];
                // if($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['wearableSign'] == true) {
                //     $firstPartyTemporaryDetails->number_wearable = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['amountWearable'];
                // }
                $firstPartyTemporaryDetails->number_wearable = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['amountWearable'];
                $firstPartyTemporaryDetails->moveable_animation = $temporaryInput['temporaryDetails']['temporaryInfo'][$i]['moveableAnimation'];
                if($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['moveableAnimation'] == true) {
                    $firstPartyTemporaryDetails->traffic_statement = $utilObj->convertBase64toPdfV2($temporaryInput['temporaryDetails']['temporaryInfo'][$i]['trafficStatement']);
                }
                $firstPartyTemporaryObj = FirstPartyTemporaryAds::find($output[0]['id']);
                $firstPartyTemporaryObj->firstPartyTemporaryAdsDetails()->save($firstPartyTemporaryDetails);
            }
            $getResponse = FirstPartyTemporaryAds::where('id', $output[0]['id'])->with(['firstPartyTemporaryAdsDetails'])->get();
            return response()->json(['success' => true, 'data' => $getResponse], $this->successStatusCode);
    }

    public function getAllTemporaryAds(Request $request) {

        $userId = Auth::guard('api')->user()->id;

        $keyword = $request->input('search');
        $getTemporaryAds = FirstPartyTemporaryAds::where('user_id', $userId)->with(['firstPartyTemporaryAdsDetails']);

        if($keyword) {
            $getTemporaryAds->where(function ($query) use ($keyword) {
                $query->where('name_of_service', 'like', '%' . $keyword . '%')
                    ->orWhere('site_location', 'like', '%' . $keyword . '%')
                    ->orWhere('payment_id', 'like', '%' . $keyword . '%');
            });

            $getTemporaryAds->orWhereHas('firstPartyTemporaryAdsDetails', function ($query) use ($keyword) {
                $query->where('class_signs', 'like', '%' . $keyword . '%')
                    ->orWhere('type_sign', 'like', '%' . $keyword . '%');
            });
        }

            $getAllItems = $getTemporaryAds->orderBy('created_at', 'desc')->paginate(20);
            if($getAllItems->count() > 0) {
                return response()->json(['success' => true, 'data' => $getAllItems], $this->successStatusCode);
            } else {
                return response()->json(['success' => false, 'data' => 'No items found'], $this->errorStatusCode);
            }

    }

    public function getOneTemporaryAds($temporaryId) {
        $temporaryObj = FirstPartyTemporaryAds::findOrFail($temporaryId);
        if(Auth::guard('api')->user()->id == (string) $temporaryObj->user_id) {
            $getSingleTemporaryAds = FirstPartyTemporaryAds::where('id', $temporaryId)->with(['firstPartyTemporaryAdsDetails'])->get();

            if (is_null($getSingleTemporaryAds)) {
                return response()->json(['success' => false, 'data' => 'Temporary ads does not exist'], $this->errorStatusCode);
            } else {
                return response()->json(['success' => true, 'data' => $getSingleTemporaryAds], $this->successStatusCode);
            }
        } else {
            return response()->json(['success' => false, 'data' => 'can not assess the temporary ads'], $this->errorStatusCode);
        }
    }

    public function editTemporaryAds(Request $request, $temporaryId) {


            $temporaryObj = FirstPartyTemporaryAds::findOrFail($temporaryId);
            if($temporaryObj->user_id == (string) Auth::guard('api')->user()->id) {
                if($temporaryObj->application_status == 'pending' || $temporaryObj->rm_recommendation == 'pending') {
                    $validate = Validator::make($request->all(), [
                        'nameService' => 'nullable|string',
                        'location' => 'nullable|string',
                        'startDate' => 'nullable|date_format:Y-m-d',
                        'endDate' => 'nullable|date|after:startDate'
                    ]);

                    if ($validate->fails()) {
                        return response()->json(['errors' => $validate->errors()->all()], $this->errorStatusCode);
                    }

                    $temporaryInput = $request->all();
                    $updatedData = [];
                    
                    if(!empty($temporaryInput['nameService'])) {
                        $updatedData['name_of_service'] = $temporaryInput['nameService'];
                    }
                    if(!empty($temporaryInput['location'])) {
                        $updatedData['site_location'] = $temporaryInput['location'];
                    }
                    if(!empty($temporaryInput['startDate'])) {
                        $updatedData['start_date'] = $temporaryInput['startDate'];
                    }
                    if(!empty($temporaryInput['endDate'])) {
                        $updatedData['end_date'] = $temporaryInput['endDate'];
                    }
                    if(!empty($updatedData)) {
                        FirstPartyTemporaryAds::where('id', $temporaryObj->id)->update($updatedData);
                    }
                    $response = FirstPartyTemporaryAds::where('id', $temporaryObj->id)->get();
                    return response()->json(['success' => true, 'data' => $response], $this->successStatusCode);
                } else {
                    return response()->json(['success' => false, 'data' => 'can not edit an already approved temporary ads'], $this->errorStatusCode);
                }
            } else {
                return  response()->json(['success' => false, 'data' => 'can not edit this temporary ads'], $this->errorStatusCode);
            }
    }

    public function editTemporaryDetailsAds(Request $request, $temporaryId, $temporaryDetails) {


            $temporaryObj = FirstPartyTemporaryAds::findOrFail($temporaryId);
            if($temporaryObj->user_id == (string) Auth::guard('api')->user()->id) {
                if($temporaryObj->application_status == 'pending' || $temporaryObj->rm_recommendation == 'pending') {
                    $temporaryDetailsObj = FirstPartyTemporaryAdsDetails::findOrFail($temporaryDetails);
                    $validate = Validator::make($request->all(), [
                        'classificationSign' => 'nullable|string|in:movable signs,other temporary signs',
                        'typeSign' => 'nullable|string',
                        'size' => 'nullable|numeric',
                        'dimension' => 'nullable|string',
                        'photo' => 'nullable|string',
                        'transitSign' => 'nullable|boolean',
                        'vehicleLicense' => 'nullable|string',
                        'wearableSign' => 'nullable|boolean',
                        'amountWearable' => 'nullable|integer',
                        'moveableAnimation' => 'nullable|boolean',
                        'trafficStatement' => 'nullable|string',
                        'durationDays' => 'nullable|array',
                        'number_of_days' => 'nullable|integer',
                        'licenseNumber' => 'nullable|array'
                    ]);

                    if($validate->fails()) {
                        return response()->json(['errors' => $validate->errors()->all()], $this->errorStatusCode);
                    }

                    $temporaryInput = $request->all();
                    $updateData = [];
                    $utilObj = new UtilMethods();

                    if(!empty($temporaryInput['classificationSign'])) {
                        $updateData['class_signs'] = $temporaryInput['classificationSign'];
                    }
                    if (!empty($temporaryInput['typeSign'])) {
                        $updateData['type_sign'] = $this->capitalizeFirstWordInString($temporaryInput['typeSign']);
                    }
                    if(!empty($temporaryInput['size'])) {
                        $updateData['size_ads'] = $temporaryInput['size'];
                    }
                    if (!empty($temporaryInput['dimension'])) {
                        $updateData['dimension_ads'] = $temporaryInput['dimension'];
                    }
                    if(!empty($temporaryInput['photo'])) {
                        $updateData['photo_montage'] = $utilObj->convertBase64toImage($temporaryInput['photo']);
                    }
                    if(!empty($temporaryInput['transitSign'])) {
                        $updateData['transit_sign'] = $temporaryInput['transitSign'];
                    }
                    if(!is_null($temporaryInput['vehicleLicense'])) {
                        $updateData['vehicle_license'] = $utilObj->convertBase64toImage($temporaryInput['vehicleLicense']);
                    }
                    if(!empty($temporaryInput['wearable_sign'])) {
                        $updateData['wearable_sign'] = $temporaryInput['wearable_sign'];
                    }
                    if(!empty($temporaryInput['amountWearable'])) {
                        $updateData['number_wearable'] = $temporaryInput['amountWearable'];
                    }
                    if(!empty($temporaryInput['moveableAnimation'])) {
                        $updateData['moveable_animation'] = $temporaryInput['moveableAnimation'];
                    }
                    if(!is_null($temporaryInput['trafficStatement'])) {
                        $updateData['traffic_statement'] = $utilObj->convertBase64toPdfV2($temporaryInput['trafficStatement']);
                    }
                    if(isset($temporaryInput['licenseNumber'])){
                      $licensecleanedString = implode(', ', $temporaryInput['licenseNumber']);
                      $updatedData['license_number'] = $licensecleanedString;  
                    }
                    if(isset($temporaryInput['durationDays'])){
                      $licensecleanedString = implode(', ', $temporaryInput['durationDays']);
                      $updatedData['days_in_duration'] = $licensecleanedString;  
                    }
                    if(!empty($temporaryInput['number_of_days'])) {
                        $updatedData['number_of_days'] = $temporaryInput['number_of_days'];
                    }
                    if(!empty($updateData)) {
                        FirstPartyTemporaryAdsDetails::where('id', $temporaryDetailsObj->id)->update($updateData);
                    }
                    $response = FirstPartyTemporaryAdsDetails::where('id', $temporaryDetailsObj->id)->get();
                    return response()->json(['success' => true, 'data' => $response], $this->successStatusCode);
                } else {
                    return response()->json(['success' => false, 'data' => 'can not edit an already approved temporary ads'], $this->errorStatusCode);
                }
            } else {
                return  response()->json(['success' => false, 'data' => 'can not edit this temporary ads'], $this->errorStatusCode);
            }
    }

    public function submitEditButtonFirstPartyTemporary($temporaryId) {

        $temporaryObj = FirstPartyTemporaryAds::findOrFail($temporaryId);
        if(Auth::guard('api')->user()->id == (string)$temporaryObj->user_id) {
            if($temporaryObj->application_status == 'pending' || $temporaryObj->rm_recommendation == 'pending') {
                FirstPartyTemporaryAds::where('id', $temporaryObj->id)->update(['application_status' => 'pending', 'rm_recommendation' => null,
                    'hod_recommendation' => null, 'md_approval' => null]);

                $getResponse = FirstPartyTemporaryAds::where('id', $temporaryObj->id)->with(['firstPartyTemporaryAdsDetails'])->get();
                return response()->json(['success' => true, 'data' => $getResponse], $this->successStatusCode);
            } else {
                return  response()->json(['success' => false, 'data' => 'can not edit an approved temporary ads'], $this->successStatusCode);
            }
        } else {
            return response()->json(['success' => false, 'data' => 'can not submit edit for temporary ads'], $this->errorStatusCode);
        }
    }

    public function getTemporaryApprovalLetter($temporaryId)
    {

        $user = Auth::guard('api')->user();

        $temporaryObj = FirstPartyTemporaryAds::findOrFail($temporaryId);
        if ($user->id == $temporaryObj->user_id) {
            if ($temporaryObj->pay_status !== 'paid') {
                return response()->json(['success' => false, 'data' => 'Temporary ads has not been paid'], $this->errorStatusCode);
            }

                if($temporaryObj->ref_no == null) {
                    $refNo = $this->getTemporaryRefNo();
                    FirstPartyTemporaryAds::where('id', $temporaryObj->id)->update(['ref_no' => $refNo]);
                }
                $getTemporaryAds = FirstPartyTemporaryAds::where('id', $temporaryObj->id)->with(['user'])->get();
                $getTemporaryInfo = FirstPartyTemporaryAdsDetails::where('first_party_temporary_ads_id', $temporaryObj->id)->get();
                $getAddressInfo = kycdetail::where('user_id', $getTemporaryAds[0]['user_id'])->get();
                $carbonStartDate = Carbon::parse($getTemporaryAds[0]['start_date']);
                $carbonEndDate = Carbon::parse($getTemporaryAds[0]['end_date']);
                $validity = $carbonStartDate->diffInDays($carbonEndDate);
                $validityInWords = UtilMethods::temporaryInWords($validity);
                $countDetails = count($getTemporaryInfo) - 1;
                $signTypes = [];
                $quantitySigns = [];

                for($i=0;$i <= $countDetails; $i++) {
                    $signTypes [] = $getTemporaryInfo[$i]['type_sign'];
                    $quantitySigns [] = $getTemporaryInfo[$i]['number_wearable'];
                }
                $combinedArray = [];
                foreach ($signTypes as $index => $value) {
                    $combinedArray [] = [
                        'key' => $value,
                        'value' => $quantitySigns[$index],
                        'words' => $this->getWordsofNumber($quantitySigns[$index]),
                    ];
                }
                $data = [
                    'userinfo' => $getTemporaryAds[0]['user']['business_name'],
                    'usertype' => $getTemporaryAds[0]['user']['user_type'],
                    'useraddress' => $getAddressInfo[0]['full_address'],
                    'bustop' => $getAddressInfo[0]['bustop'],
                    'lga' => $getAddressInfo[0]['lga'],
                    'permitNumber' =>  $getTemporaryAds[0]['ref_no'],
                    'date' => Carbon::parse($getTemporaryAds[0]['start_date'])->format('d F Y'),
                    'validity' => $validity,
                    'validityInWords' => $validityInWords,
                    'nameAds' => $getTemporaryAds[0]['name_of_service'],
                ];
                $pdf = Pdf::loadView('firstpartytemporaryadsletter', compact('data', 'combinedArray'));
                $fileObj = $pdf->download('firstpartytemporaryadsletter.pdf');

                $userObj = User::find($getTemporaryAds[0]['user_id']);
                $body = "We are pleased to inform you that your application for temporary ads has been approved. Please find your approval letter attached";
                $templateData = [
                    'body' => $body,
                    'name' => $userObj->company_name
                ];
                $templateContent = view('hodeoitemplate', $templateData)->render();
                UtilMethods::temporaryAdsSendApproval($userObj->email, $templateContent, $fileObj);
                return response()->json(['success' => true, 'data' => 'Email approval sent'], $this->successStatusCode);
        }
    }

    private function firstPartyTemporaryAds() {
        $prefix = 'tempads';
        $batchkey = Carbon::now()->format('YmdHis');
        $suffix = rand(100, 999);
        return $prefix.$batchkey.$suffix;
    }

    public function capitalizeFirstWordInString( $string) {

        $string = strtolower($string);
        $string = preg_replace_callback('/(?:^|[\s\/-])\w/', function ($matches) {
            return strtoupper($matches[0]);
        }, $string);
        return $string;
    }

    private  function getWordsofNumber($number) {
        $words = Speller::spellNumber($number, Speller::LANGUAGE_ENGLISH);
        return $words;
    }
}
