<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\kycdetail;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class kycController extends Controller
{


    public function __construct() {
        $this->middleware('auth:api');
    }


    public function registerKycDetails(Request $request) {
        $validator = Validator::make($request->all(), [
            'website' => 'nullable|string|max:255',
            'full_address' => 'required|string',
            'building_number' => 'nullable|numeric',
            'lga' => 'required|string|max:255',
            'bustop' => 'required|string|max:255',
            'business_category' => 'required|string|max:255'
        ]);

        if($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
        $id = self::generateKycId();
        // var_dump($id);die();
        $userId = auth()->user()->id;
        $user = User::find($userId);
        if($user->kyc_status == 1){
            return response()->json(['data' => 'Kyc Already updated'], 422);
        }else{
            $kycDetails = new kycdetail();
            $kycDetails->id = $id;
            $kycDetails->website = $request->website;
            $kycDetails->full_address = $request->full_address;
            $kycDetails->building_numbers = $request->building_number;
            $kycDetails->lga = $request->lga;
            $kycDetails->bustop = $request->bustop;
            $kycDetails->business_category = $request->business_category;
            $user->kycdetail()->save($kycDetails);
            User::where('id', $userId)->update(['kyc_status' => 1]);
            $kycresult = kycdetail::where('id', $id)->first();
            return response()->json(['data' => $kycresult], 200);
        }
    }

    public function registerKycForThirdParty() {

    }


    public static function generateKycId() {

        $prefix = 'lasaakyc' ;
        $suffix = rand(100, 999);
        $current = Carbon::now()->format('YmdHis');
        return $prefix . $current . $suffix;

    }
}
