<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\MobilePayment;
use App\Models\PaymentOnPremise;
use App\Models\PaymentStreetLamp;
use App\Models\PaymentThirdPartyMobile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PaymentHistoryController extends Controller {
    //
    public function __construct() {

        $this->middleware('auth:api');
    }


    public function getMobilePaymentHistory() {

        $user = Auth::user();
        $userId = $user->id;
        $getMobilePayment = MobilePayment::select('application_purpose', 'amount_paid','payment_id', 'created_at')
                                                                            ->where('user_id', $userId)->orderBy('created_at', 'desc')->paginate(20);

        if(count($getMobilePayment) > 0) {
            return response()->json(['data' => $getMobilePayment], 200);
        } else {
            return  response()->json(['data' => "No data available"], 200);
        }
    }

    public function getThirdPartyMobilePaymentHistory() {

        $user = Auth::user();
        $userId = $user->id;
        $getThirdPartyMobile = PaymentThirdPartyMobile::select('application_purpose', 'amount_paid', 'payment_id', 'created_at')
                                                                                                        ->where('user_id', $userId)->orderBy('created_at', 'desc')->paginate(20);

        if(count($getThirdPartyMobile) > 0) {
            return response()->json(['data' => $getThirdPartyMobile], 200);
        } else {
            return response()->json(['data' => 'No data available'], 200);
        }
    }

    public function getStreetLampPaymentHistory() {

        $user = Auth::user();
        $userId = $user->id;
        $getStreetLamp = PaymentStreetLamp::select('application_purpose', 'amount_paid', 'payment_id', 'created_at')
                                                                                                        ->where('user_id', $userId)->orderBy('created_at', 'desc')->paginate(20);

        if(count($getStreetLamp) > 0 ) {
            return response()->json(['data' => $getStreetLamp], 200);
        } else {
            return response()->json(['data' => 'No data available'], 200);
        }
    }

    public function getOnpremisePaymentHistory() {

        $user = Auth::user();
        $userId = $user->id;
        $getOnpremise = PaymentOnPremise::select('application_purpose', 'amount_paid', 'payment_id', 'created_at')
                                                                                        ->where('user_id', $userId)->orderBy('created_at', 'desc')->paginate(20);
        if(count($getOnpremise) > 0) {
            return response()->json(['data' => $getOnpremise], 200);
        } else {
            return  response()->json(['data' => 'No data available'], 200);
        }
    }
}
