<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\kycdetail;

use App\Models\StreetLampInfo;
use App\Models\StreetLampsAds;
use App\Models\ThirdPartyMobile;
use App\Models\ThirdPartyMobileVehicleLicense;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use js\tools\numbers2words\Speller;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class QrCodeController extends Controller
{
    //
//
//    public function generateMobileAdsQrcode($mobileId) {
//        $getMobileInfo = mobilead::select('brand_name', 'branding_details', 'due_date')->where('id', $mobileId)->first();
//        $qrImage = self::generateQrCode($getMobileInfo);
//        return response($qrImage);
//    }

//    public function generateThirdPartyMobileQrcode($mobileId) {
//        $getThirdPartyMobileInfo = ThirdPartyMobile::select('brand_name', 'branding_details', 'due_date')->where('id', $mobileId)->first();
//        $qrImage = self::generateQrCode($getThirdPartyMobileInfo);
//        return response($qrImage);
//    }

    public function generateStreetLampQrcode($streetLampId) {

        $getStreetLampInfo = StreetLampsAds::where('id', $streetLampId)->with('user')->get();
        $getStreetCategoryInfo = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->get();
        $countStreet = count($getStreetCategoryInfo) - 1;
        $totalpole = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('number_poles');
        $siteAddress = $getStreetCategoryInfo[0]['site_address'];
        $getAddress = kycdetail::where('user_id', $getStreetLampInfo[0]['user']['id'])->get();
        if($getStreetLampInfo[0]['ref_no'] == null) {
            $getReference = self::generateReferenceNumber($getStreetLampInfo[0]['start_date']);
            StreetLampsAds::where('id', $streetLampId)->update(['ref_no' => $getReference]);
        } else {
            $getReference = $getStreetLampInfo[0]['ref_no'];
        }
        $poleInWords = self::getNumberInWords($totalpole);

        $siteAddress = [];
        $widthSign = [];
        $heightSign = [];
        $poles = [];

        for ($i=0;  $i <= $countStreet; $i++) {
            $siteAddress [] = $getStreetCategoryInfo[$i]['site_address'];
            $widthSign [] = $getStreetCategoryInfo[$i]['width_sign'];
            $heightSign [] = $getStreetCategoryInfo[$i]['height_sign'];
            $poles [] = $getStreetCategoryInfo[$i]['number_poles'];
        }
        $combinedArray = [];
        foreach ($siteAddress as $index => $value) {
            $combinedArray [] = [
                'key' => $value,
                'value' => $widthSign[$index],
                'extra' => $heightSign[$index],
                'poles' => $poles[$index]
            ];
        }
        //var_dump($combinedArray); die();
       $data  =  [
           'date' => Carbon::parse($getStreetLampInfo[0]['start_date'])->format('d F Y'),
           'businessname' => $getStreetLampInfo[0]['user']['business_name'],
           'address' => $getAddress[0]['full_address'] ,
             'signtype' => 'Street Lamp Pole',
            'size' => $getStreetCategoryInfo[0]['weight_sign'],
            'totalPole' => $totalpole,
           'poleinWord' => $poleInWords,
           'startdate' => Carbon::parse($getStreetLampInfo[0]['start_date'])->format('d F Y'),
            'duration' => Carbon::parse($getStreetLampInfo[0]['due_date'])->format('d F Y'),
           'refNo' => $getReference
      ];

        $pdf = Pdf::loadView('letter', compact('data', 'combinedArray'));
        return $pdf->download('letter.pdf');
    }

    public function generateThirdPartyMobile($mobileId) {

        $getThirdpartyDetails  =  ThirdPartyMobile::where('id', $mobileId)->with('user')->get();
        $getThirdPartyInfo = ThirdPartyMobileVehicleLicense::where('third_party_mobile_id', $mobileId)->get();
        $getAddress = kycdetail::where('user_id', $getThirdpartyDetails[0]['user']['id'])->get();
        if($getThirdpartyDetails[0]['ref_no'] == null) {
            $getReference = self::generateThirdpartyReferenceNumber($getThirdpartyDetails[0]['start_date']);
            ThirdPartyMobile::where('id', $mobileId)->update(['ref_no' => $getReference]);
        } else {
            $getReference = $getThirdpartyDetails[0]['ref_no'];
        }

        $duration = $getThirdpartyDetails[0]['duration'];
        $countThirdparty = count($getThirdPartyInfo) - 1;

        $vehicleLicense = [];
        $vehicleType = [];
        for($i=0;$i<=$countThirdparty; $i++) {
            $vehicleLicense [] = $getThirdPartyInfo[$i]['vehicle_license'];
            $vehicleType [] = $getThirdPartyInfo[$i]['vehicle_type'];
        }

        $getUnique = array_unique($vehicleType);
        $getUnique = array_values($getUnique);
//        var_dump($getUnique); die();
        $countType =count($getUnique) - 1;



        $combinedArray = [];
        foreach ($vehicleLicense as $index => $value) {
            $combinedArray [] = [
                'key' => $value,
                'value' => $vehicleType[$index]
            ];
        }

        $data = [
            'data' => Carbon::parse($getThirdpartyDetails[0]['start_date'])->format('d F Y'),
            'businessname' => $getThirdpartyDetails[0]['user']['business_name'],
            'address' => $getAddress[0]['full_address'],
            'startdate' => Carbon::parse($getThirdpartyDetails[0]['start_date'])->format('d F Y'),
            'duedate' => Carbon::parse($getThirdpartyDetails[0]['due_date'])->format('d F Y'),
            'refNo' => $getReference,
            'duration' => $duration
        ];

        $pdf = Pdf::loadView('pav', compact('data', 'combinedArray', 'countType', 'getUnique'));
        return $pdf->download('pav.pdf');

    }

//    public function generateOnpremiseQrcode($onpremiseId) {
//        $getOnpremiseInfo = onpremise::select('purpose_of_application', 'name_of_owner')->where('id', $onpremiseId)->first();
//        $qrImage = self::generateQrCode($getOnpremiseInfo);
//        return response($qrImage);
//    }

//    protected static function generateQrCode($entityObj) {
//        $content = $entityObj;
//        $generatedQrCode = QrCode::size(100)
//            ->backgroundColor(255, 255, 204)
//            ->generate($content);
//        return $generatedQrCode;
//    }

//    public  function generatePDf() {
//
//        $pdf = Pdf::loadView('letter');
//        return $pdf->download('letter.pdf');
//    }

    protected static function generateReferenceNumber($getDate) {
        $getDate = Carbon::parse($getDate)->format('ymd');
        $staticPart = '/SLP/ETO/';
        $number = mt_rand(001, 100);
        return $getDate. $staticPart.$number;
    }

    protected static function generateThirdpartyReferenceNumber($getDate) {
        $getDate = Carbon::parse($getDate)->format('y/m');
        $staticPart = 'LASAA/MA/';
        $number = mt_rand(001, 100);
        return $staticPart.$getDate.$number;
    }

    protected static function getNumberInWords($getnumber) {

        $words = Speller::spellNumber($getnumber, Speller::LANGUAGE_ENGLISH);
        return $words;
    }
}
