<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class WhitelistIPMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $allowedIP = [
            '198.54.115.178',
            '54.86.50.139',
            '35.240.27.43'
        ];

        $clientIP = $request->ip();

        if(!in_array($clientIP, $allowedIP)) {
            return response($clientIP, 403);
        }
        return $next($request);
    }
}
