<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppHistoryStreetLamp extends Model
{
    use HasFactory;

    protected $table = 'app_history_street_lamp';

    protected $fillable = [
        'purpose',
        'who_performed_action',
        'comments',
        'report_from_branchmanager',
        'ads_price'
    ];

    public function streetLampsAds() {
        return $this->belongsTo(StreetLampsAds::class);
    }
}
