<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FirstPartyTemporaryAds extends Model
{
    use HasFactory;

    protected $table = 'first_party_temporary_ads';

    protected $fillable = [
       'name_of_company',
       'company_address',
       'lga',
       'name_of_service',
        'site_location',
        'start_date',
        'end_date',
        'duration',
        'name_of_company',
        'zone',
        'rm_comment',
        'hod_comment',
        'md_comment'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function firstPartyTemporaryAdsDetails() {
         return $this->hasMany(FirstPartyTemporaryAdsDetails::class);
    }

    public function paymentFirstPartyTemporaryAds() {
        return $this->hasMany(PaymentFirstPartyTemporaryAds::class);
    }

    public function  appHistoryFirstPartyTemporaryAds() {
        return $this->hasMany(AppHistoryFirstPartyTemporaryAds::class);
    }
    
    public function firstpartytemporaryreceipts() {
         return $this->hasMany(FirstPartyTemporaryReceipts::class);
    }
}
