<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StreetLampPricing extends Model
{
    use HasFactory;

    protected $table = 'street_lamp_pricing';

    protected $fillable = [
        'street_category',
        'type_of_sign',
        'annual_permit_price',
        'half_year_permit_price',
        'monthly_permit_price',
        'annual_admin_price',
        'half_year_admin_price',
        'monthly_admin_price',
        'legal_percentage'
    ];

    protected $casts = [
        'annual_permit_price' => 'double',
        'half_year_permit_price' => 'double',
        'monthly_permit_price' => 'double',
        'annual_admin_price' => 'double',
        'half_year_admin_price' => 'double',
        'monthly_admin_price' => 'double',
        'legal_percentage' => 'double'
    ];

    public static function getCategories()
    {
        return [
            'Normal Zone N',
            'Restrictive Zone N',
            'High Street N',
            'Special N'
        ];
    }

    public static function getSignTypes()
    {
        return [
            'FLEX',
            'BACKLIT',
            'LED'
        ];
    }
}