<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!--<title>Bill/Invoice for 2536272</title>-->

    <style>
      * {
        text-align: center;
        letter-spacing: 2.4px;
        margin: 0;
        padding: 0;
        vertical-align: top;
      }

      body {
        font-family: Verdana, Geneva, Tahoma, sans-serif;
        margin: 0;
        padding: 0;
      }

      .container {
        width: 1024px;
        margin: 20px auto;
      }

      .contentHolder {
        height: 100%;
        padding: 20px;
      }

      .docHeader {
        border: 1.5px solid #3889a6;
        padding: 10px 0;
        margin-bottom: 20px;
      }

      .docHeader img {
        display: block;
        margin: 0 auto;
        width: 250px;
      }

      .docHeader h1 {
        color: #0a526c;
        font-size: 24px;
        font-weight: 900;
      }

      .clientInfo .infoSides {
        border: 1.5px solid #3889a6;
        padding: 10px;
        margin-bottom: 10px;
        display: inline-block;
        width: 46%;
      }

      .infoData {
        margin-bottom: 5px;
        text-align: start;
      }

      .infoData span {
        display: inline-block;
        width: 60%;
        font-size: 15px;
        text-align: start;
      }

      .infoData span.title {
        font-size: 15px;
        font-weight: 600;
        text-align: start;
        width: 35%;
      }

      .noticeComment {
        border: 1.5px solid #3889a6;
        padding: 10px;
        margin: 10px 0;
      }

      .noticeComment p {
        text-align: start;
      }

      .noticeComment .title {
        font-size: 15px;
        font-weight: 600;
        margin-bottom: 20px;
      }

      .totalCost {
        border: 1.5px solid #3889a6;
        padding: 10px;
        margin: 10px 0;
      }

      .inWord {
        margin: 15px 0;
      }

      .inWord .title {
        width: 25%;
        text-align: start;
        font-weight: 600;
        display: inline-block;
        vertical-align: middle;
      }

      .inWord .wordInfo {
        font-size: 18px;
        font-weight: 600;
        text-align: start;
        display: inline-block;
        width: 70%;
      }

      .signatureTerms {
        border: 1.5px solid #3889a6;
        padding: 10px;
        margin: 10px 0;
      }

      .signatureTerms .infoSides {
        display: inline-block;
        width: 46%;
      }

      .signatureTerms .smallWidth {
        width: 300px;
        margin: 0 auto;
      }

      .signatureTerms .smallWidth p {
        font-weight: 600;
      }

      .smallWidth .signatureTitle {
        display: inline-block;
        border-top: 2px solid black;
        margin-top: 10px;
      }

      .smallWidth .date {
        border-bottom: 2px solid black;
        margin-bottom: 5px;
        padding-bottom: 5px;
        display: inline-block;
      }

      .signatureTerms h1 {
        font-weight: 600;
      }

      .addressPrompt {
        border: 1.5px solid #3889a6;
        padding: 10px;
        margin: 10px 0;
      }

      .addressPrompt p {
        font-size: 12px;
        font-weight: 400;
      }
    </style>
  </head>
  <body>
    <div class="container">
      <div class="contentHolder">
        <div class="docHeader">
          <img src="lasaa-web-logo.png" alt="logo" />
          <h1>DEBIT/CREDIT NOTE</h1>
        </div>

        <div class="clientInfo">
          <div class="infoSides">
            <div class="infoData">
              <span class="title">Company Name</span>
              <span>{{ $data['company'] }}</span>
            </div>
            <div class="infoData">
              <span class="title">Office Address</span>
              <span>{{ $data['address'] }}</span>
            </div>
            <div class="infoData">
              <span class="title">Email</span>
              <span>{{ $data['email'] }}</span>
            </div>
          </div>
          <div class="infoSides">
            <div class="infoData">
              <span class="title">Customer ID</span>
              <span>{{ $data['cust_id'] }}</span>
            </div>
            <div class="infoData">
              <span class="title">Ref No</span>
              <span>{{ $data['ref_no'] }}</span>
            </div>
            <div class="infoData">
              <span class="title">App Type</span>
              <span>{{ $data['user_type'] }}</span>
            </div>
          </div>
        </div>

        <div class="noticeComment">
          <p class="title">Comment:</p>
          <p>{{ $data['comment'] }}</p>
        </div>

        <div class="totalCost">

          <div class="inWord">
            <i class="title">Initial Total Due:</i>
            <span class="wordInfo">
              NGN {{ $data['initial_amount_due'] }}
            </span>
          </div>

          <div class="inWord">
          @if ($data['note_type'] == 'debit')
            <i class="title">Debit Amount:</i>
            <span class="wordInfo">
              NGN {{ $data['debit'] }}
            </span>
          @elseif ($data['note_type'] == 'credit')
            <i class="title">Credit Amount:</i>
            <span class="wordInfo">
              NGN {{ $data['debit'] }}
            </span>
          @elseif ($data['note_type'] == 'change')
          <i class="title">Credit Amount:</i>
            <span class="wordInfo">
              NGN {{ $data['debit'] }}
            </span>
        <i class="title">Debit Amount:</i>
            <span class="wordInfo">
              NGN {{ $data['credit'] }}
            </span>
          @endif
          </div>

          <div class="inWord">
            <i class="title">Total Amount Due:</i>
            <span class="wordInfo">
            @if ($data['note_type'] == 'debit')
              NGN {{ $data['initial_amount_due'] - $data['debit'] }}
            @elseif ($data['note_type'] == 'credit')
              NGN {{ $data['initial_amount_due'] + $data['debit'] }}
            @elseif ($data['note_type'] == 'change')
              NGN {{ $data['initial_amount_due'] + $data['debit'] -  $data['credit']}}
            @endif
            </span>
          </div>

          <div class="inWord">
            <i class="title">Amount in words:</i>
            <span class="wordInfo">
              {{ $data['amount_in_words'] }}
            </span>
          </div>
        </div>

        <div class="signatureTerms">
          <div class="dateSign">
            <div class="infoSides">
              <div class="smallWidth">
                <img src="MD-SIGNATURE.png" alt="" />
                <p class="signatureTitle">AUTHORIZED SIGNATURE</p>
              </div>
            </div>
            <div class="infoSides">
              <div class="smallWidth" style="vertical-align: middle; margin-top: 20px;">
                <p class="date">{{ $data['date'] }}</p>
                <p>DATE</p>
              </div>
            </div>
          </div>
        </div>

        <div class="addressPrompt">
          <p>
            Head Office Address: 33 Mobolaji Johnson Avenue, Eleganza
            Plaza, Opposite 7Up, Ikeja , Lagos State
          </p>
        </div>
      </div>
    </div>
  </body>
</html>