<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f9f9f9;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            background-color: #ffffff;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 100%;
            height: auto;
        }
        .date-ref {
            text-align: right;
            margin-bottom: 20px;
        }
        .content {
            margin-bottom: 20px;
        }
        .content p {
            margin: 0 0 10px;
        }
        .signature {
            margin-top: 30px;
        }
        .signature p {
            margin: 0;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <img src="lasaa-web-logo.png" alt="LASAA Logo">
    </div>
    <div class="date-ref">
        <p>{{ $data['date'] }}</p>
        <p></p>
    </div>
    <div class="content">
        <p>{{ $data['userinfo'] }}<br>
        {{ $data['useraddress'] }}<br>
        {{ $data['bustop'] }}<br>
        {{ $data['lga'] }}</p>
        <br>
        <p>Dear Sir/Ma,</p>
        <br>
        <p style="text-align: center;"><strong>TEMPORARY PERMIT NO: {{ $data['permitNumber'] }}</strong></p>
        <br>
        <p>We hereby grant you a temporary permit for
            @foreach($combinedArray as $item) <b>{{$item['key']}} ({{$item['value']}}),</b>@endforeach to be used for “{{ $data['nameAds'] }}” road show campaign in line with the route plan and photomontage attached to your application form.</p>
        <p>Your permit is valid for {{ $data['validityInWords'] }} ({{ $data['validity'] }}) Day(s): {{ $data['startdate'] }} to {{ $data['enddate'] }}.</p>
        <p>At the end of the campaign, you will be expected to discontinue the display. Failure to adhere to this will be considered illegal and appropriate legal action will ensue.</p>
        <p>However, in case of under-declaration of promotion materials, a stiff penalty will be imposed on your organization.</p>
        <p>Kindly note that in the event of a cancellation or change of a campaign date, 20% of the total amount paid would be deducted as administrative charges and a refund would only be granted if a supporting letter from the client is submitted to the Agency stating cogent reason(s) for such change.</p>
        <p>Thank you for your cooperation.</p>
        <br>
        <p>Yours faithfully,</p>
    </div>
    @if($data['usertype'] == 'first_party')
        <div class="signature">
            <p>Olubukonla Ayodele</p>
            <p>Head, Mobile Advert Department</p>
            <p>For: Managing Director/CEO</p>
        </div>
@else
        <div class="signature">
            <img src="MD-SIGNATURE.png" alt="MD signature">
            <p>Prince Fatiu Akiolu</p>
            <p><b>Managing Director/CEO.</b></p>
        </div>
@endif
</body>
</html>
