<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!--<title>Bill/Invoice for 2536272</title>-->

    <style>
      body {
        margin: 0;
        padding: 0;
        line-height: 1.6;
      }
      .container {
        max-width: 707px;
        margin: 20px auto;
        padding: 5px 10px;
        border: 1.5px solid #3889a6;
      }
      h1 {
        text-align: center;
        margin-bottom: 20px;
      }
      p {
        margin-bottom: 15px;
      }
      .image-container {
        text-align: end;
      }
      .image-container img {
        max-width: 100%;
        width: 250px;
        height: auto;
      }

      a {
        text-decoration: none;
        color: #000;
      }

      .costList {
        max-width: 730px;
        margin: 20px auto;
      }

      .costList table {
        font-size: 14px;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        width: 100%;
      }

      .costList thead {
        background: rgb(7, 119, 159);
        background: linear-gradient(
          0deg,
          rgba(7, 119, 159, 1) 0%,
          rgba(22, 164, 212, 1) 100%
        );
        border-bottom: 1.5px solid #0a526c;
      }

      .costList table th {
        padding: 2.5px;
        color: #fff;
        text-align: start;
      }

      .costList table th:first-child {
        border-left: solid 1.5px #3889a6;
      }

      .costList table th:last-child {
        border-right: solid 1.5px #3889a6;
      }

      .costList table th:not(:last-child) {
        border-right: 1.5px solid #fff;
      }

      .costList tbody {
        border: solid 1.5px #3889a6;
      }

      .costList tbody td {
        text-align: start;
        padding: 6px 2.5px;
        vertical-align: middle;
      }

      .costList tbody tr:nth-child(even) {
        background-color: #f1f9fc;
      }
    </style>
  </head>

  <body>
    <div class="container">
      <div class="image-container">
        <img src="lasaa-web-logo.png" alt="" />
      </div>

      <p style="display: inline-block;">{{ $data['date'] }}</p>

      <div style="float:right;">
        <img style="width: 200px; height: auto;" src="barCode.png" alt="">
        <span style="display: block; font-size: 20px;">{{ $data['barcode'] }}</span>
      </div>

      <p>
        <strong>The Managing Director/CEO</strong> <br />
        {{ $data['company'] }}, <br />
        {{ $data['address'] }}.
      </p>

      <p>Dear Sir/Madam</p>

      <p style="text-decoration: underline">
        <strong>DISAPPROVAL FOR FIRST PARTY SIGNAGE ADVERTISEMENT SIGN</strong>
      </p>

      <p>
        We refer to your application {{ $data['ref_id'] }} for the deployment
        of a @foreach($combinedArray as $item){{$item['key']}} of Up to {{$item['value']}}sqm
        @endforeach at {{ $data['address'] }} and hereby inform you that the request has been disapproved.
      </p>
      <p>
        {{ $data['comment'] }}
      </p>
      <p>
        The disapproved results from the fact that the Signage in not in
        conformity with the Agency's regulations.
      </p>

      <p>
        Therefore, pursuant to Section 27(4) of the Lagos State Structures for
        Signage and Advertisement Agency Law, 2006 (as amended), you are hereby
        advised to refrain from displaying the disapproved advertisement
        structure on the said site within 10 days, failing which Agency shall
        direct the removal of same and a penalty will be imposed.
      </p>

      <p>Thank you for your cooperation in this regard.</p>

      <p>Yours faithfully</p>

      <!--<div>-->
      <!--  <img src="MD-SIGNATURE.png" alt="" />-->
      <!--</div>-->

      <p>
        Taiwo Abdul <br />
        <strong>Monitoring and Inspection Department </strong>
      </p>

      <p style="text-align: center; border-bottom: 1.5px solid #000">
        Lagos State Signage & Advertisement Agency
      </p>

      <p style="text-align: center">
        Eleganza Plaza, 33, Mobolaji Johnson Avenue, Ikeja, Lagos <br />
        <a href="tel:+2349088019303">Tel: +234 908 801 9303</a>
        <a href="mailto:info@lasaa.com">Email: info@lasaa.com</a>
        <a href="www.lasaa.com">Website: www.lasaa.com</a>
      </p>
    </div>
  </body>
</html>
