<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        .container {
            margin: 20px;
        }
        .header {
            margin-bottom: 20px;
            text-align: center;
        }
        .header img {
            width: 200px;
        }
        .content {
            margin-bottom: 20px;
        }
        .footer {
            margin-top: 20px;
        }
        .sign-info-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .sign-info-table th, .sign-info-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .sign-info-table th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="lasaa-web-logo.png" alt="LASAA Logo">
        </div>
        <div class="content">
            <p>{{ $data['date'] }}</p>
            <p>Application No: {{ $data['appId'] }}</p>
            <p>The Managing Director/CEO<br>
            {{ $data['companyName'] }}<br>
            {{ $data['officeAddress'] }}<br>
            Lagos.</p>

            <p>Dear Sir/Madam,</p>

            <p><strong>APPROVAL/PERMIT FOR DISPLAY OF THIRD PARTY OUTDOOR SIGNS</strong></p>

            <p>The Agency is pleased to inform you that your application for the {{ $data['signageRequest'] }} of your {{$data['signageWidth']}}m by {{$data['signageHeight']}}m ({{$data['signageDimension']}}sqm) {{ $data['signageName'] }} ({{ $data['signageSide'] }} sided) at {{ $data['signageSite'] }} Lagos with application number {{$data['appId']}} to a {{$data['signageWidth']}}m by {{$data['signageHeight']}}m ({{$data['signageDimension']}}sqm) {{$data['signageName']}}  is successful after due appraisal. The documents you forwarded to the Agency in support thereof were found to be satisfactory. Consequently and always subject to the standard terms and conditions therein contained you are hereby granted a “Signage Permit” in line with the Lagos State Structures for Signage and Advertisement Agency Law 2006 (as renewed in 2017). You may therefore proceed with the installation of the outdoor advertising structure in accordance with the Agency’s approved specifications. The following sign has been approved:</p>

            <table class="sign-info-table">
                <tr>
                    <th>Sign Display ID</th>
                    <th>Sign Type Name</th>
                    <th>Sign Width</th>
                    <th>Sign Height</th>
                    <th>Size (sqm)</th>
                    <th>Proposed Duration</th>
                    <th>Face</th>
                </tr>
                <tr>
                    <td>{{ $data['signageId'] }}</td>
                    <td>{{ $data['signageName'] }}</td>
                    <td>{{ $data['signageWidth'] }}</td>
                    <td>{{ $data['signageHeight'] }}</td>
                    <td>{{ $data['signageDimension']}}</td>
                    <td>{{ $data['signageDuration'] }}</td>
                    <td>{{ $data['signageSide'] }}</td>
                </tr>
            </table>

            <p>Please find herewith attached the conditions of approval which must be satisfied within 30 days of receipt of this letter. However, note that failure to discharge these conditions would result in a fine and could ultimately lead to the revocation of your permit/approval.</p>

            <p>On receipt of payment, the Agency will issue the “Approval Number” for your structure and it will be included on our list of approved structures. You will be expected to make payment within a period of 30 (thirty) days of receipt of this letter. The Agency reserves the right to revoke this approval on the ground of non-payment of permit charges as at due date or commission of infraction(s) inimical to the development of outdoor regulation in the State.</p>

            <p>Finally, your site approval is granted for a period of three years and you will be expected to renew the annual permit by a yearly payment of the published ‘permit’ rate applicable to the size of your structure. Congratulations on the grant of your “Outdoor Structure Permit”.</p>
        </div>
        <div class="footer">
            <p>Thank you.</p>
            <p>Yours faithfully,</p>
            <img src="MD-SIGNATURE.png" alt="MD signature">
            <p><strong>Prince Fatiu Akiolu</strong><br>Managing Director/CEO</p>
        </div>
    </div>
</body>
</html>
