<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 20px;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 200px;
        }
        .header-text {
            text-align: right;
            margin-bottom: 20px;
        }
        .header-text p {
            margin: 0;
        }
        .content {
            margin-bottom: 20px;
        }
        .content p {
            margin: 0 0 10px;
        }
        .table-container {
            margin-top: 20px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .signature {
            margin-top: 30px;
        }
        .signature p {
            margin: 0;
        }
        .conditions {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
        }
        .conditions p {
            margin: 0 0 10px;
        }
        .conditions ol {
            margin: 10px 0;
            padding-left: 20px;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <img src="lasaa-web-logo.png" alt="LASAA Logo">
    </div>
    <div class="header-text">
        <p>{{ $data['date'] }}</p>
        <p>Ref No: {{ $data['refno'] }}</p>
    </div>
    <div class="content">
        <p>The Managing Director/CEO</p>
        <p>{{ $data['company'] }}</p>
        <p>{{ $data['address'] }}</p>
        <p>{{ $data['bustop'] }}</p>
        <p>{{ $data['lga'] }}</p>
        <br>
        <p>Dear Sir/Ma,</p>
        <br>
        <p><strong>APPROVAL FOR SMALL FORMAT ADS</strong></p>
        <br>
        <p>The Agency is pleased to inform you that your application to deploy one branded building displaying Tasty Cubes Chicken Flavour advert has been successful after due appraisal.</p>
        <p>The document you forwarded to the Agency in support thereof were found to be satisfactory.</p>
        <p>Subject to the standard terms and conditions therein contained, you are hereby granted a “Signage Permit” for a period of {{$data['numberMonths']}} months ({{ $data['startDate'] }} to {{ $data['endDate'] }}).</p>
        <p>Kindly comply with the stipulated conditions for approval.</p>
        <p>You are therefore advised to proceed with deployment in accordance with the Agency’s approved specifications. The under listed application has been approved.</p>
    </div>
    <div class="table-container">
        <table>
            <tr>
                <th>S/N</th>
                <th>LOCATION</th>
                <th>APPLICATION NUMBER</th>
                <th>SIGN TYPE</th>
            </tr>
            <tr>
                <td>1</td>
                <td>{{ $data['siteLocation'] }}</td>
                <td>{{ $data['appNumber'] }}</td>
                <td>{{ $data['signType'] }}</td>
            </tr>
        </table>
    </div>
    <div class="content">
        <p>Congratulations on the grant of your “Outdoor Structure Permit”.</p>
        <p>Thank you.</p>
        <br>
        <p>Yours faithfully,</p>
        <div class="signature">
            <img src="MD-SIGNATURE.png" alt="MD signature">
            <p>Prince Fatiu Akiolu</p>
            <p><b>Managing Director/CEO.</b></p>
        </div>
    <div class="conditions">
        <p>Kindly note that failure to discharge the under listed conditions would result in a fine and could ultimately lead to the revocation of your permit/approval.</p>
        <br>
        <p><strong>CONDITIONS FOR APPROVAL</strong></p>
        <ol>
            <li>The approved structure must be maintained to the Agency’s standards. Deterioration of structure below standard may lead to the revocation of your permit.</li>
            <li>Your Organization is advised to pay within the stipulated period. Failure to do so will lead to the revocation of the permit.</li>
            <li>Finally, your site approval is granted for a period of three (3) years and you will be expected to renew the annual permit by a yearly payment of the published “permit” rate applicable to the size of your structure.</li>
        </ol>
    </div>
</div>
</body>
</html>
