<?php

namespace App\Http\Controllers\Api;

date_default_timezone_set('Africa/Lagos');

use App\Http\Controllers\Controller;
use App\Http\Controllers\Util\UtilMethods;
use App\Models\AdminActivity;
use App\Models\Apphistory;
use App\Models\AppHistoryMobile;
use App\Models\AppHistoryStreetLamp;
use App\Models\mobilead;
use App\Models\MobileAdsVehicleLicense;
use App\Models\onpremise;
use App\Models\OnpremiseInfo;
use App\Models\OnPremiseRemoval;
use App\Models\OnPremiseAdditional;
use App\Models\OnPremiseChange;
use App\Models\OnPremiseMultiple;
use App\Models\PermitStepMobile;
use App\Models\PermitStepOnpremise;
use App\Models\StreetLampInfo;
use App\Models\StreetLampsAds;
use App\Models\ThirdPartyMobile;
use App\Models\ThirdPartyMobileAppHistory;
use App\Models\ThirdPartyMobileVehicleLicense;
use App\Models\User;
use App\Models\OnpremiseReceipts;
use App\Models\UserAdmin;
use App\Models\OnPremisePricingRule;
use App\Models\OnpremiseApplicationPricingRule;
use App\Models\StreetLampPricing;
use App\Models\MobileAdsPricing;
use App\Models\ThirdPartyMobileAdsPricing;
use App\Models\MobileAdsApplicationPricing;
use App\Models\EmailContent;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Couchbase\LookupGetFullSpec;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;

class AdminApprovalController extends Controller
{
    //

    public function declineMobileAds($mobileId, Request $request) {
        $validate = Validator::make($request->all(), [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $getStatus = mobilead::find($mobileId);

        if($getStatus->status  !== 'declined' && $getStatus->status == 'pending' && $getStatus->hod_permit_status !== 'pending') {
            $user = Auth::user();
            $declined = mobilead::where('id', $mobileId)->update(['status' => 'declined', 'hod_permit_status' => 'declined', 'legal_status' => 'declined',
                                                                                        'final_status' => 'declined']);
            $getupdate = mobilead::where('id', $mobileId)->get();

            $getApplicant = User::where('id', $getupdate[0]['user_id'])->get();
            $getApplicantEmail = $getApplicant[0]['email'];
            $emailsubject = EmailContent::getContent('mobile_decline_approve_subject');
            $emailcontent = EmailContent::getContent('mobile_decline_content');
            $subject = $emailsubject;
            $body = $emailcontent . " " . " " . $request['comments'] . " " . " " . $request['reports_from_branchmanger'];
            //$this->composeEmail($subject, $body, $getApplicantEmail);
            $templateData = [
                'body' => $body,
                'name' => $getApplicant[0]['business_name'],
            ];
            $templateContent = view('emailtemplate', $templateData)->render();
            $this->composeEmailV2($subject, $getApplicantEmail, $templateContent);

            $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
            if ($getCreateby) {
                $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
                $getCreatebyEmail = $getAdmin[0]['email'];
                $this->composeEmailV2($subject, $getCreatebyEmail, $templateContent);
            }

            $declineId = mobilead::find($getupdate[0]['id']);

            $appHistoryMobile = new AppHistoryMobile();
            $appHistoryMobile->purpose = 'Mobile ads Application';
            $appHistoryMobile->who_performed_action = $user->id;
            $appHistoryMobile->comments = $request['comments'];
            $appHistoryMobile->reports_from_branchmanger = $request['reports_from_branchmanger'];
            $reportFile = $request['report_file'];
            $appHistoryMobile->report_file = $this->convertBase64toPdf($reportFile);
            $appHistoryMobile->ads_price = $request->ads_price;
            $denial = $declineId->appHistoryMobile()->save($appHistoryMobile);

            $activityInfo = new AdminActivity();
            $fetchActivity = 'Decline a mobile ads with adsId' . $mobileId;
            $activityInfo->action = $fetchActivity;
            $savedActivity = $user->adminActivity()->save($activityInfo);

            $getAppHistory = AppHistoryMobile::where('mobilead_id', $mobileId)->get();
            return response()->json(['data' => $getAppHistory], 200);
        } else {
            return response()->json(['data' => 'Can not treat mobile ads!'], 422);
        }
    }

    public function declineThirdPartyMobile($mobileId, Request $request) {
        $validate = Validator::make($request->all(), [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }

        $user = Auth::user();

        $declined = ThirdPartyMobile::where('id', $mobileId)->update(['status' => 'declined']);
        $getupdate = ThirdPartyMobile::where('id', $mobileId)->get();
        //var_dump($getupdate[0]['brand_name']); die();
        $declineId = ThirdPartyMobile::find($getupdate[0]['id']);

        $getApplicant = User::where('id', $getupdate[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('pav_decline_approve_subject');
        $emailcontent = EmailContent::getContent('pav_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent. " " . " " . $request['comments'] . " ". " "
            . $request['reports_from_branchmanger'];
        //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],
        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
        if($getCreateby ) {
            $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
            $getCreatebyEmail = $getAdmin[0]['email'];
            $this->composeEmailV2($subject, $getCreatebyEmail,  $templateContent);
        }

        $appHistoryThirdPartyMobile = new ThirdPartyMobileAppHistory();
        $appHistoryThirdPartyMobile->purpose = 'Third Party Mobile Application';
        $appHistoryThirdPartyMobile->who_performed_action = $user->id;
        $appHistoryThirdPartyMobile->comments = $request['comments'];
        $appHistoryThirdPartyMobile->reports_from_branchmanager = $request['reports_from_branchmanger'];
        $reportFile = $request['report_file'];
        $appHistoryThirdPartyMobile->report_file = $this->convertBase64toPdf($reportFile);
        $appHistoryThirdPartyMobile->ads_price = $request->ads_price;
        $denial = $declineId->thirdPartyMobileAppHistory()->save($appHistoryThirdPartyMobile);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline a third party mobile ads with adsId'. $mobileId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $getAppHistory = ThirdPartyMobileAppHistory::where('third_party_mobile_id', $mobileId)->get();
        return response()->json(['data' =>$getAppHistory ], 200);
    }

    public function declinedOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'nullable|string|max:255',
            'report_file' => 'nullable|string',
            'onpremiseinfo_ids' => 'required|array',  // Ensures it's an array
            'onpremiseinfo_ids.*' => 'integer|exists:onpremise_info,id'  // Validates each array item is an integer and exists in the `onpremise_info` table
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        if(isset($request['reports_from_branchmanger'])){
            $bmcomment = $request['reports_from_branchmanger'];
        }else{
            $bmcomment = "";
        }
        if(isset($request['comments'])){
            $ucomment = $request['comments'];
        }else{
            $ucomment = "";
        }
        if($user->admin_role_id  == 1){
        $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'declined', 'bm_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3) && $user->department  == 'M_I'){
        $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'pending', 'rm_status' => 'declined', 'rm_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 5 && $user->department  == 'M_I'){
        $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'declined', 'rm_status' => 'declined', 'hod_status' => 'declined', 'hod_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 4){
        $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'audit_status' => 'declined', 'billing_status' => null, 'account_status' => null, 'audit_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3 || $user->admin_role_id  == 5) && $user->department  == 'Billings'){
        $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'billing_status' => 'declined', 'billing_comment' => $bmcomment]);
        }
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
        $onpremiseObj = onpremise::find($getonpremise[0]['id']);

        if($user->admin_role_id  == 1 || ($user->admin_role_id  == 5 && $user->department  == 'M_I')){
        $getApplicant = User::where('id', $getonpremise[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('onpremise_decline_approve_subject');
        $emailcontent = EmailContent::getContent('onpremise_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent . " " . " " . $request['comments'] . " ";
        //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        }

        $onpremiseAppHistory = new Apphistory();
        $reportFile = $request['report_file'];
        $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
        $onpremiseAppHistory->who_performed_action = $user->id;
        $onpremiseAppHistory->comments = $request['comments'];
        $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
        $onpremiseAppHistory->previous_ads_price = $getFindPrice['previous_ads_price'];
        $onpremiseAppHistory->current_ads_price = $getFindPrice['current_ads_price'];
        $onpremiseAppHistory->balance = $getFindPrice['balance'];
        $onpremiseAppHistory->bank_and_others = $getFindPrice['bank_and_others'];
        $onpremiseAppHistory->product_on_sign = $getFindPrice['product_on_sign'];
        $onpremiseAppHistory->ads_price = $getFindPrice['ads_price'];
        $onpremiseObj->appHistory()->save($onpremiseAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an onpremise ads with adsId'. $onpremiseId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get();
        
        
        $onpremiseinfoIds = $request->input('onpremiseinfo_ids');
        $OnpremiseInfo = OnpremiseInfo::whereIn('onpremise_id', $onpremiseinfoIds)->get();
        
        
        // $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'ref_id' => $onpremiseObj->payment_id,
                  'comment' => $request['comments'],
                  
             ];
            
             $pdf = Pdf::loadView('onpremisedisapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremisedisapproval.pdf');
             $commentletter = $request['comments'];
              $userObj = User::find($onpremiseObj->user_id);
             $body = "your application for first party signage display has been disapproved due to $commentletter. Please find your disapproval letter attached";
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendDisapproval($userObj->email, $templateContent, $fileObj);
             //Log::info('email sent to ' . $userObj->email);
        
        
        
        
        
        
        
        return response()->json(['data' => $onpremiseAppHistory], 200);
    }
    
    public function declinedRemovalOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'nullable|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        if(isset($request['reports_from_branchmanger'])){
            $bmcomment = $request['reports_from_branchmanger'];
        }else{
            $bmcomment = "";
        }
        if(isset($request['comments'])){
            $ucomment = $request['comments'];
        }else{
            $ucomment = "";
        }
        if($user->admin_role_id  == 1){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'declined', 'bm_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3) && $user->department  == 'M_I'){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'rm_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 5 && $user->department  == 'M_I'){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'declined', 'rm_status' => 'declined', 'hod_status' => 'declined', 'hod_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 4){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'audit_status' => 'declined', 'billing_status' => 'declined', 'audit_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 11){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'cp_status' => 'declined', 'cp_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3 || $user->admin_role_id  == 5) && $user->department  == 'Billings'){
        $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'billing_status' => 'declined', 'billing_comment' => $bmcomment]);
        }
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
        $onpremiseObj = onpremise::find($getonpremise[0]['id']);
        
        if($user->admin_role_id  == 1 || ($user->admin_role_id  == 5 && $user->department  == 'M_I')){
        $getApplicant = User::where('id', $getonpremise[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('onpremise_removal_decline_approve_subject');
        $emailcontent = EmailContent::getContent('onpremise_removal_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent . " " . " " . $request['comments'] . " ";
        //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        }


        $onpremiseAppHistory = new Apphistory();
        $reportFile = $request['report_file'];
        $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
        $onpremiseAppHistory->who_performed_action = $user->id;
        $onpremiseAppHistory->comments = $request['comments'];
        $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
        $onpremiseAppHistory->previous_ads_price = $getFindPrice['previous_ads_price'];
        $onpremiseAppHistory->current_ads_price = $getFindPrice['current_ads_price'];
        if($user->admin_role_id  == 4){
        $onpremiseAppHistory->balance = $getFindPrice['balance'] + $getFindPrice['ads_price'];
        }elseif($user->admin_role_id  == 11 && Carbon::now()->year > Carbon::parse(OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->updated_at)->year){
        $onpremiseAppHistory->balance = $getFindPrice['balance'] + $getFindPrice['ads_price'];
        }else{
        $onpremiseAppHistory->balance = $getFindPrice['balance'];   
        }
        $onpremiseAppHistory->bank_and_others = $getFindPrice['bank_and_others'];
        $onpremiseAppHistory->product_on_sign = $getFindPrice['product_on_sign'];
        $onpremiseAppHistory->ads_price = $getFindPrice['ads_price'];
        $onpremiseObj->appHistory()->save($onpremiseAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an onpremise ads with adsId'. $onpremiseId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get();
        
        
        

        $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->where('sign_to_remove', '>', 0)->get();
        
        
        // $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'ref_id' => $onpremiseObj->payment_id,
                  'comment' => $request['comments'],
                  
             ];
            
             $pdf = Pdf::loadView('onpremisedisapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremisedisapproval.pdf');
             $commentletter = $request['comments'];
              $userObj = User::find($onpremiseObj->user_id);
             $body = "your application for first party signage display has been disapproved due to $commentletter. Please find your disapproval letter attached";
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendDisapproval($userObj->email, $templateContent, $fileObj);
             //Log::info('email sent to ' . $userObj->email);
        
        
        $updateinfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($updateinfo) - 1;
        for($i=0;$i<=$count;$i++){
            $addup = $updateinfo[$i]['number_of_sign'] + $updateinfo[$i]['sign_to_remove'];
            $updateinfo[$i]->update(['number_of_sign' => $addup]);
        }
        
        
        
        
        
        return response()->json(['data' => $onpremiseAppHistory], 200);
    }
    
    public function declinedAdditionalOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'nullable|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        if(isset($request['reports_from_branchmanger'])){
            $bmcomment = $request['reports_from_branchmanger'];
        }else{
            $bmcomment = "";
        }
        if(isset($request['comments'])){
            $ucomment = $request['comments'];
        }else{
            $ucomment = "";
        }
        if($user->admin_role_id  == 1){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'declined', 'bm_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3) && $user->department  == 'M_I'){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'rm_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 5 && $user->department  == 'M_I'){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'declined', 'rm_status' => 'declined', 'hod_status' => 'declined', 'hod_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 4){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'audit_status' => 'declined', 'billing_status' => 'declined', 'audit_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 11){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'cp_status' => 'declined', 'cp_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3 || $user->admin_role_id  == 5) && $user->department  == 'Billings'){
        $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'billing_status' => 'declined', 'billing_comment' => $bmcomment]);
        }
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
        $onpremiseObj = onpremise::find($getonpremise[0]['id']);
        
        if($user->admin_role_id  == 1 || ($user->admin_role_id  == 5 && $user->department  == 'M_I')){
        $getApplicant = User::where('id', $getonpremise[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('onpremise_additional_decline_approve_subject');
        $emailcontent = EmailContent::getContent('onpremise_additional_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent. " " . " " . $request['comments'] . " ";
        //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        }

        $onpremiseAppHistory = new Apphistory();
        $reportFile = $request['report_file'];
        $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
        $onpremiseAppHistory->who_performed_action = $user->id;
        $onpremiseAppHistory->comments = $request['comments'];
        $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
        $onpremiseAppHistory->previous_ads_price = $getFindPrice['previous_ads_price'];
        $onpremiseAppHistory->current_ads_price = $getFindPrice['current_ads_price'];
        $onpremiseAppHistory->balance = $getFindPrice['balance'] + $getFindPrice['ads_price'];
        $onpremiseAppHistory->bank_and_others = $getFindPrice['bank_and_others'];
        $onpremiseAppHistory->product_on_sign = $getFindPrice['product_on_sign'];
        $onpremiseAppHistory->ads_price = $getFindPrice['ads_price'];
        $onpremiseObj->appHistory()->save($onpremiseAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an onpremise ads with adsId'. $onpremiseId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get();
        
        
        

        $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->where('sign_to_add', '>', 0)->get();
        
        
        // $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'ref_id' => $onpremiseObj->payment_id,
                  'comment' => $request['comments'],
                  
             ];
            
             $pdf = Pdf::loadView('onpremisedisapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremisedisapproval.pdf');
             $commentletter = $request['comments'];
              $userObj = User::find($onpremiseObj->user_id);
             $body = "your application for first party signage display has been disapproved due to $commentletter. Please find your disapproval letter attached";
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendDisapproval($userObj->email, $templateContent, $fileObj);
             //Log::info('email sent to ' . $userObj->email);
        
        
        $updateinfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($updateinfo) - 1;
        // for($i=0;$i<=$count;$i++){
        //     $updateinfo->update(['number_of_sign' => $addup]);
        // }
        
        
        
        
        
        return response()->json(['data' => $onpremiseAppHistory], 200);
    }
    
    public function declinedChangeOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'nullable|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        if(isset($request['reports_from_branchmanger'])){
            $bmcomment = $request['reports_from_branchmanger'];
        }else{
            $bmcomment = "";
        }
        if(isset($request['comments'])){
            $ucomment = $request['comments'];
        }else{
            $ucomment = "";
        }
        if($user->admin_role_id  == 1){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'declined', 'bm_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3) && $user->department  == 'M_I'){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('rm_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('rm_status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'pending', 'rm_status' => 'declined', 'rm_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 5 && $user->department  == 'M_I'){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('hod_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('hod_status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'declined', 'rm_status' => 'declined', 'hod_status' => 'declined', 'hod_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 4){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('audit_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('audit_status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'audit_status' => 'declined', 'billing_status' => 'declined', 'audit_comment' => $bmcomment]);
        }elseif($user->admin_role_id  == 11){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('cp_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('cp_status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'pending', 'cp_status' => 'declined', 'cp_comment' => $bmcomment]);
        }elseif(($user->admin_role_id  == 2 || $user->admin_role_id  == 3 || $user->admin_role_id  == 5) && $user->department  == 'Billings'){
        $allnewchanges = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('billing_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->firt();
        $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)
                            ->where('billing_status', 'pending')
                            ->get()->last();
        $onpremise = OnPremiseChange::where('onpremise_id', $allnewchanges->id)->update(['status' => 'pending', 'rm_status' => 'declined', 'hod_status' => 'declined', 'billing_status' => 'declined', 'billing_comment' => $bmcomment]);
        }
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
        $onpremiseObj = onpremise::find($getonpremise[0]['id']);
        
        if($user->admin_role_id  == 1 || ($user->admin_role_id  == 5 && $user->department  == 'M_I')){
        $getApplicant = User::where('id', $getonpremise[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('onpremise_change_decline_approve_subject');
        $emailcontent = EmailContent::getContent('onpremise_change_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent . " " . " " . $request['comments'] . " ";
        //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        }

        $onpremiseAppHistory = new Apphistory();
        $reportFile = $request['report_file'];
        $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
        $onpremiseAppHistory->who_performed_action = $user->id;
        $onpremiseAppHistory->comments = $request['comments'];
        $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
        $onpremiseAppHistory->previous_ads_price = $getFindPrice['previous_ads_price'];
        $onpremiseAppHistory->current_ads_price = $getFindPrice['current_ads_price'];
        $onpremiseAppHistory->balance = $getFindPrice['balance'];
        $onpremiseAppHistory->bank_and_others = $getFindPrice['bank_and_others'];
        $onpremiseAppHistory->product_on_sign = $getFindPrice['product_on_sign'];
        $onpremiseAppHistory->ads_price = $getFindPrice['ads_price'];
        $onpremiseObj->appHistory()->save($onpremiseAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an onpremise ads with adsId'. $onpremiseId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get();
        
        
        

        // $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->where('sign_to_add', '>', 0)->get();
        
        
        // $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
            //  for($i=0;$i <= $countDetails; $i++) {
            //      $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
            //      $quantitySigns [] = (int)$OnpremiseInfo[$i]['length_in_meter'] * (int)$OnpremiseInfo[$i]['width_in_meter'];
            //  }
            //  $combinedArray = [];
            //  foreach ($signTypes as $index => $value) {
            //      $combinedArray [] = [
            //          'key' => $value,
            //          'value' => $quantitySigns[$index],
            //         //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
            //      ];
                 
            //  }
            
            if ($OnpremiseInfo) {  // Ensure the record exists
                $signTypes = [$OnpremiseInfo['type_of_sign']];
                $quantitySigns = [(float)$OnpremiseInfo['length_in_meter'] * (float)$OnpremiseInfo['width_in_meter']];
                
                $combinedArray = [
                    [
                        'key' => $signTypes[0],
                        'value' => round($quantitySigns[0], 2),
                    ]
                ];
            }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'ref_id' => $onpremiseObj->payment_id,
                  'comment' => $request['comments'],
                  
             ];
            
             $pdf = Pdf::loadView('onpremisedisapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremisedisapproval.pdf');
             $commentletter = $request['comments'];
              $userObj = User::find($onpremiseObj->user_id);
             $body = "your application for first party signage display has been disapproved due to $commentletter. Please find your disapproval letter attached";
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendDisapproval($userObj->email, $templateContent, $fileObj);
             //Log::info('email sent to ' . $userObj->email);
        
        
        $updateinfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($updateinfo) - 1;
        // for($i=0;$i<=$count;$i++){
        //     $updateinfo->update(['number_of_sign' => $addup]);
        // }
        
        
        
        
        
        return response()->json(['data' => $onpremiseAppHistory], 200);
    }

    public function declinedStreetLamp($streetLampId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();

        $streetLamp = StreetLampsAds::where('id', $streetLampId)->update(['status' => 'declined']);
        $getStreetLamp = StreetLampsAds::where('id', $streetLampId)->get();
        $getFindPrice = AppHistoryStreetLamp::where('street_lamps_ads_id', $streetLampId)->get();
        $streetObj = StreetLampsAds::find($getStreetLamp[0]['id']);
        //var_dump($getStreetLamp);die();
        $getApplicant = User::where('id', $getStreetLamp[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('streetlamp_decline_approve_subject');
        $emailcontent = EmailContent::getContent('streetlamp_decline_content');
        $subject = $emailsubject;
        $body = $emailcontent. " ". $request['comments'] . " "
            . $request['reports_from_branchmanger'];

        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
        if($getCreateby ) {
            $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
            $getCreatebyEmail = $getAdmin[0]['email'];
            $this->composeEmailV2($subject, $getCreatebyEmail,  $templateContent);
        }

        $streetLampAppHistory = new AppHistoryStreetLamp();
        $reportFile = $request['report_file'];
        $streetLampAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $streetLampAppHistory->purpose = 'Street Lamps Ads Application';
        $streetLampAppHistory->who_performed_action = $user->id;
        $streetLampAppHistory->comments = $request['comments'];
        $streetLampAppHistory->reports_from_branchmanager = $request['reports_from_branchmanger'];
        $streetLampAppHistory->ads_price = $getFindPrice[0]['ads_price'];
        $newAppHIstory = $streetObj->appHistoryStreetLamp()->save($streetLampAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an streetlamp ads with adsId'. $streetLampId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $streetLampApp = AppHistoryStreetLamp::where('street_lamps_ads_id', $getStreetLamp[0]['id'])->get();
        return response()->json(['data' => $streetLampApp], 200);
    }

    public function declinedExpresionInterestStreetLamp($streetLampId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();

        $streetLamp = StreetLampsAds::where('id', $streetLampId)->update(['eoi_status' => 'declined']);
        $getStreetLamp = StreetLampsAds::where('id', $streetLampId)->get();

        $getApplicant = User::where('id', $getStreetLamp[0]['user_id'])->get();
       $getApplicantEmail = $getApplicant[0]['email'];
       $emailsubject = EmailContent::getContent('streetlamp_decline_approve_subject');
       $emailcontent = EmailContent::getContent('streetlamp_eoi_decline_content');
       $subject = $emailsubject;
       $body = $emailcontent . " ". $request['comments'] . " "
           . $request['reports_from_branchmanger'];
       //$this->composeEmail($subject, $body, $getApplicantEmail);
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],

        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);

        $getFindPrice = AppHistoryStreetLamp::where('street_lamps_ads_id', $streetLampId)->get();
        $streetObj = StreetLampsAds::find($getStreetLamp[0]['id']);
        //var_dump($getFindPrice[0]['ads_price']); die();
        $streetLampAppHistory = new AppHistoryStreetLamp();
        $reportFile = $request['report_file'];
        $streetLampAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $streetLampAppHistory->purpose = 'Street Lamps Ads Application';
        $streetLampAppHistory->who_performed_action = $user->id;
        $streetLampAppHistory->comments = $request['comments'];
        $streetLampAppHistory->reports_from_branchmanager = $request['reports_from_branchmanger'];
        $streetLampAppHistory->ads_price = $getFindPrice[0]['ads_price'];
        $newAppHIstory = $streetObj->appHistoryStreetLamp()->save($streetLampAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Decline an streetlamp ads with adsId'. $streetLampId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $streetLampApp = AppHistoryStreetLamp::where('street_lamps_ads_id', $getStreetLamp[0]['id'])->get();
        return response()->json(['data' => $streetLampApp], 200);
    }


    // public function approveMobileAds($mobileId, Request $request) {
    //     $validate = Validator::make($request->all(), [
    //         'comments' => 'nullable|string|max:255',
    //         'reports_from_branchmanger' => 'required|string|max:255',
    //         'report_file' => 'nullable|string',
    //         'accept_price' => 'required|boolean',
    //         'discount' => 'nullable|integer'
    //     ]);

    //     if($validate->fails()) {
    //         return response()->json(['errors' => $validate->errors()->all()], 422);
    //     }

    //     $user = Auth::user();

    //     $getupdate = mobilead::where('id', $mobileId)->get();
    //     $mobileObj = mobilead::find($getupdate[0]['id']);
    //     $count = MobileAdsVehicleLicense::where('mobilead_id', $mobileId)->count();
    //     $getVehicleDetails = MobileAdsVehicleLicense::where('mobilead_id', $mobileId)->get();
    //     $date = Carbon::today();
    //     $lastDayOfYear = Carbon::create($date->year, 12, 31);
    //     $dayRemaining = $date->diffInDays($lastDayOfYear);
    //     $currentYear = Carbon::now()->year;
    //     $dayInYear = Carbon::createFromDate($currentYear, 1, 1)->
    //                                     diffInDays(Carbon::createFromDate($currentYear, 12, 31)) + 1;
    //     //var_dump($dayInYear); die();
    //     $totalcount = $count-1;

    //         $price = 0;
    //         for ($i = 0; $i < $count; $i++) {
    //             if ($getVehicleDetails[$i]['branding_details'] == 'Full Branding') {
    //                 if ($getVehicleDetails[$i]['vehicle_type'] == 'Trailer') {
    //                     $price += 49900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Truck') {
    //                     $price += 49900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Coaster') {
    //                     $price += 49900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Civilian') {
    //                     $price += 49900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bus') {
    //                     $price += 39900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Pickup') {
    //                     $price += 39900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'SUV') {
    //                     $price += 39900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Motorcycle') {
    //                     $price += 19000;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Push-Cart') {
    //                     $price += 19000;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bicycle') {
    //                     $price += 19000;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Car') {
    //                     $price += 19900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Tricycle') {
    //                     $price += 19000;
    //                 }
    //             } elseif ($getVehicleDetails[$i]['branding_details'] == 'Partial Branding') {
    //                 if ($getVehicleDetails[$i]['vehicle_type'] == 'Trailer') {
    //                     $price += 9900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Truck') {
    //                     $price += 9900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Coaster') {
    //                     $price += 9900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Civilian') {
    //                     $price += 9900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bus') {
    //                     $price += 7900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Pickup') {
    //                     $price += 7900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'SUV') {
    //                     $price += 7900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Motorcycle') {
    //                     $price += 1900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Push-Cart') {
    //                     $price += 1900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bicycle') {
    //                     $price += 1900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Car') {
    //                     $price += 3900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Tricycle') {
    //                     $price += 1900;
    //                 }
    //             } elseif ($getVehicleDetails[$i]['branding_details'] == 'Wrap Around Branding') {
    //                 if ($getVehicleDetails[$i]['vehicle_type'] == 'Trailer') {
    //                     $price += 19900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Truck') {
    //                     $price += 19900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Coaster') {
    //                     $price += 19900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Civilian') {
    //                     $price += 19900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bus') {
    //                     $price += 12900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Pickup') {
    //                     $price += 12900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'SUV') {
    //                     $price += 12900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Motorcycle') {
    //                     $price += 4900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Push-Cart') {
    //                     $price += 4900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Bicycle') {
    //                     $price += 4900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Car') {
    //                     $price += 7900;
    //                 } elseif ($getVehicleDetails[$i]['vehicle_type'] == 'Tricycle') {
    //                     $price += 7000;
    //                 }
    //             }
    //         }

    //         if ($request['discount']) {
    //             $discount = $request['discount'];
    //             $discountPrice = ($discount * $price) / 100;
    //             $discountCalculate = ($count * $price) - $discountPrice;
    //             $appPrice = $discountCalculate;
    //             $appPrice = round($appPrice, 2);
    //         } else {
    //             //$discountCalculate =  ($count * $price);
    //             $appPrice = $price;
    //             $appPrice = round($appPrice, 2);
    //         }
    //         //var_dump($appPrice); die();


    //         if ($request['accept_price'] == true) {
    //             if(empty($mobileObj->hod_permit_status)) {

    //                 $getApplicant = User::where('id', $getupdate[0]['user_id'])->get();
    //                 $getApplicantEmail = $getApplicant[0]['email'];
    //                 $subject = 'Update on Mobile  Ads Application';
    //                 $body = 'The Mobile ads your applied for was approved.' . " " . 'Total Price:' . $appPrice . " " . " " . $request['comments'] . " " . " "
    //                     . $request['reports_from_branchmanger'];
    //                 //$this->composeEmail($subject, $body, $getApplicantEmail);
    //                 $templateData = [
    //                     'body' => $body,
    //                     'name' => $getApplicant[0]['business_name'],
    //                 ];
    //                 $templateContent = view('emailtemplate', $templateData)->render();
    //                 $this->composeEmailV2($subject, $getApplicantEmail, $templateContent);
    //                 $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
    //                 if ($getCreateby) {
    //                     $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
    //                     $getCreatebyEmail = $getAdmin[0]['email'];
    //                     $this->composeEmailV2($subject, $getCreatebyEmail, $templateContent);
    //                 }


    //                 $declined = mobilead::where('id', $mobileId)->update(['status' => 'pending', 'hod_permit_status' => 'pending', 'due_date' => $lastDayOfYear]);
    //                 $appHistoryMobile = new AppHistoryMobile();
    //                 $appHistoryMobile->purpose = 'Mobile Ads Application';
    //                 $appHistoryMobile->who_performed_action = $user->id;
    //                 $appHistoryMobile->comments = $request['comments'];
    //                 $appHistoryMobile->reports_from_branchmanger = $request['reports_from_branchmanger'];
    //                 $reportFile = $request['report_file'];
    //                 $appHistoryMobile->report_file = $this->convertBase64toPdf($reportFile);
    //                 $appHistoryMobile->ads_price = $appPrice;
    //                 $mobileObj->appHistoryMobile()->save($appHistoryMobile);
    //                 $permitMobile = new PermitStepMobile();
    //                 $permitMobile->purpose = 'Mobile Ads Application';
    //                 $mobileObj->permitStepMobile()->save($permitMobile);
    //                 $activityInfo = new AdminActivity();
    //                 $fetchActivity = 'Approve a mobile ads with adsId' . $mobileId;
    //                 $activityInfo->action = $fetchActivity;
    //                 $savedActivity = $user->adminActivity()->save($activityInfo);
    //                 $getAppHistory = AppHistoryMobile::where('mobilead_id', $mobileId)->get()->last();
    //                 $calculatePrice = $getAppHistory->ads_price;
    //             } else {
    //                 return response()->json(['data' => 'Can not treat mobile ads!'], 422);
    //             }
    //         } else {
    //             $calculatePrice = $appPrice;
    //         }
    //         return response()->json(['Total Fee' => $calculatePrice], 200);
    // }
    
    public function approveMobileAds($mobileId, Request $request) {
        $validate = Validator::make($request->all(), [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string',
            'accept_price' => 'required|boolean',
            'discount' => 'nullable|integer'
        ]);
    
        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
    
        $user = Auth::user();
        $getupdate = mobilead::where('id', $mobileId)->get();
        $mobileObj = mobilead::find($getupdate[0]['id']);
        $count = MobileAdsVehicleLicense::where('mobilead_id', $mobileId)->count();
        $getVehicleDetails = MobileAdsVehicleLicense::where('mobilead_id', $mobileId)->get();
        $date = Carbon::today();
        $lastDayOfYear = Carbon::create($date->year, 12, 31);
        $dayRemaining = $date->diffInDays($lastDayOfYear);
        $currentYear = Carbon::now()->year;
        $dayInYear = Carbon::createFromDate($currentYear, 1, 1)->
                                    diffInDays(Carbon::createFromDate($currentYear, 12, 31)) + 1;
    
        $price = 0;
        foreach ($getVehicleDetails as $vehicle) {
            $pricing = MobileAdsPricing::where('vehicle_type', $vehicle['vehicle_type'])
                                      ->where('branding_type', $vehicle['branding_details'])
                                      ->first();
            
            if ($pricing) {
                $price += $pricing->price;
            } else {
                return response()->json(['error' => "Pricing not found for {$vehicle['vehicle_type']} with {$vehicle['branding_details']}"], 404);
            }
        }
    
        if ($request['discount']) {
            $discount = $request['discount'];
            $discountPrice = ($discount * $price) / 100;
            $discountCalculate = ($count * $price) - $discountPrice;
            $appPrice = $discountCalculate;
            $appPrice = round($appPrice, 2);
        } else {
            $appPrice = $price;
            $appPrice = round($appPrice, 2);
        }
    
        if ($request['accept_price'] == true) {
            if(empty($mobileObj->hod_permit_status)) {
                $getApplicant = User::where('id', $getupdate[0]['user_id'])->get();
                $getApplicantEmail = $getApplicant[0]['email'];
                $emailsubject = EmailContent::getContent('mobile_decline_approve_subject');
                $emailcontent = EmailContent::getContent('mobile_approve_content');
                $subject = $emailsubject;
                $body = $emailcontent . " " . 'Total Price:' . $appPrice . " " . " " . $request['comments'] . " " . " "
                    . $request['reports_from_branchmanger'];
                
                $templateData = [
                    'body' => $body,
                    'name' => $getApplicant[0]['business_name'],
                ];
                $templateContent = view('emailtemplate', $templateData)->render();
                $this->composeEmailV2($subject, $getApplicantEmail, $templateContent);
                
                $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
                if ($getCreateby) {
                    $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
                    $getCreatebyEmail = $getAdmin[0]['email'];
                    $this->composeEmailV2($subject, $getCreatebyEmail, $templateContent);
                }
    
                $declined = mobilead::where('id', $mobileId)->update([
                    'status' => 'pending', 
                    'hod_permit_status' => 'pending', 
                    'due_date' => $lastDayOfYear
                ]);
                
                $appHistoryMobile = new AppHistoryMobile();
                $appHistoryMobile->purpose = 'Mobile Ads Application';
                $appHistoryMobile->who_performed_action = $user->id;
                $appHistoryMobile->comments = $request['comments'];
                $appHistoryMobile->reports_from_branchmanger = $request['reports_from_branchmanger'];
                $reportFile = $request['report_file'];
                $appHistoryMobile->report_file = $this->convertBase64toPdf($reportFile);
                $appHistoryMobile->ads_price = $appPrice;
                $mobileObj->appHistoryMobile()->save($appHistoryMobile);
                
                $permitMobile = new PermitStepMobile();
                $permitMobile->purpose = 'Mobile Ads Application';
                $mobileObj->permitStepMobile()->save($permitMobile);
                
                $activityInfo = new AdminActivity();
                $fetchActivity = 'Approve a mobile ads with adsId' . $mobileId;
                $activityInfo->action = $fetchActivity;
                $savedActivity = $user->adminActivity()->save($activityInfo);
                
                $getAppHistory = AppHistoryMobile::where('mobilead_id', $mobileId)->get()->last();
                $calculatePrice = $getAppHistory->ads_price;
            } else {
                return response()->json(['data' => 'Can not treat mobile ads!'], 422);
            }
        } else {
            $calculatePrice = $appPrice;
        }
        
        return response()->json(['Total Fee' => $calculatePrice], 200);
    }

//     public function approveThirdPartyMobile($mobileId, Request $request) {
//         $validate = Validator::make($request->all(), [
//             'comments' => 'nullable|string|max:255',
//             'reports_from_branchmanger' => 'required|string|max:255',
//             'report_file' => 'nullable|string',
//             'accept_price' => 'required|boolean',
//             'discount' => 'nullable|integer'
//         ]);

//         if ($validate->fails()) {
//             return response()->json(['errors' => $validate->errors()->all()], 422);
//         }

//         $user = Auth::user();


//         $getupdate = ThirdPartyMobile::where('id', $mobileId)->get();
//         $declineId = ThirdPartyMobile::find($getupdate[0]['id']);
//         $count = ThirdPartyMobileVehicleLicense::where('third_party_mobile_id', $mobileId)->count();
//         $getVehicleInfo = ThirdPartyMobileVehicleLicense::where('third_party_mobile_id', $mobileId)->get();
//         $date = Carbon::today();
//         $lastDayOfYear = Carbon::create($date->year, 12, 31);
//         $lastDayOfMonth = Carbon::now()->endOfMonth();
//         $endofQuarter = Carbon::now()->endOfQuarter();
//         $endOfBiannual = Carbon::today()->copy()->addMonth(6)->endOfMonth();
//         $endOfBiannual2 = Carbon::today()->copy()->addMonth(6);
//         $daysInHalfYear = Carbon::today()->diffInDays($endOfBiannual2);
//         $dayRemaining = $date->diffInDays($lastDayOfYear);
//         $currentYear = Carbon::now()->year;
//         $dayInYear = Carbon::createFromDate($currentYear, 1, 1)->
//             diffInDays(Carbon::createFromDate($currentYear, 12, 31)) + 1;
//         $startdate = Carbon::parse($declineId->start_date);
//         $duration = $declineId->duration;

//         // Set the end date based on the duration
//         switch ($duration) {
//             case 'monthly':
//                 $enddate = $startdate->copy()->addMonth();
//                 break;
//             case 'quarterly':
//                 $enddate = $startdate->copy()->addMonths(3);
//                 break;
//             case 'biannual':
//                 $enddate = $startdate->copy()->addMonths(6);
//                 break;
//             case 'annually':
//                 $enddate = $startdate->copy()->addYear();
//                 break;
//             // Add more cases as needed
//             default:
//                 // Handle invalid duration if needed
//                 break;
//         }

//         // Get the number of days between start date and end date
//         $numberOfDays = $startdate->diffInDays($enddate);
//         if($enddate < $lastDayOfYear){
//             $duedate = $enddate;
//         }else{
//             $duedate = $lastDayOfYear;
//         }
//         //var_dump($enddate); die();
//         $price = 0;
//       // var_dump($count); die();
//         for($i=0;$i<$count;$i++) {
//             if ($getVehicleInfo[$i]['vehicle_type'] == 'Light Box Cab') {
//                 $mobileCalculatePerday = 100000 / $dayInYear;
//                 if ($numberOfDays < $dayRemaining) {
//                     $price += $mobileCalculatePerday * $numberOfDays;
//                 } else {
//                     $price += $mobileCalculatePerday * $dayRemaining;
//                 }
// //                $roundplace = 2;
// //                $price = round($price, $roundplace);
//             } elseif ($getVehicleInfo[$i]['vehicle_type'] == 'Light Box Plus Doors Cab') {
//                 $mobileCalculatePerday = 150000 / $dayInYear;
//                 if ($numberOfDays < $dayRemaining) {
//                     $price += $mobileCalculatePerday * $numberOfDays;
//                 } else {
//                     $price += $mobileCalculatePerday * $dayRemaining;
//                 }
// //                $roundplace = 2;
// //                $price = round($price, $roundplace);
//             } elseif ($getVehicleInfo[$i]['vehicle_type'] == 'Promotional Advert Vehicles (PAV) Static') {
//                 $mobileCalculatePerday = 1250000 / $dayInYear;
//                 if ($numberOfDays < $dayRemaining) {
//                     $price += $mobileCalculatePerday * $numberOfDays;
//                 } else {
//                     $price += $mobileCalculatePerday * $dayRemaining;
//                 }
// //                $roundplace = 2;
// //                $price = round($price, $roundplace);
//             } elseif ($getVehicleInfo[$i]['vehicle_type'] == 'Promotional Advert Vehicles (PAV) Ultrawave & LED') {
//                 $mobileCalculatePerday = 1500000 / $dayInYear;
//                 if ($numberOfDays < $dayRemaining) {
//                     $price += $mobileCalculatePerday * $numberOfDays;
//                 } else {
//                     $price += $mobileCalculatePerday * $dayRemaining;
//                 }
// //                $roundplace = 2;
// //                $price = round($price, $roundplace);
//             } elseif ($getVehicleInfo[$i]['vehicle_type'] == 'Intra-State Luxurious Bus Advertising (LAGBUS/LAMATA/LAWMA)') {
//                 $mobileCalculatePerday = 360000 / $dayInYear;
//                 if ($numberOfDays < $dayRemaining) {
//                     $price += $mobileCalculatePerday * $numberOfDays;
//                 } else {
//                     $price += $mobileCalculatePerday * $dayRemaining;
//                 }
// //                $roundplace = 2;
// //                $price = round($price, $roundplace);
//             }
//         }
//       // var_dump($price); die();
//         if ($request['discount'] ) {
//             $discount = $request['discount'];
//             $discountPrice = ($discount *  $price) / 100;
//             $discountCalculate =  $price - $discountPrice;
//             $appPrice = $discountCalculate;
//             $appPrice = round($appPrice, 2);
//         } else {
//             //$discountCalculate =  ($count * $price);
//             $appPrice = $price;
//             $appPrice = round($appPrice, 2);
//         }
//         // var_dump($appPrice); die();
//         if($request['accept_price']  == true) {
//             $declined = ThirdPartyMobile::where('id', $mobileId)->update(['status' => 'pending', 'hod_permit_status' => 'pending', 'due_date' => $duedate]);

//             $getApplicant = User::where('id', $getupdate[0]['user_id'])->get();
//             $getApplicantEmail = $getApplicant[0]['email'];
//             $subject = 'Update on Third party mobile  Ads Application';
//             $body = 'The Mobile ads your applied for was approved.' .  " "  .'Total Price:' . $appPrice . " ". " " . $request['comments'] . " ". " "
//                 .$request['reports_from_branchmanger'];
//             //$this->composeEmail($subject, $body, $getApplicantEmail);
//             $templateData = [
//                 'body' => $body,
//                 'name' => $getApplicant[0]['business_name'],
//             ];
//             $templateContent = view('emailtemplate', $templateData)->render();
//             $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
//             $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
//             if($getCreateby ) {
//                 $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
//                 $getCreatebyEmail = $getAdmin[0]['email'];
//                 $this->composeEmailV2($subject, $getCreatebyEmail,  $templateContent);
//             }

//             $appHistoryThirdPartyMobile = new ThirdPartyMobileAppHistory();
//             $appHistoryThirdPartyMobile->purpose = "Third Party Mobile Ads Application";
//             $appHistoryThirdPartyMobile->who_performed_action = $user->id;
//             $appHistoryThirdPartyMobile->comments = $request['comments'];
//             $appHistoryThirdPartyMobile->reports_from_branchmanager = $request['reports_from_branchmanger'];
//             $reportFile = $request['report_file'];
//             $appHistoryThirdPartyMobile->report_file = $this->convertBase64toPdf($reportFile);
//             $appHistoryThirdPartyMobile->ads_price = $appPrice;
//             $denial = $declineId->thirdPartyMobileAppHistory()->save($appHistoryThirdPartyMobile);
//             $activityInfo = new AdminActivity();
//             $fetchActivity = 'Approve a third party mobile ads with adsId' . $mobileId;
//             $activityInfo->action = $fetchActivity;
//             $savedActivity = $user->adminActivity()->save($activityInfo);
//             $getAppHistory = ThirdPartyMobileAppHistory::where('third_party_mobile_id', $mobileId)->get()->last();
//             $calculatedPrice = $getAppHistory->ads_price;
//         } else {
//             $calculatedPrice = $appPrice;
//         }
//         return response()->json(['Total Fee' => $calculatedPrice ], 200);
//     }
    
    public function approveThirdPartyMobile($mobileId, Request $request) {
        $validate = Validator::make($request->all(), [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string',
            'accept_price' => 'required|boolean',
            'discount' => 'nullable|integer'
        ]);
    
        if ($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
    
        $user = Auth::user();
        $mobileAd = ThirdPartyMobile::findOrFail($mobileId);
        $vehicleLicenses = ThirdPartyMobileVehicleLicense::where('third_party_mobile_id', $mobileId)->get();
    
        $today = Carbon::today();
        $lastDayOfYear = Carbon::create($today->year, 12, 31);
        $startDate = Carbon::parse($mobileAd->start_date);
        
        // Calculate end date based on duration
        switch ($mobileAd->duration) {
            case 'monthly':
                $endDate = $startDate->copy()->addMonth();
                break;
            case 'quarterly':
                $endDate = $startDate->copy()->addMonths(3);
                break;
            case 'biannual':
                $endDate = $startDate->copy()->addMonths(6);
                break;
            case 'annually':
                $endDate = $startDate->copy()->addYear();
                break;
            default:
                $endDate = $startDate->copy()->addYear();
        }
    
        $dueDate = $endDate < $lastDayOfYear ? $endDate : $lastDayOfYear;
        $totalPrice = 0;
    
        foreach ($vehicleLicenses as $vehicle) {
            $pricing = ThirdPartyMobileAdsPricing::where('vehicle_type', $vehicle->vehicle_type)->first();
            
            if (!$pricing) {
                continue; // or handle missing pricing
            }
    
            $numberOfDays = $startDate->diffInDays($endDate);
            
            if ($pricing->daily_calculation_basis) {
                $daysInYear = $today->isLeapYear() ? 366 : 365;
                $dailyRate = $pricing->annual_price / $daysInYear;
                $vehiclePrice = $dailyRate * $numberOfDays;
                
                if ($endDate > $lastDayOfYear) {
                    $daysInCurrentYear = $startDate->diffInDays($lastDayOfYear);
                    $vehiclePrice = $dailyRate * $daysInCurrentYear;
                }
            } else {
                switch ($mobileAd->duration) {
                    case 'monthly':
                        $vehiclePrice = $pricing->monthly_price ?? ($pricing->annual_price / 12);
                        break;
                    case 'quarterly':
                        $vehiclePrice = $pricing->quarterly_price ?? ($pricing->annual_price / 4);
                        break;
                    case 'biannual':
                        $vehiclePrice = $pricing->biannual_price ?? ($pricing->annual_price / 2);
                        break;
                    case 'annually':
                        $vehiclePrice = $pricing->annual_price;
                        break;
                }
            }
            
            $totalPrice += $vehiclePrice;
        }
    
        // Apply discount if provided
        if ($request->has('discount')) {
            $discountAmount = ($totalPrice * $request->discount) / 100;
            $totalPrice -= $discountAmount;
        }
    
        $totalPrice = round($totalPrice, 2);
    
        if ($request['accept_price'] == true) {
            $mobileAd->update([
                'status' => 'pending',
                'hod_permit_status' => 'pending',
                'due_date' => $dueDate
            ]);
    
            // Send email notification
            $applicant = User::findOrFail($mobileAd->user_id);
            $emailsubject = EmailContent::getContent('pav_decline_approve_subject');
            $emailcontent = EmailContent::getContent('pav_approve_content');
            $subject = $emailsubject;
            $body = $emailcontent . " " .'Total Price: ' . $totalPrice . 
                    "\n\nComments: " . $request['comments'] . 
                    "\n\nBranch Manager Report: " . $request['reports_from_branchmanger'];
            
            $templateData = [
                'body' => $body,
                'name' => $applicant->business_name,
            ];
            
            $templateContent = view('emailtemplate', $templateData)->render();
            $this->composeEmailV2($subject, $applicant->email, $templateContent);
    
            if ($applicant->created_by) {
                $admin = UserAdmin::find($applicant->created_by);
                if ($admin) {
                    $this->composeEmailV2($subject, $admin->email, $templateContent);
                }
            }
    
            // Save application history
            $appHistory = new ThirdPartyMobileAppHistory([
                'purpose' => "Third Party Mobile Ads Application",
                'who_performed_action' => $user->id,
                'comments' => $request['comments'],
                'reports_from_branchmanager' => $request['reports_from_branchmanger'],
                'report_file' => $this->convertBase64toPdf($request['report_file']),
                'ads_price' => $totalPrice
            ]);
            
            $mobileAd->thirdPartyMobileAppHistory()->save($appHistory);
    
            // Log admin activity
            $activityInfo = new AdminActivity([
                'action' => 'Approve a third party mobile ads with adsId ' . $mobileId
            ]);
            
            $user->adminActivity()->save($activityInfo);
        }
    
        return response()->json(['Total Fee' => $totalPrice], 200);
    }
    
    public static function calculatePrice(
        $pricingRule,
        $squareMeters,
        $numSigns,
        $installationDate,
        $productOnSign = false,
        $isBankOrOther = false,
        $renewal
    ) {
        $price = $pricingRule->price_per_sqm;
        
        if($squareMeters > $pricingRule->min_square_meter && $pricingRule->min_square_meter != null && $pricingRule->max_square_meter == null && $pricingRule->duration != 'weekly'){
            $price = ($squareMeters / $pricingRule->min_square_meter) * $pricingRule->price_per_sqm;
        }
        
        // Apply product on sign markup if needed
        if ($productOnSign) {
            $price += $price / 2;
        }
        
        // Calculate time-based pricing
        if($renewal == "renewal"){
            $date = Carbon::now()->startOfYear();
        }else{
            $date = Carbon::parse($installationDate)->startOfMonth();
        }
        $currentYear = Carbon::now()->year;
        $endOfYear = Carbon::now()->endOfYear();
        $endOfLastYear = Carbon::now()->subYear()->endOfYear();
        
        if ($date->year === $currentYear) {
            $monthsRemaining = $date->diffInMonths($endOfYear) + 1;
            $pricePerDay = ($price / 12) * $numSigns;
            $totalPrice = $monthsRemaining * $pricePerDay;
            $previousTotal = 0;
            $currentTotal = $totalPrice;
        } else {
            $monthsRemaining = $date->diffInMonths($endOfYear) + 1;
            $monthsLastYear = $date->diffInMonths($endOfLastYear) + 1;
            
            $pricePerDay = ($price / 12) * $numSigns;
            $totalPrice = $monthsRemaining * $pricePerDay;
            $previousTotal = $monthsLastYear * $pricePerDay;
            $currentTotal = $totalPrice - $previousTotal;
        }
        
        // Special cases (like large signs)
        if ($squareMeters > 25 && $pricingRule->duration == 'weekly') {
            if ($date->diffInWeeks($endOfYear) <= 1) {
                $totalPrice = $price * $squareMeters * $numSigns;
                $currentTotal = $totalPrice;
            } else {
                $weeksRemaining = $date->diffInWeeks($endOfYear) + 1;
                $totalPrice = $weeksRemaining * $price * $squareMeters * $numSigns;
                if ($date->year < $currentYear) {
                    $weeksLastYear = $date->diffInWeeks($endOfLastYear) + 1;
                    $previousTotal = $weeksLastYear * $price * $squareMeters * $numSigns;
                    $currentTotal = $totalPrice - $previousTotal;
                } else {
                    $currentTotal = $totalPrice;
                }
            }
        }
        
        return [
            'total' => $totalPrice,
            'previous' => $previousTotal,
            'current' => $currentTotal,
            'rate' => $totalPrice / $numSigns,
            'previous_rate' => $previousTotal / $numSigns
        ];
    }
    
    public function approveOnpremise($onpremiseId, Request $request){
        
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'street_category' => 'required|string',
            'accept_price' => 'required|boolean',
            'report_file' => 'nullable|string',
            'installation_date' => 'required|date_format:Y-m-d',
            'bank_and_others' => 'required|boolean',
            'product_on_sign' => 'required|boolean'
        ]);
    
        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
    
        $user = Auth::user();
        // $pricingCalculator = new OnPremisePricingCalculator();
        
        $onpremise = onpremise::findOrFail($onpremiseId);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $appHistory = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
    
        $newTotal = [];
        $newpreviousTotal = [];
        $newcurrentTotal = [];
    
        foreach ($onpremiseInfo as $info) {
            $squareMeters = floatval($info['length_in_meter']) * floatval($info['width_in_meter']);
            $numSigns = $info['number_of_sign'];
            
            $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                ->where('sign_type', $info['type_of_sign'])
                ->where('is_bank_other_price', $request['bank_and_others'])
                ->where(function ($query) use ($squareMeters) {
                    $query->where(function ($q) use ($squareMeters) {
                        // Case for range pricing: min <= squareMeter <= max
                        $q->whereNotNull('min_square_meter')
                            ->whereNotNull('max_square_meter')
                            ->where('min_square_meter', '<=', $squareMeters)
                            ->where('max_square_meter', '>=', $squareMeters);
                    })->orWhere(function ($q) use ($squareMeters) {
                        // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                        $q->whereNull('min_square_meter')
                            ->whereNull('max_square_meter');
                    })->orWhere(function ($q) use ($squareMeters) {
                        // Case for "< X" pricing: only max_square_meter is set
                        $q->whereNull('min_square_meter')
                            ->whereNotNull('max_square_meter')
                            ->where('max_square_meter', '>', $squareMeters);
                    })->orWhere(function ($q) use ($squareMeters) {
                        // Case for "> X" pricing: only min_square_meter is set
                        $q->whereNotNull('min_square_meter')
                            ->whereNull('max_square_meter')
                            ->where('min_square_meter', '<=', $squareMeters);
                    });
                })
                ->firstOrFail();
    
            $result = $this->calculatePrice(
                $pricingRule,
                $squareMeters,
                $numSigns,
                $request['installation_date'],
                $info['product_on_sign'],
                $request['bank_and_others'],
                "nonrenewal"
            );
    
            $info->update([
                'rate' => round($result['rate'], 2),
                'previous_rate' => round($result['previous_rate'], 2)
            ]);
    
            $newTotal[] = $result['total'];
            $newpreviousTotal[] = $result['previous'];
            $newcurrentTotal[] = $result['current'];
        }
    
        $sumOfNewTotal = array_sum($newTotal);
        $sumOfpreviousTotal = array_sum($newpreviousTotal);
        $sumOfcurrentTotal = array_sum($newcurrentTotal);

        if($request['accept_price'] == true) {
             if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
             $date = Carbon::parse($request['installation_date'])->startOfMonth();
             $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'approved', 'rm_status' => 'pending', 'street_category' => $request['street_category'], 'installation_date' => $date, 'bank_and_others' => $request['bank_and_others'], 'bm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $sumOfpreviousTotal;
             $onpremiseAppHistory->current_ads_price = $sumOfcurrentTotal;
             $onpremiseAppHistory->ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->balance = $sumOfNewTotal;
             $onpremiseAppHistory->bank_and_others = $request['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $request['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
         }
    
        return response()->json(['Total' => (int)($request['accept_price'] ? $seePrice : $sumOfNewTotal)], 200);
    }

    // public function approveOnpremise($onpremiseId, Request $request) {
//         $validate = Validator::make($request->all(),  [
//             'comments' => 'nullable|string|max:255',
//             'reports_from_branchmanger' => 'required|string|max:255',
//             'street_category' => 'required|string',
//             'accept_price' => 'required|boolean',
//             'report_file' => 'nullable|string',
//             'installation_date' => 'required|date_format:Y-m-d',
//             'bank_and_others' => 'required|boolean',
//             'product_on_sign' => 'required|boolean'
//         ]);

//         if($validate->fails()) {
//             return response()->json(['errors' => $validate->errors()->all()], 422);
//         }
//         $user = Auth::user();
        
//         $getonpremise = onpremise::where('id', $onpremiseId)->get();
//         $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
//         $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
//         $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
//         $count = count($onpremiseInfo) - 1;

//         $date = Carbon::parse($request['installation_date'])->startOfMonth();
//         $dateweek = Carbon::parse($request['installation_date']);
//         // var_dump($date->year);die();
//         $dateNow = Carbon::now();
//         $currentYear = Carbon::now()->year;
//         $endofYear = Carbon::now()->endOfYear();
//         $endOfLastYear = Carbon::now()->subYear()->endOfYear();
//         $yearsDifference = $date->diffInYears(Carbon::now());
        
//         $currentDate = Carbon::now();

//         // Get the total number of days difference
//         // $daysDifference = $date->diffInDays($currentDate);
//         $daysDifference = $date->diffInMonths($endofYear);
//         // var_dump(Carbon::now()->format('Y-m-d H:i:s'));die();
        
//         // Convert the days to years (accounting for leap years)
//         // $totalYears = round($daysDifference / 365.25);
//         $daysDifference = $daysDifference + 1;
//         $totalYears = $daysDifference / 12 ;
        
//         if($date->year === $currentYear){
//           $weekRemaining = $dateweek->diffInWeeks($endofYear);
//           //var_dump($date, $weekRemaining); die();
//           $dayRemaining = $date->diffInMonths($endofYear); 
//         }elseif($date->year < $currentYear){
//             $weekRemaining = $dateweek->diffInWeeks($endofYear);
//             $weekRemainingLastYear = $dateweek->diffInWeeks($endOfLastYear);
//           //var_dump($date, $weekRemaining); die();
//           $dayRemaining = $date->diffInMonths($endofYear); 
//           $dayRemainingLastYear = $date->diffInMonths($endOfLastYear); 
//         }
//         // var_dump($dayRemaining, $weekRemaining);die();
        
//         $dayRemaining = $dayRemaining + 1;
//         $weekRemaining = $weekRemaining + 1;
        
//         // var_dump($dayRemaining, $weekRemaining);die();

// //        $lastDayOfYear = Carbon::create($date->year, 12, 31);
// //        $endOfBiannual2 = $date->copy()->addMonth(6);
// //        $daysInHalfYear = $date->diffInDays($endOfBiannual2);
// //        $currentYear = Carbon::now()->year;
// //        $dayInYear = Carbon::createFromDate($currentYear, 1, 1)->
// //            diffInDays(Carbon::createFromDate($currentYear, 12, 31)) + 1;


//     $totalPrice = 0;
//     $previousTotal = 0;
//     $currentTotal = 0;

// //         for($i=0;$i<=$count;$i++) {
// //             $request['product_on_sign'] = $onpremiseInfo[$i]['product_on_sign'];
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 5544;
// //             }else{
// //                 $price = 3960;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 7761.60;
// //             }else{
// //                 $price = 5544;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 8568;
// //             }else{
// //                 $price = 6120;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 12852;
// //             }else{ 
// //                 $price = 9180;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12 ) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 18816;
// //             }else{ 
// //                 $price = 13440;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 28224;
// //             }else{ 
// //                 $price = 20160;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 36960;
// //             }else{ 
// //                 $price = 26400;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 25) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 84000;
// //             }else{ 
// //                 $price = 60000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 25) {
// //             if ($weekRemaining <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 448;
// //                 }else{ 
// //                     $price = 320;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice += $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice;
// //             } else {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 448;
// //                 }else{ 
// //                     $price = 320;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                 if($date->year < $currentYear){
// //                 $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 14784;
// //             }else{ 
// //                 $price = 10560;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 20697.60;
// //             }else{ 
// //                 $price = 14784;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 22848;
// //             }else{ 
// //                 $price = 16320;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 34272;
// //             }else{ 
// //                 $price = 24480;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 37632;
// //             }else{ 
// //                 $price = 26880;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 56448;
// //             }else{ 
// //                 $price = 40320;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 59136;
// //             }else{ 
// //                 $price = 42240;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 25) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 168000;
// //             }else{ 
// //                 $price = 120000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 25) {
// //             if ($weekRemaining <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 448;
// //                 }else{ 
// //                     $price = 320;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice;
// //             } else {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 448;
// //                 }else{ 
// //                     $price = 320;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                 if($date->year < $currentYear){
// //                 $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 24192;
// //             }else{ 
// //                 $price = 17280;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 33868.80;
// //             }else{ 
// //                 $price = 24192;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 37632;
// //             }else{ 
// //                 $price = 26880;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 56448;
// //             }else{ 
// //                 $price = 40320;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 63168;
// //             }else{ 
// //                 $price = 45120;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 94752;
// //             }else{ 
// //                 $price = 67680;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 99456;
// //             }else{ 
// //                 $price = 71040;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 25) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 392000;
// //             }else{ 
// //                 $price = 280000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 25) {
// //             if ($weekRemaining <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 630;
// //                 }else{ 
// //                     $price = 450;
// //                 }
// //                 $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice;
// //             } else {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 630;
// //                 }else{ 
// //                     $price = 450;
// //                 }
// //                 $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                 if($date->year < $currentYear){
// //                 $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 36960;
// //             }else{ 
// //                 $price = 26400;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 47544;
// //             }else{ 
// //                 $price = 33960;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 57120;
// //             }else{ 
// //                 $price = 40800;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 85680;
// //             }else{ 
// //                 $price = 61200;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 94080;
// //             }else{ 
// //                 $price = 67200;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 141120;
// //             }else{ 
// //                 $price = 100800;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 147840;
// //             }else{ 
// //                 $price = 105600;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 25) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 560000;
// //             }else{ 
// //                 $price = 400000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 25) {
// //             if ($weekRemaining <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 770;
// //                 }else{ 
// //                     $price = 550;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice;
// //             } else {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 770;
// //                 }else{ 
// //                     $price = 550;
// //                 }
// //                 // if($request['product_on_sign'] === true){
// //                 //     $price += $price / 2;
// //                 // }
// //                 $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                 if($date->year < $currentYear){
// //                 $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 2520;
// //             }else{ 
// //                 $price = 1800;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 6552;
// //             }else{ 
// //                 $price = 4680;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 12398.40;
// //             // }else{ 
// //             //     $price = 8856;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }elseif ($getSquareMeter <= 15) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 17136;
// //             // }else{ 
// //             //     $price = 12240;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 28224;
// //             // }else{ 
// //             //     $price = 20160;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 3360;
// //             }else{ 
// //                 $price = 2400;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 8736;
// //             }else{ 
// //                 $price = 6240;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 12398.40;
// //             // }else{ 
// //             //     $price = 8856;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }elseif ($getSquareMeter <= 15) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 17136;
// //             // }else{ 
// //             //     $price = 12240;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 28224;
// //             // }else{ 
// //             //     $price = 20160;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 7840;
// //             }else{ 
// //                 $price = 5600;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 10752;
// //             }else{ 
// //                 $price = 7680;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 12398.40;
// //             // }else{ 
// //             //     $price = 8856;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }elseif ($getSquareMeter <= 15) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 17136;
// //             // }else{ 
// //             //     $price = 12240;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 28224;
// //             // }else{ 
// //             //     $price = 20160;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 26880;
// //             }else{ 
// //                 $price = 19200;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 80640;
// //             }else{ 
// //                 $price = 57600;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 12398.40;
// //             // }else{ 
// //             //     $price = 8856;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }elseif ($getSquareMeter <= 15) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 17136;
// //             // }else{ 
// //             //     $price = 12240;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
// //             $onpremiseInfo[$i]['type_of_sign'] = 'Freestanding';
// //             // if($request['bank_and_others'] === true){
// //             //     $price = 28224;
// //             // }else{ 
// //             //     $price = 20160;
// //             // }
// //             // $priceperday = ($price/12) * $no_of_signs;
// //             // $totalPrice += $dayRemaining * $priceperday;
// //             // if($date->year < $currentYear){
// //             //     $previousTotal += $dayRemainingLastYear * $priceperday;
// //             //     $currentTotal += $totalPrice - $previousTotal;
// //             // }else{
// //             //     $currentTotal += $totalPrice;
// //             // }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 30576;
// //             }else{ 
// //                 $price = 21840;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 36691.20;
// //             }else{ 
// //                 $price = 26208;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 47138;
// //             }else{ 
// //                 $price = 33670;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 56565.60;
// //             }else{ 
// //                 $price = 40404;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 72618;
// //             }else{ 
// //                 $price = 51870;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 94403.40;
// //             }else{ 
// //                 $price = 67431;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 112112;
// //             }else{ 
// //                 $price = 80080;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 20) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 121940;
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //             }
            
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 840000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 500000;
// //             }
            
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1134000;
// //             }
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 36) {
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = ($getSquareMeter / 36) * 500000;
// //             }
            
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = ($getSquareMeter / 36) * 1134000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 39312;
// //             }else{ 
// //                 $price = 28080;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 47174.40;
// //             }else{ 
// //                 $price = 33696;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 60606;
// //             }else{ 
// //                 $price = 43290;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 72727.20;
// //             }else{ 
// //                 $price = 51948;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 93366;
// //             }else{ 
// //                 $price = 66690;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 121375.80;
// //             }else{ 
// //                 $price = 86697;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 143766;
// //             }else{ 
// //                 $price = 102690;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 20) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 156780;  
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 840000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 800000;  
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1134000;
// //             }
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = ($getSquareMeter / 36) * 800000;
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = ($getSquareMeter / 36) * 1134000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 65520;
// //             }else{ 
// //                 $price = 46800;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 78624;
// //             }else{ 
// //                 $price = 56160;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 101556;
// //             }else{ 
// //                 $price = 72540;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 121867.20;
// //             }else{ 
// //                 $price = 87048;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 157248;
// //             }else{ 
// //                 $price = 112320;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 204422.40;
// //             }else{ 
// //                 $price = 146016;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 244062;
// //             }else{ 
// //                 $price = 174330;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 20) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 265590; 
                
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             } 
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1260000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 1200000;  
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1554000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = ($getSquareMeter / 36) * 1200000;  
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = ($getSquareMeter / 36) * 1554000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 90720;
// //             }else{ 
// //                 $price = 64800;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 108864;
// //             }else{ 
// //                 $price = 77760;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 139860;
// //             }else{ 
// //                 $price = 99900;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 167832;
// //             }else{ 
// //                 $price = 119880;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 215460;
// //             }else{ 
// //                 $price = 153900;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 280098;
// //             }else{ 
// //                 $price = 200070;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 332640;
// //             }else{ 
// //                 $price = 237600;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 20) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 361080;  

// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1680000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = 1600000;  
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = 1974000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 36) {
// //             if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
// //                 $price = ($getSquareMeter / 36) * 1600000;  
// //             }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
// //                 $price = ($getSquareMeter / 36) * 1974000;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Enchroachment Fee N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 126000;
// //             }else{ 
// //                 $price = 90000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 151200;
// //             }else{ 
// //                 $price = 108000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 189000;
// //             }else{ 
// //                 $price = 135000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 226800;
// //             }else{ 
// //                 $price = 162000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 252000;
// //             }else{ 
// //                 $price = 180000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 13) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 302400;
// //             }else{ 
// //                 $price = 216000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             if($request['bank_and_others'] === true){
// //                 $price = 315000;
// //             }else{ 
// //                 $price = 225000;
// //             }
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 20) {
// //             $price = 270000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
// //             $price = 405000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 36) {
// //             $price = ($getSquareMeter / 36) * 405000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($weekRemaining <= 1) {
// //             $price = 320;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice;
// //         } else {
// //             $price = 320;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //             if($date->year < $currentYear){
// //             $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($weekRemaining <= 1) {
// //             $price = 320;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice;
// //         } else {
// //             $price = 320;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //             if($date->year < $currentYear){
// //             $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($weekRemaining <= 1) {
// //             $price = 450;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice;
// //         } else {
// //             $price = 450;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //             if($date->year < $currentYear){
// //             $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($weekRemaining <= 1) {
// //             $price = 550;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice;
// //         } else {
// //             $price = 550;
// //             // if($request['product_on_sign'] === true){
// //             //     $price += $price / 2;
// //             // }
// //             $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //             if($date->year < $currentYear){
// //             $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //             $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Flags') {
// //     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //     $getSquareMeter = $intLength * $intWidth;
// //     $price = 40000;
// //     $priceperday = ($price/12) * $no_of_signs;
// //     $totalPrice += $dayRemaining * $priceperday;
// //     if($date->year < $currentYear){
// //         $previousTotal += $dayRemainingLastYear * $priceperday;
// //         $currentTotal += $totalPrice - $previousTotal;
// //     }else{
// //         $currentTotal += $totalPrice;
// //     }    
// //     }
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Small shops') {
// //     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //     $getSquareMeter = $intLength * $intWidth;
// //     $price = 20000;
// //     $priceperday = ($price/12) * $no_of_signs;
// //     $totalPrice += $dayRemaining * $priceperday;
// //     if($date->year < $currentYear){
// //         $previousTotal += $dayRemainingLastYear * $priceperday;
// //         $currentTotal += $totalPrice - $previousTotal;
// //     }else{
// //         $currentTotal += $totalPrice;
// //     }    
// //     }
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Street Directional Sign') {
// //     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //     $getSquareMeter = $intLength * $intWidth;
// //     $price = 60000;
// //     $priceperday = ($price/12) * $no_of_signs;
// //     $totalPrice += $dayRemaining * $priceperday;
// //     if($date->year < $currentYear){
// //         $previousTotal += $dayRemainingLastYear * $priceperday;
// //         $currentTotal += $totalPrice - $previousTotal;
// //     }else{
// //         $currentTotal += $totalPrice;
// //     }    
// //     }
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Street Light Pole Directional Sign') {
// //     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //     $getSquareMeter = $intLength * $intWidth;
// //     $price = 60000;
// //     $priceperday = ($price/12) * $no_of_signs;
// //     $totalPrice += $dayRemaining * $priceperday;
// //     if($date->year < $currentYear){
// //         $previousTotal += $dayRemainingLastYear * $priceperday;
// //         $currentTotal += $totalPrice - $previousTotal;
// //     }else{
// //         $currentTotal += $totalPrice;
// //     }    
// //     }
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Sign') {
// //     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //     $getSquareMeter = $intLength * $intWidth;
// //     if ($getSquareMeter <= 5) {
// //         $price = 1000000;
// //         $totalPrice += $totalYears * $price;
// //         if($date->year < $currentYear){
// //             $previousTotal += $yearsDifference * $price;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     } elseif ($getSquareMeter <= 10) {
// //         $price = 2500000;
// //         $totalPrice += $totalYears * $price;
// //         if($date->year < $currentYear){
// //             $previousTotal += $yearsDifference * $price;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     } elseif ($getSquareMeter <= 15) {
// //         $price = 3500000;
// //         $totalPrice += $totalYears * $price;
// //         if($date->year < $currentYear){
// //             $previousTotal += $yearsDifference * $price;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 30) {
// //             $price = 25000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
// //             $price = 40000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 30) {
// //             $price = 50000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
// //             $price = 75000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 30) {
// //             $price = 100000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
// //             $price = 150000;
// //             $totalPrice += $totalYears * $price;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $yearsDifference * $price;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 5940;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 8316;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 9180;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 13770;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 20160;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 39600;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 15840;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 22176;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 24480;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 36720;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 40320;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 63360;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 25920;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 36288;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 40320;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 60480;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 67680;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 106560;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 39600;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 50940;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 61200;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 91800;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 100800;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 158400;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 32760;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 39312;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 50505;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 60606;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 77805;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 120120;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }  elseif  ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 42120;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 50544;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 64935;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 77922;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 100035;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 154035;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif  ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 70200;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 84240;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 108810;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 130572;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 168480;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 261495;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     } elseif  ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //         if ($getSquareMeter <= 1) {
// //             $price = 97200;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 3) {
// //             $price = 116240;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 5) {
// //             $price = 149850;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 7) {
// //             $price = 179820;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 10) {
// //             $price = 230850;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter <= 15) {
// //             $price = 356400;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         } elseif ($getSquareMeter > 15) {
// //             $price = ($getSquareMeter / 15) * 3500000;
// //             if($request['product_on_sign'] === true){
// //                 $price += $price / 2;
// //             }
// //             $priceperday = ($price/12) * $no_of_signs;
// //             $totalPrice += $dayRemaining * $priceperday;
// //             if($date->year < $currentYear){
// //                 $previousTotal += $dayRemainingLastYear * $priceperday;
// //                 $currentTotal += $totalPrice - $previousTotal;
// //             }else{
// //                 $currentTotal += $totalPrice;
// //             }
// //         }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
// //             $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //             $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //             $getSquareMeter = $intLength * $intWidth;
// //             $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //             if ($getSquareMeter <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 0;
// //                 }else{
// //                     $price = 0;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 3) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 2400;
// //                 }else{
// //                     $price = 2400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 5) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 3060;
// //                 }else{
// //                     $price = 3060;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 7) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 4590;
// //                 }else{ 
// //                     $price = 4590;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12 ) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 10) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 6720;
// //                 }else{ 
// //                     $price = 6720;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 13) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 10080;
// //                 }else{ 
// //                     $price = 10080;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 15) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 13200;
// //                 }else{ 
// //                     $price = 13200;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 25) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 30000;
// //                 }else{ 
// //                     $price = 30000;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter > 25) {
// //                 if ($weekRemaining <= 1) {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 160;
// //                     }else{ 
// //                         $price = 160;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice += $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice;
// //                 } else {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 160;
// //                     }else{ 
// //                         $price = 160;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                     if($date->year < $currentYear){
// //                     $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                     }else{
// //                         $currentTotal += $totalPrice;
// //                     }
// //                 }
// //             }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
// //             $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //             $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //             $getSquareMeter = $intLength * $intWidth;
// //             $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //             if ($getSquareMeter <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 0;
// //                 }else{ 
// //                     $price = 0;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 3) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 2400;
// //                 }else{ 
// //                     $price = 2400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 5) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 8160;
// //                 }else{ 
// //                     $price = 8160;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 7) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 12240;
// //                 }else{ 
// //                     $price = 12240;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 10) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 13440;
// //                 }else{ 
// //                     $price = 13440;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 13) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 20160;
// //                 }else{ 
// //                     $price = 20160;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 15) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 21120;
// //                 }else{ 
// //                     $price = 21120;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 25) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 60000;
// //                 }else{ 
// //                     $price = 60000;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter > 25) {
// //                 if ($weekRemaining <= 1) {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 160;
// //                     }else{ 
// //                         $price = 160;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice;
// //                 } else {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 160;
// //                     }else{ 
// //                         $price = 160;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                     if($date->year < $currentYear){
// //                     $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                     }else{
// //                         $currentTotal += $totalPrice;
// //                     }
// //                 }
// //             }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
// //             $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //             $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //             $getSquareMeter = $intLength * $intWidth;
// //             $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //             if ($getSquareMeter <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 0;
// //                 }else{ 
// //                     $price = 0;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 3) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 2400;
// //                 }else{ 
// //                     $price = 2400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 5) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 13440;
// //                 }else{ 
// //                     $price = 13440;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 7) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 20160;
// //                 }else{ 
// //                     $price = 20160;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 10) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 22560;
// //                 }else{ 
// //                     $price = 22560;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 13) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 33840;
// //                 }else{ 
// //                     $price = 33840;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 15) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 35540;
// //                 }else{ 
// //                     $price = 35540;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 25) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 140000;
// //                 }else{ 
// //                     $price = 140000;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter > 25) {
// //                 if ($weekRemaining <= 1) {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 225;
// //                     }else{ 
// //                         $price = 225;
// //                     }
// //                     $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice;
// //                 } else {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 225;
// //                     }else{ 
// //                         $price = 225;
// //                     }
// //                     $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                     if($date->year < $currentYear){
// //                     $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                     }else{
// //                         $currentTotal += $totalPrice;
// //                     }
// //                 }
// //             }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
// //             $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //             $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //             $getSquareMeter = $intLength * $intWidth;
// //             $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
// //             if ($getSquareMeter <= 1) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 0;
// //                 }else{ 
// //                     $price = 0;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 3) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 2400;
// //                 }else{ 
// //                     $price = 2400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 5) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 20400;
// //                 }else{ 
// //                     $price = 20400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 7) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 30600;
// //                 }else{ 
// //                     $price = 30600;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 10) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 33600;
// //                 }else{ 
// //                     $price = 33600;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 13) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 50400;
// //                 }else{ 
// //                     $price = 50400;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 15) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 52800;
// //                 }else{ 
// //                     $price = 52800;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter <= 25) {
// //                 if($request['bank_and_others'] === true){
// //                     $price = 200000;
// //                 }else{ 
// //                     $price = 200000;
// //                 }
// //                 if($request['product_on_sign'] === true){
// //                     $price += $price / 2;
// //                 }
// //                 $priceperday = ($price/12) * $no_of_signs;
// //                 $totalPrice += $dayRemaining * $priceperday;
// //                 if($date->year < $currentYear){
// //                     $previousTotal += $dayRemainingLastYear * $priceperday;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                 }else{
// //                     $currentTotal += $totalPrice;
// //                 }
// //             } elseif ($getSquareMeter > 25) {
// //                 if ($weekRemaining <= 1) {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 275;
// //                     }else{ 
// //                         $price = 275;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice +=  $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice;
// //                 } else {
// //                     if($request['bank_and_others'] === true){
// //                         $price = 275;
// //                     }else{ 
// //                         $price = 275;
// //                     }
// //                     if($request['product_on_sign'] === true){
// //                         $price += $price / 2;
// //                     }
// //                     $totalPrice += $weekRemaining * $price * $getSquareMeter * $no_of_signs;
// //                     if($date->year < $currentYear){
// //                     $previousTotal += $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
// //                     $currentTotal += $totalPrice - $previousTotal;
// //                     }else{
// //                         $currentTotal += $totalPrice;
// //                     }
// //                 }
// //             }
// //     }
// //     }
// //     if ($request['street_category'] == 'Rural Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
// //         $price = 70000;
// //         if($request['product_on_sign'] === true){
// //             $price += $price / 2;
// //         }
// //         $priceperday = ($price/12) * $no_of_signs;
// //         $totalPrice += $dayRemaining * $priceperday;
// //         if($date->year < $currentYear){
// //             $previousTotal += $dayRemainingLastYear * $priceperday;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Normal Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
// //         $price = 70000;
// //         if($request['product_on_sign'] === true){
// //             $price += $price / 2;
// //         }
// //         $priceperday = ($price/12) * $no_of_signs;
// //         $totalPrice += $dayRemaining * $priceperday;
// //         if($date->year < $currentYear){
// //             $previousTotal += $dayRemainingLastYear * $priceperday;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'Restrictive Zone N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
// //         $price = 70000;
// //         if($request['product_on_sign'] === true){
// //             $price += $price / 2;
// //         }
// //         $priceperday = ($price/12) * $no_of_signs;
// //         $totalPrice += $dayRemaining * $priceperday;
// //         if($date->year < $currentYear){
// //             $previousTotal += $dayRemainingLastYear * $priceperday;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     }
// //     } elseif ($request['street_category'] == 'High Street N') {
// //     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
// //         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
// //         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
// //         $getSquareMeter = $intLength * $intWidth;
// //         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
// //         $price = 70000;
// //         if($request['product_on_sign'] === true){
// //             $price += $price / 2;
// //         }
// //         $priceperday = ($price/12) * $no_of_signs;
// //         $totalPrice += $dayRemaining * $priceperday;
// //         if($date->year < $currentYear){
// //             $previousTotal += $dayRemainingLastYear * $priceperday;
// //             $currentTotal += $totalPrice - $previousTotal;
// //         }else{
// //             $currentTotal += $totalPrice;
// //         }
// //     }
// //     }

// //     OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($totalPrice/$no_of_signs, 2), 'previous_rate' => round($previousTotal/$no_of_signs, 2)]);
// //     $newTotal [] = $totalPrice;
// //     $newpreviousTotal [] = $previousTotal;
// //     $newcurrentTotal [] = $currentTotal;
// // }

//         for($i=0;$i<=$count;$i++) {
//     $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquare = $intLeng * $intWid;
    
//     $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
//                               ->where('sign_type', $onpremiseInfo[$i]['type_of_sign'])
//                               ->where('is_bank_other_price', $request['bank_and_others'])
//                               ->where(function ($query) use ($getSquare) {
//                                   $query->where(function ($q) use ($getSquare) {
//                                       // Case for range pricing: min <= squareMeter <= max
//                                       $q->whereNotNull('min_square_meter')
//                                         ->whereNotNull('max_square_meter')
//                                         ->where('min_square_meter', '<=', $getSquare)
//                                         ->where('max_square_meter', '>=', $getSquare);
//                                   })->orWhere(function ($q) use ($getSquare) {
//                                       // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
//                                       $q->whereNull('min_square_meter')
//                                         ->whereNull('max_square_meter');
//                                   })->orWhere(function ($q) use ($getSquare) {
//                                       // Case for "< X" pricing: only max_square_meter is set
//                                       $q->whereNull('min_square_meter')
//                                         ->whereNotNull('max_square_meter')
//                                         ->where('max_square_meter', '>', $getSquare); // Note: Assuming max is exclusive for '< X' logic, adjust if inclusive.
//                                   })->orWhere(function ($q) use ($getSquare) {
//                                       // Case for "> X" pricing: only min_square_meter is set
//                                       $q->whereNotNull('min_square_meter')
//                                         ->whereNull('max_square_meter')
//                                         ->where('min_square_meter', '<=', $getSquare); // Note: Assuming min is inclusive for '> X' logic.
//                                   });
//                               })
//                               ->first();
    
    
//     $request['product_on_sign'] = $onpremiseInfo[$i]['product_on_sign'];
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12 ) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 25) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 25) {
//         if ($weekRemaining <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice = $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice;
//         } else {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//             if($date->year < $currentYear){
//             $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 25) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 25) {
//         if ($weekRemaining <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice;
//         } else {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//             if($date->year < $currentYear){
//             $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 25) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 25) {
//         if ($weekRemaining <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice;
//         } else {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//             if($date->year < $currentYear){
//             $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 25) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 25) {
//         if ($weekRemaining <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice;
//         } else {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             // if($request['product_on_sign'] === true){
//             //     $price += $price / 2;
//             // }
//             $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//             if($date->year < $currentYear){
//             $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//             $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Projecting Signs/Snapper Frame/Lollipop') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20 || $getSquareMeter > 20) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//         }
        
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;
//         }
        
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 36) {
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }
        
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;  
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;  
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm; 
            
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         } 
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;  
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = ($getSquareMeter / 36) * $pricingRule;  
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;  

//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = $pricingRule->price_per_sqm;  
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = $pricingRule->price_per_sqm;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 36) {
//         if($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding'){
//             $price = ($getSquareMeter / 36) * $pricingRule;  
//         }elseif($onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs'){
//             $price = ($getSquareMeter / 36) * $pricingRule;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Enchroachment Fee N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Freestanding' || $onpremiseInfo[$i]['type_of_sign'] == 'Sky Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 13) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         if($request['bank_and_others'] === true){
//             $price = $pricingRule->price_per_sqm;
//         }else{ 
//             $price = $pricingRule->price_per_sqm;
//         }
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 20) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 20 && $getSquareMeter <= 36) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 36) {
//         $price = ($getSquareMeter / 36) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($weekRemaining <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice;
//     } else {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//         if($date->year < $currentYear){
//         $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($weekRemaining <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice;
//     } else {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//         if($date->year < $currentYear){
//         $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($weekRemaining <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice;
//     } else {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//         if($date->year < $currentYear){
//         $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Wall Drapes') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($weekRemaining <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice;
//     } else {
//         $price = $pricingRule->price_per_sqm;
//         // if($request['product_on_sign'] === true){
//         //     $price += $price / 2;
//         // }
//         $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//         if($date->year < $currentYear){
//         $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//         $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Flags') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     $price = $pricingRule->price_per_sqm;
//     // var_dump($price);die();
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//     $previousTotal = $dayRemainingLastYear * $priceperday;
//     $currentTotal = $totalPrice - $previousTotal;
//     }else{
//     $currentTotal = $totalPrice;
//     }    
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Small shops') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     $price = $pricingRule->price_per_sqm;
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//     $previousTotal = $dayRemainingLastYear * $priceperday;
//     $currentTotal = $totalPrice - $previousTotal;
//     }else{
//     $currentTotal = $totalPrice;
//     }    
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Buntings') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     $price = $pricingRule->price_per_sqm;
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//     $previousTotal = $dayRemainingLastYear * $priceperday;
//     $currentTotal = $totalPrice - $previousTotal;
//     }else{
//     $currentTotal = $totalPrice;
//     }    
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Street Directional Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     $price = $pricingRule->price_per_sqm;
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//     $previousTotal = $dayRemainingLastYear * $priceperday;
//     $currentTotal = $totalPrice - $previousTotal;
//     }else{
//     $currentTotal = $totalPrice;
//     }    
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Street Light Pole Directional Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     $price = $pricingRule->price_per_sqm;
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//     $previousTotal = $dayRemainingLastYear * $priceperday;
//     $currentTotal = $totalPrice - $previousTotal;
//     }else{
//     $currentTotal = $totalPrice;
//     }    
//     }
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     $getSquareMeter = $intLength * $intWidth;
//     if ($getSquareMeter <= 5) {
//     $price = $pricingRule->price_per_sqm * $no_of_signs;
//     $totalPrice = $totalYears * $price;
//     if($date->year < $currentYear){
//         $previousTotal = $yearsDifference * $price;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     } elseif ($getSquareMeter <= 10) {
//     $price = $pricingRule->price_per_sqm * $no_of_signs;
//     $totalPrice = $totalYears * $price;
//     if($date->year < $currentYear){
//         $previousTotal = $yearsDifference * $price;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     } elseif ($getSquareMeter <= 15) {
//     $price = $pricingRule->price_per_sqm * $no_of_signs;
//     $totalPrice = $totalYears * $price;
//     if($date->year < $currentYear){
//         $previousTotal = $yearsDifference * $price;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     }
//     }
//     if ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 30) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 30) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Led Screens At Filling Stations') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 30) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 30 && $getSquareMeter < 60) {
//         $price = $pricingRule->price_per_sqm;
//         $totalPrice = $totalYears * $price;
//         if($date->year < $currentYear){
//             $previousTotal = $yearsDifference * $price;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = 15840;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = 22176;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Wall/Canopy/Roof Signs/Flat Signs') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }  elseif  ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif  ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     } elseif  ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Neon Freestanding/Sky Sign') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//     if ($getSquareMeter <= 1) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 3) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 5) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 7) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 10) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter <= 15) {
//         $price = $pricingRule->price_per_sqm;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     } elseif ($getSquareMeter > 15) {
//         $price = ($getSquareMeter / 15) * $pricingRule;
//         if($request['product_on_sign'] === true){
//             $price += $price / 2;
//         }
//         $priceperday = ($price/12) * $no_of_signs;
//         $totalPrice = $dayRemaining * $priceperday;
//         if($date->year < $currentYear){
//             $previousTotal = $dayRemainingLastYear * $priceperday;
//             $currentTotal = $totalPrice - $previousTotal;
//         }else{
//             $currentTotal = $totalPrice;
//         }
//     }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
//         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//         $getSquareMeter = $intLength * $intWidth;
//         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//         if ($getSquareMeter <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = 0;
//             }else{
//                 $price = 0;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 3) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 5) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 7) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12 ) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 10) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 13) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 15) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 25) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter > 25) {
//             if ($weekRemaining <= 1) {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice = $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice;
//             } else {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//                 if($date->year < $currentYear){
//                 $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice - $previousTotal;
//                 }else{
//                     $currentTotal = $totalPrice;
//                 }
//             }
//         }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
//         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//         $getSquareMeter = $intLength * $intWidth;
//         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//         if ($getSquareMeter <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 3) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 5) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 7) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 10) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 13) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 15) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 25) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter > 25) {
//             if ($weekRemaining <= 1) {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice;
//             } else {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//                 if($date->year < $currentYear){
//                 $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice - $previousTotal;
//                 }else{
//                     $currentTotal = $totalPrice;
//                 }
//             }
//         }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
//         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//         $getSquareMeter = $intLength * $intWidth;
//         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//         if ($getSquareMeter <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 3) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 5) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 7) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 10) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 13) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 15) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 25) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter > 25) {
//             if ($weekRemaining <= 1) {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice;
//             } else {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//                 if($date->year < $currentYear){
//                 $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice - $previousTotal;
//                 }else{
//                     $currentTotal = $totalPrice;
//                 }
//             }
//         }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Window Display') {
//         $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//         $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//         $getSquareMeter = $intLength * $intWidth;
//         $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];
//         if ($getSquareMeter <= 1) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 3) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 5) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 7) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 10) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 13) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 15) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter <= 25) {
//             if($request['bank_and_others'] === true){
//                 $price = $pricingRule->price_per_sqm;
//             }else{ 
//                 $price = $pricingRule->price_per_sqm;
//             }
//             if($request['product_on_sign'] === true){
//                 $price += $price / 2;
//             }
//             $priceperday = ($price/12) * $no_of_signs;
//             $totalPrice = $dayRemaining * $priceperday;
//             if($date->year < $currentYear){
//                 $previousTotal = $dayRemainingLastYear * $priceperday;
//                 $currentTotal = $totalPrice - $previousTotal;
//             }else{
//                 $currentTotal = $totalPrice;
//             }
//         } elseif ($getSquareMeter > 25) {
//             if ($weekRemaining <= 1) {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice =  $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice;
//             } else {
//                 if($request['bank_and_others'] === true){
//                     $price = $pricingRule->price_per_sqm;
//                 }else{ 
//                     $price = $pricingRule->price_per_sqm;
//                 }
//                 if($request['product_on_sign'] === true){
//                     $price += $price / 2;
//                 }
//                 $totalPrice = $weekRemaining * $price * $getSquareMeter * $no_of_signs;
//                 if($date->year < $currentYear){
//                 $previousTotal = $weekRemainingLastYear * $price * $getSquareMeter * $no_of_signs;
//                 $currentTotal = $totalPrice - $previousTotal;
//                 }else{
//                     $currentTotal = $totalPrice;
//                 }
//             }
//         }
//     }
//     }
//     if ($request['street_category'] == 'Rural Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
//     $price = $pricingRule->price_per_sqm;
//     if($request['product_on_sign'] === true){
//         $price += $price / 2;
//     }
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//         $previousTotal = $dayRemainingLastYear * $priceperday;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     }
//     } elseif ($request['street_category'] == 'Normal Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
//     $price = $pricingRule->price_per_sqm;
//     if($request['product_on_sign'] === true){
//         $price += $price / 2;
//     }
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//         $previousTotal = $dayRemainingLastYear * $priceperday;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     }
//     } elseif ($request['street_category'] == 'Restrictive Zone N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
//     $price = $pricingRule->price_per_sqm;
//     if($request['product_on_sign'] === true){
//         $price += $price / 2;
//     }
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//         $previousTotal = $dayRemainingLastYear * $priceperday;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     }
//     } elseif ($request['street_category'] == 'High Street N') {
//     if ($onpremiseInfo[$i]['type_of_sign'] == 'Tank Farm') {
//     $intLength = floatval($onpremiseInfo[$i]['length_in_meter']);
//     $intWidth = floatval($onpremiseInfo[$i]['width_in_meter']);
//     $getSquareMeter = $intLength * $intWidth;
//     $no_of_signs = $onpremiseInfo[$i]['number_of_sign'];     
//     $price = $pricingRule->price_per_sqm;
//     if($request['product_on_sign'] === true){
//         $price += $price / 2;
//     }
//     $priceperday = ($price/12) * $no_of_signs;
//     $totalPrice = $dayRemaining * $priceperday;
//     if($date->year < $currentYear){
//         $previousTotal = $dayRemainingLastYear * $priceperday;
//         $currentTotal = $totalPrice - $previousTotal;
//     }else{
//         $currentTotal = $totalPrice;
//     }
//     }
//     }
    
//     OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($totalPrice/$no_of_signs, 2), 'previous_rate' => round($previousTotal/$no_of_signs, 2)]);
//     $newTotal [] = $totalPrice;
//     $newpreviousTotal [] = $previousTotal;
//     $newcurrentTotal [] = $currentTotal;
// }

//             $sumOfNewTotal = array_sum($newTotal);
//             $sumOfpreviousTotal = array_sum($newpreviousTotal);
//             $sumOfcurrentTotal = array_sum($newcurrentTotal);
// //        var_dump($date, $totalPrice); die();
//          if($request['accept_price'] == true) {
//              if(isset($request['reports_from_branchmanger'])){
//                 $bmcomment = $request['reports_from_branchmanger'];
//              }else{
//                  $bmcomment = "";
//              }
//              if(isset($request['comments'])){
//                  $ucomment = $request['comments'];
//              }else{
//                  $ucomment = "";
//              }
//              $onpremise = onpremise::where('id', $onpremiseId)->update(['status' => 'approved', 'rm_status' => 'pending', 'street_category' => $request['street_category'], 'installation_date' => $date, 'bank_and_others' => $request['bank_and_others'], 'bm_comment' => $bmcomment]);
//              $onpremiseAppHistory = new Apphistory();
//              $reportFile = $request['report_file'];
//              $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
//              $onpremiseAppHistory->who_performed_action = $user->id;
//              $onpremiseAppHistory->comments = $request['comments'];
//              $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
//              $onpremiseAppHistory->previous_ads_price = $sumOfpreviousTotal;
//              $onpremiseAppHistory->current_ads_price = $sumOfcurrentTotal;
//              $onpremiseAppHistory->ads_price = $sumOfNewTotal;
//              $onpremiseAppHistory->balance = $sumOfNewTotal;
//              $onpremiseAppHistory->bank_and_others = $request['bank_and_others'];
//              $onpremiseAppHistory->product_on_sign = $request['product_on_sign'];
//              $onpremiseAppHistory->onpremise_id  = $onpremiseId;
//              $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
//              $onpremiseObj->appHistory()->save($onpremiseAppHistory);
//              $permitOnpremise = new PermitStepOnpremise();
//              $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
//              $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
//              $activityInfo = new AdminActivity();
//              $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
//              $activityInfo->action = $fetchActivity;
//              $savedActivity = $user->adminActivity()->save($activityInfo);
//              $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
//              $seePrice = $onpremiseAppHistory['ads_price'];
//          } else {
//              $getInfo = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
//              $seePrice = $sumOfNewTotal;
//              //var_dump($getInfo['ads_price']); die();
//          }
         
//         return response()->json(['Total' => (int)$seePrice], 200);
//     }

    // public function approveOnpremise($onpremiseId, Request $request)
    // {
    //     $validate = Validator::make($request->all(), [
    //         'comments' => 'nullable|string|max:255',
    //         'reports_from_branchmanger' => 'required|string|max:255',
    //         'street_category' => 'required|string',
    //         'accept_price' => 'required|boolean',
    //         'report_file' => 'nullable|string',
    //         'installation_date' => 'required|date_format:Y-m-d',
    //         'bank_and_others' => 'required|boolean',
    //         'product_on_sign' => 'required|boolean'
    //     ]);

    //     if ($validate->fails()) {
    //         return response()->json(['errors' => $validate->errors()->all()], 422);
    //     }

    //     // $user = Auth::user();
    //     $getonpremise = onpremise::where('id', $onpremiseId)->get();
    //     $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
    //     $onpremiseObj = onpremise::find($getonpremise[0]['id']);
    //     $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();

    //     $date = Carbon::parse($request['installation_date'])->startOfMonth();
    //     $dateweek = Carbon::parse($request['installation_date']);

    //     $totalPrice = 0;
    //     $totalPreviousPrice = 0; // For previous year calculation

    //     foreach ($onpremiseInfo as $info) {
    //         $getSquareMeter = $info->length_in_meter * $info->width_in_meter;
    //         $type_of_sign = $info->type_of_sign; // Assuming this field exists in OnpremiseInfo
    //         $street_category = $request['street_category'];
    //         $bank_and_others = $request['bank_and_others'];
    //         $product_on_sign = $request['product_on_sign'];

    //         // --- Database Query for Pricing Rule ---
    //         $pricingRule = OnPremisePricingRule::where('street_category', $street_category)
    //                                   ->where('sign_type', $type_of_sign)
    //                                   ->where('is_bank_other_price', $bank_and_others)
    //                                   ->where(function ($query) use ($getSquareMeter) {
    //                                       $query->where(function ($q) use ($getSquareMeter) {
    //                                           // Case for range pricing: min <= squareMeter <= max
    //                                           $q->whereNotNull('min_square_meter')
    //                                             ->whereNotNull('max_square_meter')
    //                                             ->where('min_square_meter', '<=', $getSquareMeter)
    //                                             ->where('max_square_meter', '>=', $getSquareMeter);
    //                                       })->orWhere(function ($q) use ($getSquareMeter) {
    //                                           // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
    //                                           $q->whereNull('min_square_meter')
    //                                             ->whereNull('max_square_meter');
    //                                       })->orWhere(function ($q) use ($getSquareMeter) {
    //                                           // Case for "< X" pricing: only max_square_meter is set
    //                                           $q->whereNull('min_square_meter')
    //                                             ->whereNotNull('max_square_meter')
    //                                             ->where('max_square_meter', '>', $getSquareMeter); // Note: Assuming max is exclusive for '< X' logic, adjust if inclusive.
    //                                       })->orWhere(function ($q) use ($getSquareMeter) {
    //                                           // Case for "> X" pricing: only min_square_meter is set
    //                                           $q->whereNotNull('min_square_meter')
    //                                             ->whereNull('max_square_meter')
    //                                             ->where('min_square_meter', '<=', $getSquareMeter); // Note: Assuming min is inclusive for '> X' logic.
    //                                       });
    //                                   })
    //                                   ->first();

    //         if (!$pricingRule) {
    //             // Handle case where no pricing rule is found for the given criteria
    //             return response()->json(['error' => 'No pricing rule found for the given criteria.'], 404);
    //         }

    //         $priceperSquareMeter = $pricingRule->price_per_sqm;

    //         // Apply product_on_sign adjustment
    //         if ($product_on_sign) {
    //             $priceperSquareMeter = $priceperSquareMeter * 1.50; // Add 50%
    //         }

    //         // Price calculation remains largely similar, now using $priceperSquareMeter
    //         $priceperday = ($priceperSquareMeter / 12) * $info->number_of_sign;

    //         // Remaining date calculations and price accumulation logic (similar to your original code)
    //         $installationYear = Carbon::parse($info->installation_date)->year;
    //         $currentYear = Carbon::now()->year;

    //         if ($installationYear < $currentYear) {
    //             // Calculate previous year's price
    //             $dayRemainingLastYear = Carbon::parse($info->installation_date)->endOfYear()->diffInMonths(Carbon::parse($info->installation_date)->startOfMonth()) + 1;
    //             $previousTotal = $priceperday * $dayRemainingLastYear;
    //             $totalPreviousPrice += $previousTotal;

    //             // Calculate current year's price
    //             $dayRemaining = Carbon::now()->endOfYear()->diffInMonths(Carbon::now()->startOfMonth()) + 1;
    //             $currentTotal = $priceperday * $dayRemaining;
    //             $totalPrice += $currentTotal;

    //         } else {
    //             $dayRemaining = $date->endOfYear()->diffInMonths($date->startOfMonth()) + 1;
    //             $currentTotal = $priceperday * $dayRemaining;
    //             $totalPrice += $currentTotal;
    //         }
    //     }

    //     // Final calculation and response
    //     $seePrice = $totalPrice; // Adjust as needed based on how previous year's price fits in your final total logic

    //     return response()->json(['Total' => (int)$seePrice], 200);
    // }
    
    public function getOnpremisePricing (){
        
        $getPrices = OnPremisePricingRule::all();
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function getOnpremisePricingDistinct (){
        
        $getPrices = OnPremisePricingRule::distinct()->pluck('sign_type');
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function editOnpremisePricing (Request $request){
        
        $validate = Validator::make($request->all(), [
            'items' => 'required|array',
            'items.*.id' => 'required|integer|exists:onpremise_pricing_rule,id',
            'items.*.street_category' => 'nullable|string',
            'items.*.sign_type' => 'required|string|max:255',
            'items.*.min_square_meter' => 'nullable|integer',
            'items.*.max_square_meter' => 'nullable|integer',
            'items.*.price_per_sqm' => 'required|numeric',
            'items.*.is_bank_other_price' => 'required|boolean',
            'items.*.duration' => 'nullable|string',
        ]);
        
        if ($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        
        foreach ($request->items as $data) {
            $rule = OnPremisePricingRule::find($data['id']);
            $rule->street_category = $data['street_category'] ?? null;
            $rule->sign_type = $data['sign_type'];
            $rule->min_square_meter = $data['min_square_meter'] ?? null;
            $rule->max_square_meter = $data['max_square_meter'] ?? null;
            $rule->price_per_sqm = $data['price_per_sqm'];
            $rule->is_bank_other_price = $data['is_bank_other_price'];
            $rule->duration = $data['duration'];
            $rule->save();
        }
        
        
        return response()->json(['success' => true, 'data' => "Price Updated"], 200);
    }
    
    public function createOnpremisePricing (Request $request){
        
        $validate = Validator::make($request->all(), [
            'items' => 'required|array',
            'items.*.street_category' => 'nullable|string',
            'items.*.sign_type' => 'required|string|max:255',
            'items.*.min_square_meter' => 'nullable|integer',
            'items.*.max_square_meter' => 'nullable|integer',
            'items.*.price_per_sqm' => 'required|numeric',
            'items.*.is_bank_other_price' => 'required|boolean',
            'items.*.duration' => 'nullable|string',
        ]);
        
        if ($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        
        foreach ($request->items as $data) {
            $rule = new OnPremisePricingRule();
            $rule->street_category = $data['street_category'] ?? null;
            $rule->sign_type = $data['sign_type'];
            $rule->min_square_meter = $data['min_square_meter'] ?? null;
            $rule->max_square_meter = $data['max_square_meter'] ?? null;
            $rule->price_per_sqm = $data['price_per_sqm'];
            $rule->is_bank_other_price = $data['is_bank_other_price'];
            $rule->duration = $data['duration'];
            $rule->save();
        }
        
        
        return response()->json(['success' => true, 'data' => "Price Created"], 200);
    }
    
    public function deleteOnpremisePricing ($id){
        
        $rule = OnPremisePricingRule::find($id);
        $rule->delete();
        
        
        return response()->json(['success' => true, 'data' => "Price Deleted"], 200);
    }
    
    public function updateOnpremiseApplicationPricing(Request $request) {
        $validator = Validator::make($request->all(), [
            'property_type' => 'required|in:Single Business Unit,Multi-tenanted Business',
            'sign_type' => 'required|string',
            'base_price' => 'required|numeric|min:0',
            'additional_sign_price' => 'nullable|numeric|min:0',
            'combination_rules' => 'nullable|array',
            'combination_rules.led_and_street_directional' => 'nullable|numeric|min:0',
            'combination_rules.led_and_street_light' => 'nullable|numeric|min:0',
            'combination_rules.all_three' => 'nullable|numeric|min:0',
            'combination_rules.street_and_light_pole' => 'nullable|numeric|min:0',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $pricingRule = OnpremiseApplicationPricingRule::where('id', $request->id)->update([
                'property_type' => $request->property_type,
                'sign_type' => $request->sign_type,
                'base_price' => $request->base_price,
                'additional_sign_price' => $request->additional_sign_price ?? null,
                'combination_rules' => $request->combination_rules ?? []
            ]);

            return response()->json([
                'success' => true,
                'message' => 'Pricing updated successfully',
                'data' => $pricingRule,
                'id' => $request->id
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to update pricing',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function getOnpremiseApplicationPricingRules() {
        $rules = OnpremiseApplicationPricingRule::all();
        return response()->json([
            'success' => true,
            'data' => $rules
        ]);
    }

    
    public function approveRmOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
            if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }

             $onpremise = onpremise::where('id', $onpremiseId)->update(['rm_status' => 'approved', 'hod_status' => 'pending', 'rm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveHODOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
            if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }

             $onpremise = onpremise::where('id', $onpremiseId)->update(['hod_status' => 'approved', 'billing_status' => 'pending', 'hod_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveBillingOnpremise($onpremiseId) {
        // $validate = Validator::make($request->all(),  [
        //     'price' => 'required|numeric',
        //     'previous_ads_price' => 'required|numeric'
            
        // ]);

        // if($validate->fails()) {
        //     return response()->json(['errors' => $validate->errors()->all()], 422);
        // }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        
        for($i=0;  $i<=$count;  $i++) {

            $calculateRate [] = $onpremiseInfo[$i]['rate'] * $onpremiseInfo[$i]['number_of_sign'];
            $calculatePreviousRate [] = $onpremiseInfo[$i]['previous_rate'] * $onpremiseInfo[$i]['number_of_sign'];
        }
        
            $sumOfrate = array_sum($calculateRate);
            $sumOfpreviousrate = array_sum($calculatePreviousRate);

             if($onpremiseObj->billing_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
             $current_year = $sumOfrate - $sumOfpreviousrate;
             $onpremise = onpremise::where('id', $onpremiseId)->update(['billing_status' => 'approved']);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $request['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $sumOfpreviousrate;
             $onpremiseAppHistory->current_ads_price = $current_year;
             $onpremiseAppHistory->ads_price = $sumOfrate;
             $onpremiseAppHistory->balance = $sumOfrate;
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             onpremise::where('id', $onpremiseId)->update(['initial_amount_due' => $sumOfrate]);
             if($sumOfpreviousrate == 0){
                 onpremise::where('id', $onpremiseId)->update(['audit_status' => 'pending']);
                 
            // //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
            //  $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
            //  $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            // $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            // $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            // $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            // if (in_array($onpremiseObj->lga, $lcenLGAs)) {
            //     // The value of $mobileInput['lga'] is one of the allowed LGAs
            //     $zone = "Lagos Central";
            // }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
            //     $zone = "Lagos East";
            // }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
            //     $zone = "Lagos West 1";
            // }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
            //     $zone = "Lagos West 2";
            // } else {
            //     $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
            //     $selectedKey = array_rand($listArray);
            //     $selectValue = $listArray[$selectedKey];
            //     $zone = $selectValue;
            // }
            
            //  $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
            //  if($HODe){
            //      $HOD = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->first();
            //      $HODfn = $HOD->first_name;
            //      $HODln = $HOD->last_name;
            //  }else{
            //      $HODfn = "Adekunle";
            //      $HODln = "Afolabi";
            //  }
             
            //  // Part 1: Current date in "Ymd" format (e.g., 2232024)
            //  $part1 = date('Ymd');
            
            //  // Part 2: Random 3 uppercase letters (e.g., JJJ)
            //  $part2 = strtoupper(Str::random(3));
            
            //  // Part 3: Random alphanumeric value (e.g., 1P)
            //  $part3 = strtoupper(Str::random(2));
            
            //  // Part 4: Random number between 100000 and 999999 (e.g., 193974)
            //  $part4 = mt_rand(100000, 999999);
        
            //  // Combine all parts into the final string
            //  $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
            //  $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
            //  $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
            //  $countDetails = count($OnpremiseInfo) - 1;
            //  $signTypes = [];
            //  $quantitySigns = [];
    
            //  for($i=0;$i <= $countDetails; $i++) {
            //      $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
            //      $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
            //  }
            //  $combinedArray = [];
            //  foreach ($signTypes as $index => $value) {
            //      $combinedArray [] = [
            //          'key' => $value,
            //          'value' => $quantitySigns[$index],
            //         //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
            //      ];
                 
            //  }
                    
            //  $data = [
            //       'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
            //       'company' => $onpremiseObj->business_name,
            //       'address' => $onpremiseObj->sign_address,
            //       'startDate' => $startdate->format('jS F, Y'),
            //       'endDate' => $enddate->format('jS F, Y'),
            //       'zone' => $zone,
            //       'HOD_first_name' => $HODfn,
            //       'HOD_last_name' => $HODln,
            //       'barcode' => $barcoden
                  
            //  ];
            
            //  $pdf = Pdf::loadView('onpremiseapproval', compact('data', 'combinedArray'));
            //  $fileObj = $pdf->download('onpremiseapproval.pdf');
            
            //   $userObj = User::find($onpremiseObj->user_id);
            //  $body = "We are pleased to inform you that your application for first party signage display has been approved. Please find your approval letter attached";
            //  $templateData = [
            //      'body' => $body,
            //      'name' => $userObj->business_name
            //  ];
            //  $templateContent = view('hodeoitemplate', $templateData)->render();
            //  UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
            //  //Log::info('email sent to ' . $userObj->email);
             
             }else{
                 onpremise::where('id', $onpremiseId)->update(['account_status' => 'pending']);
             }
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveBillingInfoOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'price' => 'required|numeric',
            'previous_ads_price' => 'required|numeric',
            'street_category' => 'required|string'
            
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        
        $geton = OnpremiseInfo::where('id', $onpremiseId)->first();
        $udt = onpremise::where('id', $geton->onpremise_id)->update(['street_category' => $request['street_category']]);


        
        $onpremiseInfo = OnpremiseInfo::where('id', $onpremiseId)->update(['rate' => $request['price'], 'previous_rate' => $request['previous_ads_price']]);

    
             
        return response()->json(['Total' => $request['price']], 200);
    }
    
    public function approveAccountOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();

             if($onpremiseObj->account_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremise = onpremise::where('id', $onpremiseId)->update(['account_status' => 'approved', 'audit_status' => 'pending', 'account_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveAuditOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();

             if($onpremiseObj->audit_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremise = onpremise::where('id', $onpremiseId)->update(['audit_status' => 'approved', 'audit_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             
             if($onpremiseObj->onpremise_multiple_id == null){
                 
                 //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
                 $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
                 
                 
                 $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
                $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
                $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
                $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
                if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                    // The value of $mobileInput['lga'] is one of the allowed LGAs
                    $zone = "Lagos Central";
                }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                    $zone = "Lagos East";
                }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                    $zone = "Lagos West 1";
                }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                    $zone = "Lagos West 2";
                } else {
                    $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                    $selectedKey = array_rand($listArray);
                    $selectValue = $listArray[$selectedKey];
                    $zone = $selectValue;
                }
                
                 $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
                 if($HODe){
                     $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                     $HODfn = $HOD->first_name;
                     $HODln = $HOD->last_name;
                 }else{
                     $HODfn = "Adekunle";
                     $HODln = "Afolabi";
                 }
                 
                 // Part 1: Current date in "Ymd" format (e.g., 2232024)
                 $part1 = date('Ymd');
                
                 // Part 2: Random 3 uppercase letters (e.g., JJJ)
                 $part2 = strtoupper(Str::random(3));
                
                 // Part 3: Random alphanumeric value (e.g., 1P)
                 $part3 = strtoupper(Str::random(2));
                
                 // Part 4: Random number between 100000 and 999999 (e.g., 193974)
                 $part4 = mt_rand(100000, 999999);
            
                 // Combine all parts into the final string
                 $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
                 
                        
                 $startdate = Carbon::parse($onpremiseObj->installation_date)->tz('Africa/Lagos');
                 $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                 if($startdate->year < Carbon::parse($onpremiseObj->created_at)->year){
                     $startdate = Carbon::parse($onpremiseObj->created_at)->tz('Africa/Lagos')->startOfYear();
                 }
                        
                 $countDetails = count($OnpremiseInfo) - 1;
                 $signTypes = [];
                 $quantitySigns = [];
        
                 for($i=0;$i <= $countDetails; $i++) {
                     $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                     $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
                     $rate [] = $OnpremiseInfo[$i]['rate'];
                     $number [] = $OnpremiseInfo[$i]['number_of_sign'];
                 }
                 $combinedArray = [];
                 foreach ($signTypes as $index => $value) {
                     $combinedArray [] = [
                         'key' => $value,
                         'value' => round($quantitySigns[$index], 2),
                         'rate' => $rate[$index],
                         'number' => $number[$index],
                     ];
                     
                 }
                        
                 $data = [
                      'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                      'company' => $onpremiseObj->business_name,
                      'address' => $onpremiseObj->sign_address,
                      'startDate' => $startdate->format('jS F, Y'),
                      'endDate' => $enddate->format('jS F, Y'),
                      'zone' => $zone,
                      'HOD_first_name' => $HODfn,
                      'HOD_last_name' => $HODln,
                    //   'barcode' => $barcoden
                      'barcode' => $onpremiseObj->payment_id,
                      'prev' => $totalPrice['previous_ads_price'],
                      'comment' => $onpremiseObj->hod_comment
                      
                 ];
                
                 $pdf = Pdf::loadView('onpremiseapproval', compact('data', 'combinedArray'));
                 $fileObj = $pdf->download('onpremiseapproval.pdf');
                
                 $userObj = User::find($onpremiseObj->user_id);
                 $emailcontent = EmailContent::getContent('onpremise_approve_content');
                 $body = $emailcontent;
                 $templateData = [
                     'body' => $body,
                     'name' => $userObj->business_name
                 ];
                 $templateContent = view('hodeoitemplate', $templateData)->render();
                 UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
                 
                 $pdfContent = $pdf->output();
                 $filename = 'ApprovalLetter_' . now()->format('YmdHis') . '.pdf';
                 $relativePath = 'invoices/' . $filename;
                 $savePath = public_path($relativePath); // Full path to /public/invoices/
                 
                 if (!File::exists(public_path('invoices'))) {
                     File::makeDirectory(public_path('invoices'), 0755, true);
                 }
                 file_put_contents($savePath, $pdfContent);
                 $fileUrl = config('app.url') . '/public/' . $relativePath;
                 $adnewrec = new OnpremiseReceipts();
                 $adnewrec->link = $fileUrl;
                 $adnewrec->type = "Letter";
                //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                 $onpremiseObj->onpremisereceipts()->save($adnewrec);
                 //Log::info('email sent to ' . $userObj->email);
                 
                 
                 
                 
                    // $getThirdPartyDetails = ThirdPartyOutdoor::where('id', $getOutdoorObj->id)->with(['user', 'thirdPartyOutdoorSignDetails'])
                    //                                 ->with(['appHistoryThirdPartyOutdoor' => function($query) {
                    //                                             $query->latest()->first();
                    //                                 }])->get();
                    $userDetails = User::where('id', $onpremiseObj->user_id)->get();
                    $totalFee = $totalPrice['balance'];
                    $amountInWord = UtilMethods::getAmountInWords($totalFee);
    
                    $getDate = Carbon::parse($onpremiseObj->updated_at);
                    $getYear = $getDate->year;
                    $data = [
                        'custId' => $userDetails[0]['id'],
                        'email' => $onpremiseObj['email'],
                        'userType' => $userDetails[0]['user_type'],
                        'company' => $userDetails[0]['business_name'],
                        'officeAddress' => $onpremiseObj->sign_address,
                        'billYear' => $getYear,
                        'lga' => $onpremiseObj['lga'],
                        'appId' => $onpremiseObj->payment_id,
                        'billStartDate' => $startdate->format('jS F, Y'),
                        'billEndDate' => $enddate->format('jS F, Y'),
                        'zone' => $onpremiseObj['street_category'],
                        'arrears' => $totalPrice['balance'],
                        'current_charge' => $totalPrice['balance'],
                        'isfresh' => true,
                        'totalFee' => $totalFee,
                        'amountInWord' => $amountInWord
                    ];
    
    
                    $pdf = Pdf::loadView('BillInvoiceFirstParty', compact('data', 'combinedArray'))->setPaper('A3');
                    $fileObj = $pdf->download('BillInvoiceFirstParty.pdf');
    
                    // $getUserObj = User::find($userDetails[0]['user']['id']);
                    
                    $emailcontent = EmailContent::getContent('onpremisebill_approve_content');
    
                    $body = $emailcontent;
                    $templateData = [
                        'body' => $body,
                        'name' => $userDetails[0]['business_name']
                    ];
                    $templateContent = view('hodeoitemplate', $templateData)->render();
                    UtilMethods::billgenonpremise($userDetails[0]['email'], $templateContent, $fileObj);
                    
                    $pdfContent = $pdf->output();
                    $filename = 'BillInvoice_' . now()->format('YmdHis') . '.pdf';
                    $relativePath = 'invoices/' . $filename;
                    $savePath = public_path($relativePath); // Full path to /public/invoices/
                     
                    if (!File::exists(public_path('invoices'))) {
                        File::makeDirectory(public_path('invoices'), 0755, true);
                    }
                    file_put_contents($savePath, $pdfContent);
                    $fileUrl = config('app.url') . '/public/' . $relativePath;
                    $adnewrec = new OnpremiseReceipts();
                    $adnewrec->link = $fileUrl;
                    $adnewrec->type = "Invoice";
                    //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                    $onpremiseObj->onpremisereceipts()->save($adnewrec);
                 
             }else{
                 
                 $multipleadd = OnPremiseMultiple::find($onpremiseObj->onpremise_multiple_id);
                 $multipleadd->count += 1;
                 $multipleadd->save();
                 
                 if($multipleadd->total == $multipleadd->count){
                     
                     $fetchmult = onpremise::where('onpremise_multiple_id', $onpremiseObj->onpremise_multiple_id)->pluck('id');
                 
                     //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
                     $OnpremiseInfo = OnpremiseInfo::whereIn('onpremise_id', $fetchmult)->get();
                     
                     $allpremises = onpremise::whereIn('id', $fetchmult)->get();
                     
                     $allRecords = Apphistory::whereIn('onpremise_id', $fetchmult)
                         ->orderBy('onpremise_id')
                         ->orderBy('id', 'desc')
                         ->get();
                    
                     $apphistt = $allRecords->groupBy('onpremise_id')
                         ->map(function($group) {
                             return $group->first()->balance; // Get first (latest) balance for each group
                         })
                         ->sum();
                     
                     
                     $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
                    $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
                    $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
                    $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
                    if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                        // The value of $mobileInput['lga'] is one of the allowed LGAs
                        $zone = "Lagos Central";
                    }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                        $zone = "Lagos East";
                    }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                        $zone = "Lagos West 1";
                    }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                        $zone = "Lagos West 2";
                    } else {
                        $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                        $selectedKey = array_rand($listArray);
                        $selectValue = $listArray[$selectedKey];
                        $zone = $selectValue;
                    }
                    
                     $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
                     if($HODe){
                         $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                         $HODfn = $HOD->first_name;
                         $HODln = $HOD->last_name;
                     }else{
                         $HODfn = "Adekunle";
                         $HODln = "Afolabi";
                     }
                     
                     // Part 1: Current date in "Ymd" format (e.g., 2232024)
                     $part1 = date('Ymd');
                    
                     // Part 2: Random 3 uppercase letters (e.g., JJJ)
                     $part2 = strtoupper(Str::random(3));
                    
                     // Part 3: Random alphanumeric value (e.g., 1P)
                     $part3 = strtoupper(Str::random(2));
                    
                     // Part 4: Random number between 100000 and 999999 (e.g., 193974)
                     $part4 = mt_rand(100000, 999999);
                
                     // Combine all parts into the final string
                     $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
                     
                            
                     $startdate = Carbon::parse($onpremiseObj->installation_date)->tz('Africa/Lagos');
                     $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                     if($startdate->year < Carbon::parse($onpremiseObj->created_at)->year){
                         $startdate = Carbon::parse($onpremiseObj->created_at)->tz('Africa/Lagos')->startOfYear();
                     }
                     
                     $combinedArray = [];
                    
                     $combinedArray = array_map(function($onpremise, $premise) {
                         return [
                             'key' => $onpremise['type_of_sign'],
                             'value' => round((float)$onpremise['length_in_meter'] * (float)$onpremise['width_in_meter'], 2),
                             'rate' => $onpremise['rate'],
                             'number' => $onpremise['number_of_sign'],
                             'address' => $premise['sign_address'] ?? null,
                             'lga' => $premise['lga'] ?? null,
                             'appid' => $premise['payment_id'] ?? null,
                         ];
                     }, $OnpremiseInfo->toArray(), $allpremises->toArray());
                     

                     $combinedArray = array_filter($combinedArray, function($item) {
                         return !empty($item['key']) && !empty($item['address']);
                     });
                            
                     $data = [
                          'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                          'company' => $onpremiseObj->business_name,
                          'address' => $onpremiseObj->sign_address,
                          'startDate' => $startdate->format('jS F, Y'),
                          'endDate' => $enddate->format('jS F, Y'),
                          'zone' => $zone,
                          'HOD_first_name' => $HODfn,
                          'HOD_last_name' => $HODln,
                        //   'barcode' => $barcoden
                          'barcode' => $onpremiseObj->payment_id,
                          'prev' => $totalPrice['previous_ads_price'],
                          'comment' => $onpremiseObj->hod_comment
                          
                     ];
                    
                     $pdf = Pdf::loadView('onpremiseapprovalbulk', compact('data', 'combinedArray'));
                     $fileObj = $pdf->download('onpremiseapprovalbulk.pdf');
                    
                      $userObj = User::find($onpremiseObj->user_id);
                      $emailcontent = EmailContent::getContent('onpremise_approve_content');
                     $body = $emailcontent;
                     $templateData = [
                         'body' => $body,
                         'name' => $userObj->business_name
                     ];
                     $templateContent = view('hodeoitemplate', $templateData)->render();
                     UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
                     
                     $pdfContent = $pdf->output();
                     $filename = 'ApprovalBulkLetter_' . now()->format('YmdHis') . '.pdf';
                     $relativePath = 'invoices/' . $filename;
                     $savePath = public_path($relativePath); // Full path to /public/invoices/
                     
                     if (!File::exists(public_path('invoices'))) {
                         File::makeDirectory(public_path('invoices'), 0755, true);
                     }
                     file_put_contents($savePath, $pdfContent);
                     $fileUrl = config('app.url') . '/public/' . $relativePath;
                     $adnewrec = new OnpremiseReceipts();
                     $adnewrec->link = $fileUrl;
                     $adnewrec->type = "Letter";
                    //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                     $onpremiseObj->onpremisereceipts()->save($adnewrec);
                     //Log::info('email sent to ' . $userObj->email);
                     
                     
                     
                     
                        // $getThirdPartyDetails = ThirdPartyOutdoor::where('id', $getOutdoorObj->id)->with(['user', 'thirdPartyOutdoorSignDetails'])
                        //                                 ->with(['appHistoryThirdPartyOutdoor' => function($query) {
                        //                                             $query->latest()->first();
                        //                                 }])->get();
                        $userDetails = User::where('id', $onpremiseObj->user_id)->get();
                        // $totalFee = $totalPrice['balance'];
                        $totalFee = $apphistt;
                        $amountInWord = UtilMethods::getAmountInWords($totalFee);
        
                        $getDate = Carbon::parse($onpremiseObj->updated_at);
                        $getYear = $getDate->year;
                        $data = [
                            'custId' => $userDetails[0]['id'],
                            'email' => $onpremiseObj['email'],
                            'userType' => $userDetails[0]['user_type'],
                            'company' => $userDetails[0]['business_name'],
                            'officeAddress' => $onpremiseObj->sign_address,
                            'billYear' => $getYear,
                            'lga' => $onpremiseObj['lga'],
                            'appId' => $onpremiseObj->payment_id,
                            'billStartDate' => $startdate->format('jS F, Y'),
                            'billEndDate' => $enddate->format('jS F, Y'),
                            'zone' => $onpremiseObj['street_category'],
                            'arrears' => $apphistt,
                            'current_charge' => $apphistt,
                            'isfresh' => true,
                            'totalFee' => $totalFee,
                            'amountInWord' => $amountInWord
                        ];
        
        
                        $pdf = Pdf::loadView('BillInvoiceFirstPartyBulk', compact('data', 'combinedArray'))->setPaper('A3');
                        $fileObj = $pdf->download('BillInvoiceFirstPartyBulk.pdf');
        
                        // $getUserObj = User::find($userDetails[0]['user']['id']);
                        
                        $emailcontent = EmailContent::getContent('onpremisebill_approve_content');
    
                        $body = $emailcontent;
        
                        $templateData = [
                            'body' => $body,
                            'name' => $userDetails[0]['business_name']
                        ];
                        $templateContent = view('hodeoitemplate', $templateData)->render();
                        UtilMethods::billgenonpremise($userDetails[0]['email'], $templateContent, $fileObj);
                        
                        $pdfContent = $pdf->output();
                        $filename = 'BillInvoiceBulk_' . now()->format('YmdHis') . '.pdf';
                        $relativePath = 'invoices/' . $filename;
                        $savePath = public_path($relativePath); // Full path to /public/invoices/
                         
                        if (!File::exists(public_path('invoices'))) {
                            File::makeDirectory(public_path('invoices'), 0755, true);
                        }
                        file_put_contents($savePath, $pdfContent);
                        $fileUrl = config('app.url') . '/public/' . $relativePath;
                        $adnewrec = new OnpremiseReceipts();
                        $adnewrec->link = $fileUrl;
                        $adnewrec->type = "Invoice";
                        //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                        $onpremiseObj->onpremisereceipts()->save($adnewrec);
                     
                 }
                 
             }
             

                 
            
                
             
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveRemovalOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            // 'street_category' => 'required|string',
            'removal_date' => 'required|date_format:Y-m-d',
            'accept_price' => 'required|boolean',
            'report_file' => 'nullable|string',
            'bank_and_others' => 'nullable|boolean',
            'product_on_sign' => 'nullable|boolean'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        
        
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;

        $date = Carbon::parse($request['removal_date'])->startOfMonth();
        $dateweek = Carbon::parse($request['removal_date']);
        // var_dump($date->year);die();
        $dateNow = Carbon::now();
        $currentYear = Carbon::now()->year;
        $endofYear = Carbon::now()->endOfYear();
        $endOfLastYear = Carbon::now()->subYear()->endOfYear();
        $yearsDifference = $date->diffInYears(Carbon::now());
        
        $currentDate = Carbon::now();

        // Get the total number of days difference
        // $daysDifference = $date->diffInDays($currentDate);
        $daysDifference = $date->diffInMonths($endofYear);
        // var_dump(Carbon::now()->format('Y-m-d H:i:s'));die();
        
        // Convert the days to years (accounting for leap years)
        // $totalYears = round($daysDifference / 365.25);
        $daysDifference = $daysDifference + 1;
        $totalYears = $daysDifference / 12 ;
        
        if($date->year === $currentYear){
           $weekRemaining = $dateweek->diffInWeeks($endofYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
        }elseif($date->year < $currentYear){
            $weekRemaining = $dateweek->diffInWeeks($endofYear);
            $weekRemainingLastYear = $dateweek->diffInWeeks($endOfLastYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
           $dayRemainingLastYear = $date->diffInMonths($endOfLastYear); 
        }
        // var_dump($dayRemaining, $weekRemaining);die();
        
        $dayRemaining = $dayRemaining + 1;
        $weekRemaining = $weekRemaining + 1;
        


    $newTotal = [];
    $newpreviousTotal = [];
    $newcurrentTotal = [];

    for($i=0;$i<=$count;$i++) {

        $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
        $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
        $getSquare = $intLeng * $intWid;
        $numSigns = $onpremiseInfo[$i]['sign_to_remove'];
        $request['street_category'] = $getonpremise[0]['street_category'];
        $request['bank_and_others'] = $getonpremise[0]['bank_and_others'];
        
        $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                    ->where('sign_type', $onpremiseInfo[$i]['type_of_sign'])
                    ->where('is_bank_other_price', $request['bank_and_others'])
                    ->where(function ($query) use ($getSquare) {
                        $query->where(function ($q) use ($getSquare) {
                            // Case for range pricing: min <= squareMeter <= max
                            $q->whereNotNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare)
                                ->where('max_square_meter', '>=', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                            $q->whereNull('min_square_meter')
                                ->whereNull('max_square_meter');
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "< X" pricing: only max_square_meter is set
                            $q->whereNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('max_square_meter', '>', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "> X" pricing: only min_square_meter is set
                            $q->whereNotNull('min_square_meter')
                                ->whereNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare);
                        });
                    })
                    ->firstOrFail();
        
        
        $result = $this->calculatePrice(
                    $pricingRule,
                    $getSquare,
                    $numSigns,
                    $request['removal_date'],
                    $request['product_on_sign'],
                    $request['bank_and_others'],
                    "nonrenewal"
                );
    

        $newTotal[] = $result['total'];
        $newpreviousTotal[] = $result['previous'];
        $newcurrentTotal[] = $result['current'];
    }

            $sumOfNewTotal = array_sum($newTotal);
            $sumOfpreviousTotal = array_sum($newpreviousTotal);
            $sumOfcurrentTotal = array_sum($newcurrentTotal);

//        var_dump($date, $totalPrice); die();
         if($request['accept_price'] == true) {
             if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'approved', 'cp_status' => 'pending', 'bm_comment' => $bmcomment, 'removal_date' => $request['removal_date']]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = 0;
             $onpremiseAppHistory->current_ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->balance = $getFindPrice->last()->balance;
             $onpremiseAppHistory->bank_and_others = $request['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $request['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise removal ads with ads Id' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
         } else {
             $getInfo = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
             $seePrice = $sumOfNewTotal;
             //var_dump($getInfo['ads_price']); die();
         }
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveRemovalCPOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->cp_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['cp_status' => 'approved', 'rm_status' => 'pending', 'cp_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveRemovalRmOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
            if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }

             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['rm_status' => 'approved', 'hod_status' => 'pending', 'rm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveRemovalHODOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
            if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }

             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['hod_status' => 'approved', 'billing_status' => 'pending', 'hod_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveRemoveBillingOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'price' => 'required|numeric',
            
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->billing_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
            //  $current_year = $request['price'] - $request['previous_ads_price'];
             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['billing_status' => 'approved', 'audit_status' => 'pending']);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $request['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $request['price'];
             $onpremiseAppHistory->ads_price = $request['price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'] - $request['price'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             
             
             
             $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->where('sign_to_remove', '>', 0)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
             
             $userdetails = User::where('id', $onpremiseObj->user_id)->first();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $comm = [];
             if($countDetails == 0){
             $commentt = strtoupper($OnpremiseInfo[0]['type_of_sign']);
             }else{
               for($i=0;$i <= $countDetails; $i++) {
                 $comm [] = $OnpremiseInfo[$i]['type_of_sign'];
             }
             $commentt = implode(", ", $comm);
             }
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
             $amountInWord = UtilMethods::getAmountInWords($onpremiseObj->initial_amount_due - $request['price']);
                    
             $data = [
                  'date' => Carbon::now()->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'email' => $onpremiseObj->email,
                  'cust_id' => $onpremiseObj->user_id,
                  'ref_no' => $onpremiseObj->payment_id,
                  'user_type' => $userdetails->user_type,
                  'initial_amount_due' => $onpremiseObj->initial_amount_due,
                  'debit' => $request['price'],
                  'credit' => - $request['price'],
                  'note_type' => 'debit',
                  'amount_in_words' => $amountInWord,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => 'ADDITIONAL DEBIT NOTE FOR ' . $commentt . ' RATE'
                  
             ];
             
            
             $pdf = Pdf::loadView('CreditDebitNote', compact('data', 'combinedArray'))->setPaper('A3');
             $fileObj = $pdf->download('CreditDebitNote.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_remove_bill_approve_content');
              $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::debitnotefirstparty($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'CreditDebit_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
                 
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Credit / Debit";
             //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveRemovalAuditOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseObj->purpose_of_application = 'Approved Application';
        $onpremiseObj->save();
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        OnpremiseInfo::where('onpremise_id', $onpremiseId)->update(['sign_to_remove' => 0]);
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->audit_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremise = OnPremiseRemoval::where('onpremise_id', $onpremiseId)->latest()->first()->update(['audit_status' => 'approved', 'audit_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             

                 
            //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
             $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'prev' => 0,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => $opremoval->hod_comment
                  
             ];
            
             $pdf = Pdf::loadView('onpremiseapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremiseapproval.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_remove_approve_content');
             $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'ApprovalLetter_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
             
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Letter";
            //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveAdditionalOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            // 'street_category' => 'required|string',
            'accept_price' => 'required|boolean',
            'report_file' => 'nullable|string',
            'installation_date' => 'required|date_format:Y-m-d',
            'bank_and_others' => 'required|boolean',
            'product_on_sign' => 'required|boolean'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        
        
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->where('sign_to_add', '>', 0)->get();
        $count = count($onpremiseInfo) - 1;
        
        // var_dump($onpremiseInfo);die();

        $date = Carbon::parse($request['installation_date'])->startOfMonth();
        $dateweek = Carbon::parse($request['installation_date']);
        // var_dump($date->year);die();
        $dateNow = Carbon::now();
        $currentYear = Carbon::now()->year;
        $endofYear = Carbon::now()->endOfYear();
        $endOfLastYear = Carbon::now()->subYear()->endOfYear();
        $yearsDifference = $date->diffInYears(Carbon::now());
        
        $currentDate = Carbon::now();

        // Get the total number of days difference
        // $daysDifference = $date->diffInDays($currentDate);
        $daysDifference = $date->diffInMonths($endofYear);
        // var_dump(Carbon::now()->format('Y-m-d H:i:s'));die();
        
        // Convert the days to years (accounting for leap years)
        // $totalYears = round($daysDifference / 365.25);
        $daysDifference = $daysDifference + 1;
        $totalYears = $daysDifference / 12 ;
        
        if($date->year === $currentYear){
           $weekRemaining = $dateweek->diffInWeeks($endofYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
        }elseif($date->year < $currentYear){
            $weekRemaining = $dateweek->diffInWeeks($endofYear);
            $weekRemainingLastYear = $dateweek->diffInWeeks($endOfLastYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
           $dayRemainingLastYear = $date->diffInMonths($endOfLastYear); 
        }
        // var_dump($dayRemaining, $weekRemaining);die();
        
        $dayRemaining = $dayRemaining + 1;
        $weekRemaining = $weekRemaining + 1;


    $newTotal = [];
    $newpreviousTotal = [];
    $newcurrentTotal = [];

        for($i=0;$i<=$count;$i++) {

    $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
    $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
    $getSquare = $intLeng * $intWid;
    $numSigns = $onpremiseInfo[$i]['sign_to_add'];
    $request['street_category'] = $getonpremise[0]['street_category'];
    $request['bank_and_others'] = $getonpremise[0]['bank_and_others'];
    
    $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                    ->where('sign_type', $onpremiseInfo[$i]['type_of_sign'])
                    ->where('is_bank_other_price', $request['bank_and_others'])
                    ->where(function ($query) use ($getSquare) {
                        $query->where(function ($q) use ($getSquare) {
                            // Case for range pricing: min <= squareMeter <= max
                            $q->whereNotNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare)
                                ->where('max_square_meter', '>=', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                            $q->whereNull('min_square_meter')
                                ->whereNull('max_square_meter');
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "< X" pricing: only max_square_meter is set
                            $q->whereNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('max_square_meter', '>', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "> X" pricing: only min_square_meter is set
                            $q->whereNotNull('min_square_meter')
                                ->whereNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare);
                        });
                    })
                    ->firstOrFail();
    
    $result = $this->calculatePrice(
                    $pricingRule,
                    $getSquare,
                    $numSigns,
                    $request['installation_date'],
                    $onpremiseInfo[$i]['product_on_sign'],
                    $request['bank_and_others'],
                    "nonrenewal"
                );


    if ($numSigns > 0) {
        OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($result['total']/$numSigns, 2), 'previous_rate' => round($result['previous']/$numSigns, 2), 'product_on_sign' => $request['product_on_sign']]);
    }
    $newTotal [] = $result['total'];
    $newpreviousTotal [] = $result['previous'];
    $newcurrentTotal [] = $result['current'];
}

            $sumOfNewTotal = array_sum($newTotal);
            $sumOfpreviousTotal = array_sum($newpreviousTotal);
            $sumOfcurrentTotal = array_sum($newcurrentTotal);

        // var_dump($newTotal); die();
         if($request['accept_price'] == true) {
             if(isset($request['reports_from_branchmanger'])){
                $bmcomment = $request['reports_from_branchmanger'];
             }else{
                 $bmcomment = "";
             }
             if(isset($request['comments'])){
                 $ucomment = $request['comments'];
             }else{
                 $ucomment = "";
             }
             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['status' => 'approved', 'rm_status' => 'pending', 'installation_date' => $request['installation_date'], 'bm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = 0;
             $onpremiseAppHistory->current_ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->balance = $getFindPrice->last()->balance;
             $onpremiseAppHistory->bank_and_others = $request['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $request['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise removal ads with ads Id' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
         } else {
             $getInfo = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
             $seePrice = $sumOfNewTotal;
             //var_dump($getInfo['ads_price']); die();
         }
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveAdditionalCPOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->cp_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['cp_status' => 'approved', 'rm_status' => 'pending', 'cp_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveAdditionalRmOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
                if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }

             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['rm_status' => 'approved', 'hod_status' => 'pending', 'rm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveAdditionalHODOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
                if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }

             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['hod_status' => 'approved', 'billing_status' => 'pending', 'hod_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveAdditionalBillingOnpremise($onpremiseId) {
        // $validate = Validator::make($request->all(),  [
        //     'price' => 'required|numeric',
        //     'previous_ads_price' => 'required|numeric'
            
        // ]);

        // if($validate->fails()) {
        //     return response()->json(['errors' => $validate->errors()->all()], 422);
        // }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->where('sign_to_add', '>', 0)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first();
        for($i=0;  $i<=$count;  $i++) {

            $calculateRate [] = $onpremiseInfo[$i]['rate'] * $onpremiseInfo[$i]['sign_to_add'];
            $calculatePreviousRate [] = $onpremiseInfo[$i]['previous_rate'] * $onpremiseInfo[$i]['sign_to_add'];
        }
        
            $sumOfrate = array_sum($calculateRate);
            $sumOfpreviousrate = array_sum($calculatePreviousRate);

             if($opremoval->billing_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
            //  $current_year = $request['price'] - $request['previous_ads_price'];
             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['billing_status' => 'approved']);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $request['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = $sumOfpreviousrate;
             $onpremiseAppHistory->current_ads_price = $sumOfrate;
             $onpremiseAppHistory->ads_price = $sumOfrate;
             $onpremiseAppHistory->balance = $totalPrice['balance'] + $sumOfrate;
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             if($sumOfpreviousrate == 0){
                 OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['audit_status' => 'pending']);
             
             }else{
                 OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['account_status' => 'pending']);
             }
             
             
             
             $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->where('sign_to_add', '>', 0)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->updated_at)->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->updated_at)->endOfYear();
             
             $userdetails = User::where('id', $onpremiseObj->user_id)->first();
             
             $getDate = Carbon::parse($onpremiseObj->updated_at);
             $getYear = $getDate->year;
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
                 $rate [] = $OnpremiseInfo[$i]['rate'];
                 $number [] = $OnpremiseInfo[$i]['sign_to_add'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                     'rate' => $rate[$index],
                     'number' => $number[$index],
                 ];
                 
             }
             
             $amountInWord = UtilMethods::getAmountInWords($sumOfrate);
             
             $commentt = strtoupper($OnpremiseInfo[0]['type_of_sign']);
                    
             $data = [
                  'date' => Carbon::now()->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'officeAddress' => $onpremiseObj->sign_address,
                  'email' => $onpremiseObj->email,
                  'billYear' => $getYear,
                  'lga' => $onpremiseObj['lga'],
                  'custId' => $onpremiseObj->user_id,
                  'appId' => $onpremiseObj->payment_id,
                  'user_type' => $userdetails->user_type,
                  'initial_amount_due' => $onpremiseObj->initial_amount_due,
                  'debit' => $sumOfrate,
                  'credit' => $sumOfrate,
                  'note_type' => 'credit',
                  'amountInWord' => $amountInWord,
                  'billStartDate' => $startdate->format('jS F, Y'),
                  'billEndDate' => $enddate->format('jS F, Y'),
                  'zone' => $onpremiseObj['street_category'],
                  'arrears' => $totalPrice['balance'],
                  'current_charge' => $sumOfrate,
                  'isfresh' => false,
                  'totalFee' => $sumOfrate,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => 'ADDITIONAL DEBIT NOTE FOR ' . $commentt . ' RATE'
                  
             ];
             
            
            //  $pdf = Pdf::loadView('CreditDebitNote', compact('data', 'combinedArray'))->setPaper('A3');
            //  $fileObj = $pdf->download('CreditDebitNote.pdf');
            
            $pdf = Pdf::loadView('BillInvoiceFirstParty', compact('data', 'combinedArray'))->setPaper('A3');
            $fileObj = $pdf->download('BillInvoiceFirstParty.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_additional_bill_approve_content');
             $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::billgenonpremise($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'BillInvoice_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
             
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Invoice";
            //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveAdditionalAccountOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->account_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['account_status' => 'approved', 'audit_status' => 'pending', 'account_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveAdditionalAuditOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseObj->purpose_of_application = 'Approved Application';
        $onpremiseObj->save();
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        // $nobofsign = $onpremiseInfo
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $opremoval = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->audit_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremise = OnPremiseAdditional::where('onpremise_id', $onpremiseId)->latest()->first()->update(['audit_status' => 'approved', 'audit_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             

                 
            //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
             $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->where('sign_to_add', '>', 0)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
             for($i=0;$i <= $countDetails; $i++) {
                 $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                 $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
                 $prevRate [] = $OnpremiseInfo[$i]['previous_rate'];
             }
             $combinedArray = [];
             foreach ($signTypes as $index => $value) {
                 $combinedArray [] = [
                     'key' => $value,
                     'value' => round($quantitySigns[$index], 2),
                    //  'prev' => $prevRate[$index],
                    //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
                 ];
                 
             }
             
             $sumarr = array_sum($prevRate);
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'prev' => $sumarr,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => $opremoval->hod_comment
                  
             ];
            
             $pdf = Pdf::loadView('onpremiseapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremiseapproval.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_additional_approve_content');
             $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'ApprovalLetter_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
             
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Letter";
            //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
             $count = count($onpremiseInfo) - 1;
             for($i=0;$i<=$count;$i++){
                 $addup = $onpremiseInfo[$i]['number_of_sign'] + $onpremiseInfo[$i]['sign_to_add'];
                 $onpremiseInfo[$i]->update(['number_of_sign' => $addup, 'sign_to_add' => 0]);
             }
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveChangeOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            // 'street_category' => 'required|string',
            'accept_price' => 'required|boolean',
            'report_file' => 'nullable|string',
            'bank_and_others' => 'required|boolean',
            // 'product_on_sign' => 'required|boolean'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();
        
        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        // $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->first();
        // $count = count($onpremiseInfo) - 1;
        $onpremiseInfo = OnPremiseChange::whereIn('onpremise_info_id', $allnewchanges)->get();
        $countchange = count($onpremiseInfo) - 1;
        // var_dump($getonpremise[0]['id']);die();
        // $date = Carbon::parse($onpremiseInfo[0]['updated_at']);
        $date = Carbon::parse($onpremiseInfo[0]['created_at'])->startOfMonth();
        $dateweek = Carbon::parse($onpremiseInfo[0]['created_at']);
        // var_dump($date->year);die();
        $dateNow = Carbon::now();
        $currentYear = Carbon::now()->year;
        $endofYear = Carbon::now()->endOfYear();
        $endOfLastYear = Carbon::now()->subYear()->endOfYear();
        $yearsDifference = $date->diffInYears(Carbon::now());
        $streetcat = $getonpremise[0]['street_category'];
        
        $currentDate = Carbon::now();

        // Get the total number of days difference
        // $daysDifference = $date->diffInDays($currentDate);
        $daysDifference = $date->diffInMonths($endofYear);
        // var_dump(Carbon::now()->format('Y-m-d H:i:s'));die();
        
        // Convert the days to years (accounting for leap years)
        // $totalYears = round($daysDifference / 365.25);
        $daysDifference = $daysDifference + 1;
        $totalYears = $daysDifference / 12 ;
        
        if($date->year === $currentYear){
           $weekRemaining = $dateweek->diffInWeeks($endofYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
        }elseif($date->year < $currentYear){
            $weekRemaining = $dateweek->diffInWeeks($endofYear);
            $weekRemainingLastYear = $dateweek->diffInWeeks($endOfLastYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
           $dayRemainingLastYear = $date->diffInMonths($endOfLastYear); 
        }
        // var_dump($dayRemaining, $weekRemaining);die();
        
        $dayRemaining = $dayRemaining + 1;
        $weekRemaining = $weekRemaining + 1;
        


    $newTotal = [];
    $newpreviousTotal = [];
    $newcurrentTotal = [];

        for($i=0;$i<=$countchange;$i++) {
    $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
    $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
    $getSquare = $intLeng * $intWid;
    $numSigns = $onpremiseInfo[$i]['number_of_sign'];
    $request['street_category'] = $getonpremise[0]['street_category'];
    $request['product_on_sign'] = $onpremiseInfo[$i]['product_on_sign'];
    
    $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                    ->where('sign_type', $onpremiseInfo[$i]['type_of_sign'])
                    ->where('is_bank_other_price', $request['bank_and_others'])
                    ->where(function ($query) use ($getSquare) {
                        $query->where(function ($q) use ($getSquare) {
                            // Case for range pricing: min <= squareMeter <= max
                            $q->whereNotNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare)
                                ->where('max_square_meter', '>=', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                            $q->whereNull('min_square_meter')
                                ->whereNull('max_square_meter');
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "< X" pricing: only max_square_meter is set
                            $q->whereNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('max_square_meter', '>', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "> X" pricing: only min_square_meter is set
                            $q->whereNotNull('min_square_meter')
                                ->whereNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare);
                        });
                    })
                    ->firstOrFail();
    
    
    OnPremiseChange::where('id', $onpremiseInfo[$i]['id'])->update(['product_on_sign' => $request['product_on_sign']]);
    
    
    $result = $this->calculatePrice(
                    $pricingRule,
                    $getSquare,
                    $numSigns,
                    $onpremiseInfo[0]['created_at'],
                    $onpremiseInfo[$i]['product_on_sign'],
                    $request['bank_and_others'],
                    "nonrenewal"
                );
    

    OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($result['total']/$numSigns, 2), 'previous_rate' => round($result['previous']/$numSigns, 2)]);
    $newTotal[] = $result['total'];
    $newpreviousTotal[] = $result['previous'];
    $newcurrentTotal[] = $result['current'];
}

            $sumOfNewTotal = array_sum($newTotal);
            $sumOfpreviousTotal = array_sum($newpreviousTotal);
            $sumOfcurrentTotal = array_sum($newcurrentTotal);

    $newTotalRemove = [];
    $newpreviousTotalRemove = [];
    $newcurrentTotalRemove = [];
    
        for($i=0;$i<=$countchange;$i++) {
    $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
    $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
    $getSquare = $intLeng * $intWid;
    $numSigns = $onpremiseInfo[$i]['number_of_sign'];
    $request['street_category'] = $getonpremise[0]['street_category'];
    $request['product_on_sign'] = $onpremiseInfo[$i]['product_on_sign'];
    $onpremiseinfoner = OnpremiseInfo::where('id', (int)$onpremiseInfo[$i]['onpremise_info_id'])->first();
    
    $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                    ->where('sign_type', $onpremiseinfoner->type_of_sign)
                    ->where('is_bank_other_price', $request['bank_and_others'])
                    ->where(function ($query) use ($getSquare) {
                        $query->where(function ($q) use ($getSquare) {
                            // Case for range pricing: min <= squareMeter <= max
                            $q->whereNotNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare)
                                ->where('max_square_meter', '>=', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                            $q->whereNull('min_square_meter')
                                ->whereNull('max_square_meter');
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "< X" pricing: only max_square_meter is set
                            $q->whereNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('max_square_meter', '>', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "> X" pricing: only min_square_meter is set
                            $q->whereNotNull('min_square_meter')
                                ->whereNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare);
                        });
                    })
                    ->firstOrFail();
    

    OnPremiseChange::where('id', $onpremiseInfo[$i]['id'])->update(['product_on_sign' => $request['product_on_sign']]);
    
    
    $result = $this->calculatePrice(
                    $pricingRule,
                    $getSquare,
                    $numSigns,
                    $onpremiseInfo[0]['created_at'],
                    $onpremiseInfo[$i]['product_on_sign'],
                    $request['bank_and_others'],
                    "nonrenewal"
                );
    

    OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($result['total']/$numSigns, 2), 'previous_rate' => round($result['previous']/$numSigns, 2)]);
    $newTotalRemove [] = $result['total'];
    $newpreviousTotalRemove [] = $result['previous'];
    $newcurrentTotalRemove [] = $result['current'];
}

            $sumOfNewTotalRemove = array_sum($newTotalRemove);
            $sumOfpreviousTotalRemove = array_sum($newpreviousTotalRemove);
            $sumOfcurrentTotalRemove = array_sum($newcurrentTotalRemove);


         if($request['accept_price'] == true) {
             if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['status' => 'approved', 'rm_status' => 'pending', 'bm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = 0;
             $onpremiseAppHistory->current_ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->to_remove_ads_price = $sumOfNewTotalRemove;
             $onpremiseAppHistory->ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->balance = $getFindPrice->last()->balance;
             $onpremiseAppHistory->bank_and_others = $request['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $request['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise removal ads with ads Id' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
         } else {
             $getInfo = Apphistory::where('onpremise_id', $onpremiseId)->get()->last();
             $seePrice = $sumOfNewTotal;
             //var_dump($getInfo['ads_price']); die();
         }
        return response()->json(['Total' => (int)$seePrice], 200);
    }
    
    public function approveChangeCPOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('cp_status', 'pending')  // Use `whereNull` to check for NULL values
                            // ->pluck('onpremise_info_id')  // Pluck the `onpremise_info_id` column
                            ->latest('id')
                            ->first();
        $opremoval = OnPremiseChange::where('onpremise_id', $onpremiseId)->latest('id')->first();

             if($opremoval->cp_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['cp_status' => 'approved', 'rm_status' => 'pending', 'cp_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->to_remove_ads_price = $totalPrice['to_remove_ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveChangeRmOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('rm_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->first();
        $opremoval = OnPremiseChange::where('onpremise_id', $onpremiseId)->latest('id')->first();

             if($opremoval->rm_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['rm_status' => 'approved', 'hod_status' => 'pending', 'rm_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->to_remove_ads_price = $totalPrice['to_remove_ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveChangeHODOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('hod_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->first();
        $opremoval = OnPremiseChange::where('onpremise_id', $onpremiseId)->latest('id')->first();

             if($opremoval->hod_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
                 if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['hod_status' => 'approved', 'billing_status' => 'pending', 'hod_comment' => $bmcomment]);
             $onpremiseAppHistory = new Apphistory();
             $reportFile = $request['report_file'];
             $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
             $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->reports_from_branchmanger = $request['reports_from_branchmanger'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->to_remove_ads_price = $totalPrice['to_remove_ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveChangeBillingOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'price' => 'required|numeric',
            'to_remove_ads_price' => 'required|numeric'
            
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseInfo = OnPremiseChange::where('onpremise_id', $onpremiseId)->get();
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('billing_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->first();
        $opremoval = OnPremiseChange::where('onpremise_id', $onpremiseId)->latest()->first();
        
        $allnewchanges->ratetoremove = $request['to_remove_ads_price'];
        $allnewchanges->ratetoadd = $request['price'];
        $allnewchanges->save();
        
            $calculateRate = $request['price'] * $allnewchanges->number_of_sign;
            $calculatePreviousRate = $request['to_remove_ads_price'] * $allnewchanges->number_of_sign;
        
            $sumOfrate = $calculateRate;
            $sumOfpreviousrate = $calculatePreviousRate;

             if($opremoval->billing_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
            //  $current_year = $request['price'] - $request['previous_ads_price'];
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['billing_status' => 'approved', 'audit_status' => 'pending']);
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $request['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $request['comments'];
             $onpremiseAppHistory->previous_ads_price = 0;
             $onpremiseAppHistory->current_ads_price = $sumOfrate;
             $onpremiseAppHistory->to_remove_ads_price = $sumOfpreviousrate;
             $onpremiseAppHistory->ads_price = $sumOfrate;
             $onpremiseAppHistory->balance = $totalPrice['balance'] + $sumOfrate - $sumOfpreviousrate;
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             
             
             
             $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
             
             $userdetails = User::where('id', $onpremiseObj->user_id)->first();
                    
             $countDetails = count($onpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
            //  for($i=0;$i <= $countDetails; $i++) {
            //      $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
            //      $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
            //  }
            //  $combinedArray = [];
            //  foreach ($signTypes as $index => $value) {
            //      $combinedArray [] = [
            //          'key' => $value,
            //          'value' => $quantitySigns[$index],
            //         //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
            //      ];
                 
            //  }
            
            if ($allnewchanges) {  // Ensure the record exists
                $signTypes = [$allnewchanges['type_of_sign']];
                $quantitySigns = [(float)$allnewchanges['length_in_meter'] * (float)$allnewchanges['width_in_meter']];
                
                $combinedArray = [
                    [
                        'key' => $signTypes[0],
                        'value' => round($quantitySigns[0], 2),
                    ]
                ];
            }
            
             $amountInWord = UtilMethods::getAmountInWords($onpremiseObj->initial_amount_due + $sumOfrate - $sumOfpreviousrate);
             
             $commentt = strtoupper($allnewchanges->type_of_sign);
                    
             $data = [
                  'date' => Carbon::now()->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'email' => $onpremiseObj->email,
                  'cust_id' => $onpremiseObj->user_id,
                  'ref_no' => $onpremiseObj->payment_id,
                  'user_type' => $userdetails->user_type,
                  'initial_amount_due' => $onpremiseObj->initial_amount_due,
                  'debit' => $sumOfrate,
                  'credit' => $sumOfpreviousrate,
                  'note_type' => 'change',
                  'amount_in_words' => $amountInWord,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => 'ADDITIONAL CREDIT NOTE FOR ' . $commentt . ' RATE'
                  
             ];
             
            
             $pdf = Pdf::loadView('CreditDebitNote', compact('data', 'combinedArray'))->setPaper('A3');
             $fileObj = $pdf->download('CreditDebitNote.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_change_bill_approve_content');
             $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::debitnotefirstparty($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'CreditDebit_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
                 
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Credit / Debit";
             //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function approveChangeAuditOnpremise($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        $getonpremise = onpremise::where('id', $onpremiseId)->get();
        $getFindPrice = Apphistory::where('onpremise_id', $onpremiseId)->get();
        $onpremiseObj  = onpremise::find($getonpremise[0]['id']);
        $onpremiseObj->purpose_of_application = 'Approved Application';
        $onpremiseObj->save();
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
        // $nobofsign = $onpremiseInfo
        $count = count($onpremiseInfo) - 1;
        $totalPrice = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
        $allnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('audit_status', 'pending')  // Use `whereNull` to check for NULL values
                            ->latest('id')  // Pluck the `onpremise_info_id` column
                            ->first();
        // $getallnewchanges = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
        //                     ->where('audit_status', 'pending')
        //                     ->get()->last();
        $opremoval = OnPremiseChange::where('onpremise_id', $onpremiseId)->latest()->first();

             if($opremoval->audit_status == "approved"){
                 return response()->json(['data' => 'this action has been treated already'], 422);
             }else{
             
                OnpremiseInfo::create([
                    'onpremise_id' => $allnewchanges->onpremise_id,
                    'number_of_sign' => $allnewchanges->number_of_sign,
                    'type_of_sign' => $allnewchanges->type_of_sign,
                    'length_in_meter' => $allnewchanges->length_in_meter,
                    'rate' => $allnewchanges->ratetoadd,
                    'width_in_meter' => $allnewchanges->width_in_meter,
                    'product_on_sign' => $allnewchanges->product_on_sign,
                    'photo_montage' => $allnewchanges->photo_montage
                ]);
            
            //  $current_year = $totalPrice['price'] - $totalPrice['previous_ads_price'];
             $onpremiseAppHistory = new Apphistory();
            //  $reportFile = $totalPrice['report_file'];
            //  $onpremiseAppHistory->report_file = $this->convertBase64toPdf($reportFile);
             $onpremiseAppHistory->who_performed_action = $user->id;
            //  $onpremiseAppHistory->comments = $totalPrice['comments'];
             $onpremiseAppHistory->previous_ads_price = $totalPrice['previous_ads_price'];
             $onpremiseAppHistory->current_ads_price = $totalPrice['current_ads_price'];
             $onpremiseAppHistory->ads_price = $totalPrice['ads_price'];
             $onpremiseAppHistory->balance = $totalPrice['balance'];
             $onpremiseAppHistory->bank_and_others = $totalPrice['bank_and_others'];
             $onpremiseAppHistory->product_on_sign = $totalPrice['product_on_sign'];
             $onpremiseAppHistory->onpremise_id  = $onpremiseId;
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
             $activityInfo = new AdminActivity();
             $fetchActivity = 'Approve an onpremise ads with adsId' . $onpremiseId;
             $activityInfo->action = $fetchActivity;
             $savedActivity = $user->adminActivity()->save($activityInfo);
             $onpremiseAppHistory = Apphistory::where('onpremise_id', $getonpremise[0]['id'])->get()->last();
             $seePrice = $onpremiseAppHistory['ads_price'];
             

                 
            //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
             $OnpremiseInfo = OnPremiseChange::where('onpremise_id', $getonpremise[0]['id'])
                            ->where('audit_status', 'pending')
                            ->get();
             
             
             $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
            $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
            $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
            $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
            if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                // The value of $mobileInput['lga'] is one of the allowed LGAs
                $zone = "Lagos Central";
            }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                $zone = "Lagos East";
            }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                $zone = "Lagos West 1";
            }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                $zone = "Lagos West 2";
            } else {
                $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                $selectedKey = array_rand($listArray);
                $selectValue = $listArray[$selectedKey];
                $zone = $selectValue;
            }
            
             $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
             if($HODe){
                 $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                 $HODfn = $HOD->first_name;
                 $HODln = $HOD->last_name;
             }else{
                 $HODfn = "Adekunle";
                 $HODln = "Afolabi";
             }
             
             // Part 1: Current date in "Ymd" format (e.g., 2232024)
             $part1 = date('Ymd');
            
             // Part 2: Random 3 uppercase letters (e.g., JJJ)
             $part2 = strtoupper(Str::random(3));
            
             // Part 3: Random alphanumeric value (e.g., 1P)
             $part3 = strtoupper(Str::random(2));
            
             // Part 4: Random number between 100000 and 999999 (e.g., 193974)
             $part4 = mt_rand(100000, 999999);
        
             // Combine all parts into the final string
             $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
             
                    
             $startdate = Carbon::parse($onpremiseObj->created_at)->addMonth()->tz('Africa/Lagos');
             $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                    
             $countDetails = count($OnpremiseInfo) - 1;
             $signTypes = [];
             $quantitySigns = [];
    
            //  for($i=0;$i <= $countDetails; $i++) {
            //      $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
            //      $quantitySigns [] = $OnpremiseInfo[$i]['length_in_meter'] * $OnpremiseInfo[$i]['width_in_meter'];
            //  }
            //  $combinedArray = [];
            //  foreach ($signTypes as $index => $value) {
            //      $combinedArray [] = [
            //          'key' => $value,
            //          'value' => $quantitySigns[$index],
            //         //  'words' => $this->getWordsofNumber($quantitySigns[$index]),
            //      ];
                 
            //  }
            
            if ($allnewchanges) {  // Ensure the record exists
                $signTypes = [$allnewchanges['type_of_sign']];
                $quantitySigns = [(float)$allnewchanges['length_in_meter'] * (float)$allnewchanges['width_in_meter']];
                
                $combinedArray = [
                    [
                        'key' => $signTypes[0],
                        'value' => round($quantitySigns[0], 2),
                    ]
                ];
            }
                    
             $data = [
                  'date' => Carbon::parse($onpremiseObj->created_at)->format('jS F, Y'),
                  'company' => $onpremiseObj->business_name,
                  'address' => $onpremiseObj->sign_address,
                  'startDate' => $startdate->format('jS F, Y'),
                  'endDate' => $enddate->format('jS F, Y'),
                  'zone' => $zone,
                  'prev' => 0,
                  'HOD_first_name' => $HODfn,
                  'HOD_last_name' => $HODln,
                  'barcode' => $barcoden,
                  'comment' => $opremoval->hod_comment
                  
             ];
            
             $pdf = Pdf::loadView('onpremiseapproval', compact('data', 'combinedArray'));
             $fileObj = $pdf->download('onpremiseapproval.pdf');
            
              $userObj = User::find($onpremiseObj->user_id);
              $emailcontent = EmailContent::getContent('onpremise_change_approve_content');
             $body = $emailcontent;
             $templateData = [
                 'body' => $body,
                 'name' => $userObj->business_name
             ];
             $templateContent = view('hodeoitemplate', $templateData)->render();
             UtilMethods::onpremiseSendApproval($userObj->email, $templateContent, $fileObj);
             
             $pdfContent = $pdf->output();
             $filename = 'ApprovalLetter_' . now()->format('YmdHis') . '.pdf';
             $relativePath = 'invoices/' . $filename;
             $savePath = public_path($relativePath); // Full path to /public/invoices/
             
             if (!File::exists(public_path('invoices'))) {
                 File::makeDirectory(public_path('invoices'), 0755, true);
             }
             file_put_contents($savePath, $pdfContent);
             $fileUrl = config('app.url') . '/public/' . $relativePath;
             $adnewrec = new OnpremiseReceipts();
             $adnewrec->link = $fileUrl;
             $adnewrec->type = "Letter";
            //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
             $onpremiseObj->onpremisereceipts()->save($adnewrec);
             
             //Log::info('email sent to ' . $userObj->email);
             $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseId)->get();
             $count = count($onpremiseInfo) - 1;
             for($i=0;$i<=$count;$i++){
                 $addup = $onpremiseInfo[$i]['number_of_sign'] + $onpremiseInfo[$i]['sign_to_add'];
                 $onpremiseInfo[$i]->update(['number_of_sign' => $addup, 'sign_to_add' => 0]);
             }
             
             if(isset($request['reports_from_branchmanger'])){
                    $bmcomment = $request['reports_from_branchmanger'];
                 }else{
                     $bmcomment = "";
                 }
                 if(isset($request['comments'])){
                     $ucomment = $request['comments'];
                 }else{
                     $ucomment = "";
                 }
             
             $onpremise = OnPremiseChange::where('id', $allnewchanges->id)->update(['audit_status' => 'approved', 'audit_comment' => $bmcomment]);
             
             
        return response()->json(['Total' => (int)$seePrice], 200);
             }
    }
    
    public function EnableDisableProductOnSign($onpremiseId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'product_on_sign' => 'required|boolean',
            // 'type' => 'required|string'
            
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();


        // if($request['type'] == 'change'){
        //  $onpremiseInfo = OnPremiseChange::where('id', $onpremiseId)->update(['product_on_sign' => $request['product_on_sign']]);    
        // }else{}
         $onpremiseInfo = OnpremiseInfo::where('id', $onpremiseId)->update(['product_on_sign' => $request['product_on_sign']]);    
        

    
             
        return response()->json(['Total' => $onpremiseInfo], 200);
    }
    
    public function AdminEditOnPremise($onPremiseId, Request $request) {
        $validate = Validator::make($request->all(), [
            'sign_address' => 'required|string',
            'name_of_owner' => 'required|string',
            'business_name' => 'required|string',
            'phone_number' => 'required|string',
            'email' => 'nullable|email',
            'lga' => 'required|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }

        $onpremiseInput = $request->all();
        $output  = onpremise::find($onPremiseId);
        $output->sign_address = $onpremiseInput['sign_address'];
        $output->name_of_owner = $onpremiseInput['name_of_owner'];
        $output->business_name = $onpremiseInput['business_name'];
        $output->phone_number = $onpremiseInput['phone_number'];
        $output->email = $onpremiseInput['email'];
        $output->lga = $onpremiseInput['lga'];
        $output->save();
//        $calculatePrice [] = [];

        
        
        return response()->json(['success' => true], 200);
    }
    
    public function DeleteOnPremiseDetails($onPremiseId, Request $request) {
        $validate = Validator::make($request->all(), [
            'comments' => 'required|string',
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $findid = OnpremiseInfo::find($onPremiseId);
        $count = OnpremiseInfo::where('onpremise_id', $findid->onpremise_id)->count();
        $onpremiseInput = $request->all();
        if($count > 1){
            $output  = OnpremiseInfo::find($onPremiseId);
            $delete = $output->delete();
    //        $calculatePrice [] = [];
    
            $getonpremise = onpremise::where('id', $output->onpremise_id)->get();
            $getApplicant = User::where('id', $getonpremise[0]['user_id'])->get();
            $getApplicantEmail = $getApplicant[0]['email'];
            $subject = 'Update on Onpremise  Ads Application';
            $body = 'One of the Onpremise ads you applied for was deleted'. " " . " " . $request['comments'] . " ";
            //$this->composeEmail($subject, $body, $getApplicantEmail);
            $templateData = [
                'body' => $body,
                'name' => $getApplicant[0]['business_name'],
    
            ];
            $templateContent = view('emailtemplate', $templateData)->render();
            $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
    
            
            
            return response()->json(['success' => true], 200);
            
        }else{
            return response()->json(['errors' => "can't delete all, at least one must be remaining"], 422);
        }
    }
    
    public static function annualOnpremise() {
        
        $purpose = ['Application for New Sign','Approved Application'];
        
        $annoulall = onpremise::whereIn('purpose_of_application', $purpose)->where('audit_status', 'approved')->get();
        
        $getannoulallcount = count($annoulall) - 1;
        
        for ($p = 0; $p <= $getannoulallcount; $p++) {
        
        $year = Carbon::now()->year;
        if((int)$annoulall[$p]['permit_year'] < (int)$year){
        
        
        
        $getonpremise = onpremise::where('id', $annoulall[$p]['id'])->get();
        $getFindPrice = Apphistory::where('onpremise_id', $annoulall[$p]['id'])->latest()->first();
        $onpremiseObj  = onpremise::find($annoulall[$p]['id']);
        $onpremiseInfo = OnpremiseInfo::where('onpremise_id', $annoulall[$p]['id'])->get();
        $count = count($onpremiseInfo) - 1;

        $date = Carbon::now()->startOfYear();
        // var_dump($date->year);die();
        $dateNow = Carbon::now();
        $currentYear = Carbon::now()->year;
        $endofYear = Carbon::now()->endOfYear();
        $endOfLastYear = Carbon::now()->subYear()->endOfYear();
        $yearsDifference = $date->diffInYears(Carbon::now());
        
        $currentDate = Carbon::now();

        // Get the total number of days difference
        // $daysDifference = $date->diffInDays($currentDate);
        $daysDifference = $date->diffInMonths($endofYear);
        // var_dump(Carbon::now()->format('Y-m-d H:i:s'));die();
        
        // Convert the days to years (accounting for leap years)
        // $totalYears = round($daysDifference / 365.25);
        $daysDifference = $daysDifference + 1;
        $totalYears = $daysDifference / 12 ;
        
        if($date->year === $currentYear){
           $weekRemaining = $date->diffInWeeks($endofYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
        }elseif($date->year < $currentYear){
            $weekRemaining = $date->diffInWeeks($endofYear);
            $weekRemainingLastYear = $date->diffInWeeks($endOfLastYear);
           //var_dump($date, $weekRemaining); die();
           $dayRemaining = $date->diffInMonths($endofYear); 
           $dayRemainingLastYear = $date->diffInMonths($endOfLastYear); 
        }
        // var_dump($dayRemaining, $weekRemaining);die();
        
        $dayRemaining = $dayRemaining + 1;
        $weekRemaining = $weekRemaining + 1;



    $newTotal = [];
    $newpreviousTotal = [];
    $newcurrentTotal = [];

        for($i=0;$i<=$count;$i++) {

    $intLeng = floatval($onpremiseInfo[$i]['length_in_meter']);
    $intWid = floatval($onpremiseInfo[$i]['width_in_meter']);
    $getSquare = $intLeng * $intWid;
    $numSigns = $onpremiseInfo[$i]['number_of_sign'];
    $request['product_on_sign'] = $onpremiseInfo[$i]['product_on_sign'];
    $request['bank_and_others'] = $getonpremise[0]['bank_and_others'];
    $request['street_category'] = $getonpremise[0]['street_category'];
    
    $pricingRule = OnPremisePricingRule::where('street_category', $request['street_category'])
                    ->where('sign_type', $onpremiseInfo[$i]['type_of_sign'])
                    ->where('is_bank_other_price', $request['bank_and_others'])
                    ->where(function ($query) use ($getSquare) {
                        $query->where(function ($q) use ($getSquare) {
                            // Case for range pricing: min <= squareMeter <= max
                            $q->whereNotNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare)
                                ->where('max_square_meter', '>=', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for flat rate pricing: min_square_meter and max_square_meter are NULL
                            $q->whereNull('min_square_meter')
                                ->whereNull('max_square_meter');
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "< X" pricing: only max_square_meter is set
                            $q->whereNull('min_square_meter')
                                ->whereNotNull('max_square_meter')
                                ->where('max_square_meter', '>', $getSquare);
                        })->orWhere(function ($q) use ($getSquare) {
                            // Case for "> X" pricing: only min_square_meter is set
                            $q->whereNotNull('min_square_meter')
                                ->whereNull('max_square_meter')
                                ->where('min_square_meter', '<=', $getSquare);
                        });
                    })
                    ->firstOrFail();
    
    
    $result = self::calculatePrice(
                    $pricingRule,
                    $getSquare,
                    $numSigns,
                    "renewal",
                    $request['product_on_sign'],
                    $request['bank_and_others'],
                    "renewal"
                );

    OnpremiseInfo::where('id', $onpremiseInfo[$i]['id'])->update(['rate' => round($result['total']/$numSigns, 2), 'previous_rate' => round($result['previous']/$numSigns, 2)]);

    $newTotal [] = $result['total'];
    $newpreviousTotal [] = $result['previous'];
    $newcurrentTotal [] = $result['current'];
}

            $sumOfNewTotal = array_sum($newTotal);
            $sumOfpreviousTotal = array_sum($newpreviousTotal);
            $sumOfcurrentTotal = array_sum($newcurrentTotal);
            // var_dump($date, $totalPrice); die();
             $onpremiseAppHistory = new Apphistory();
             $onpremiseAppHistory->previous_ads_price = $sumOfpreviousTotal;
             $onpremiseAppHistory->current_ads_price = $sumOfcurrentTotal;
             $onpremiseAppHistory->ads_price = $sumOfNewTotal;
             $onpremiseAppHistory->balance = $getFindPrice->balance + $sumOfNewTotal;
             $onpremiseAppHistory->onpremise_id  = $annoulall[$p]['id'];
             $onpremiseAppHistory->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->appHistory()->save($onpremiseAppHistory);
             $permitOnpremise = new PermitStepOnpremise();
             $permitOnpremise->purpose = $getonpremise[0]['purpose_of_application'];
             $onpremiseObj->permitStepOnpremise()->save($permitOnpremise);
            //  $activityInfo = new AdminActivity();
            //  $fetchActivity = 'Approve an onpremise ads with adsId' . $annoulall[$p]['id'];
            //  $activityInfo->action = $fetchActivity;
            //  $savedActivity = $user->adminActivity()->save($activityInfo);
            // return response()->json(['Total' => (int)$seePrice], 200);
        
            if($onpremiseObj->onpremise_multiple_id == null){
        
                $OnpremiseInfo = OnpremiseInfo::where('onpremise_id', $onpremiseObj->id)->get();
                 
                 
                $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
                $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
                $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
                $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
                if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                    // The value of $mobileInput['lga'] is one of the allowed LGAs
                    $zone = "Lagos Central";
                }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                    $zone = "Lagos East";
                }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                    $zone = "Lagos West 1";
                }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                    $zone = "Lagos West 2";
                } else {
                    $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                    $selectedKey = array_rand($listArray);
                    $selectValue = $listArray[$selectedKey];
                    $zone = $selectValue;
                }
                
                 $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
                 if($HODe){
                     $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                     $HODfn = $HOD->first_name;
                     $HODln = $HOD->last_name;
                 }else{
                     $HODfn = "Adekunle";
                     $HODln = "Afolabi";
                 }
                 
                 // Part 1: Current date in "Ymd" format (e.g., 2232024)
                 $part1 = date('Ymd');
                
                 // Part 2: Random 3 uppercase letters (e.g., JJJ)
                 $part2 = strtoupper(Str::random(3));
                
                 // Part 3: Random alphanumeric value (e.g., 1P)
                 $part3 = strtoupper(Str::random(2));
                
                 // Part 4: Random number between 100000 and 999999 (e.g., 193974)
                 $part4 = mt_rand(100000, 999999);
            
                 // Combine all parts into the final string
                 $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
                 
                        
                //  $startdate = Carbon::parse($onpremiseObj->installation_date)->tz('Africa/Lagos');
                //  $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                
                 $startdate = Carbon::now()->startOfYear()->tz('Africa/Lagos');
                 $enddate = Carbon::now()->endOfYear();
                        
                 $countDetails = count($OnpremiseInfo) - 1;
                 $signTypes = [];
                 $quantitySigns = [];
        
                 for($i=0;$i <= $countDetails; $i++) {
                     $signTypes [] = $OnpremiseInfo[$i]['type_of_sign'];
                     $quantitySigns [] = (float)$OnpremiseInfo[$i]['length_in_meter'] * (float)$OnpremiseInfo[$i]['width_in_meter'];
                     $rate [] = $OnpremiseInfo[$i]['rate'];
                     $number [] = $OnpremiseInfo[$i]['number_of_sign'];
                 }
                 $combinedArray = [];
                 foreach ($signTypes as $index => $value) {
                     $combinedArray [] = [
                         'key' => $value,
                         'value' => round($quantitySigns[$index], 2),
                         'rate' => $rate[$index],
                         'number' => $number[$index],
                     ];
                     
                 }
                        
                    $userDetails = User::where('id', $onpremiseObj->user_id)->get();
                    $totalFee = $getFindPrice->balance + $sumOfNewTotal;
                    $amountInWord = UtilMethods::getAmountInWords($totalFee);
    
                    $getDate = Carbon::parse($onpremiseObj->updated_at);
                    $getYear = $getDate->year;
                    $data = [
                        'custId' => $userDetails[0]['id'],
                        'email' => $onpremiseObj['email'],
                        'userType' => $userDetails[0]['user_type'],
                        'company' => $userDetails[0]['business_name'],
                        'officeAddress' => $onpremiseObj->sign_address,
                        'billYear' => $getYear,
                        'lga' => $onpremiseObj['lga'],
                        'appId' => $onpremiseObj->payment_id,
                        'billStartDate' => $startdate->format('jS F, Y'),
                        'billEndDate' => $enddate->format('jS F, Y'),
                        'zone' => $onpremiseObj['street_category'],
                        'arrears' => $getFindPrice->balance,
                        'current_charge' => $sumOfNewTotal,
                        'isfresh' => false,
                        'totalFee' => $totalFee,
                        'amountInWord' => $amountInWord
                    ];
    
    
                    $pdf = Pdf::loadView('BillInvoiceFirstParty', compact('data', 'combinedArray'))->setPaper('A3');
                    $fileObj = $pdf->download('BillInvoiceFirstParty.pdf');
    
                    // $getUserObj = User::find($userDetails[0]['user']['id']);
                    
                    $emailcontent = EmailContent::getContent('onpremise_renewal_bill_content');
    
                    $body = $emailcontent;
                    $templateData = [
                        'body' => $body,
                        'name' => $userDetails[0]['business_name']
                    ];
                    $templateContent = view('hodeoitemplate', $templateData)->render();
                    UtilMethods::billgenonpremise($userDetails[0]['email'], $templateContent, $fileObj);
                    
                    $pdfContent = $pdf->output();
                    $filename = 'BillInvoice_' . now()->format('YmdHis') . '.pdf';
                    $relativePath = 'invoices/' . $filename;
                    $savePath = public_path($relativePath); // Full path to /public/invoices/
                     
                    if (!File::exists(public_path('invoices'))) {
                        File::makeDirectory(public_path('invoices'), 0755, true);
                    }
                    file_put_contents($savePath, $pdfContent);
                    $fileUrl = config('app.url') . '/public/' . $relativePath;
                    $adnewrec = new OnpremiseReceipts();
                    $adnewrec->link = $fileUrl;
                    $adnewrec->type = "Invoice";
                    //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                    $onpremiseObj->onpremisereceipts()->save($adnewrec);
            }else{
                
                $multipleadd = OnPremiseMultiple::find($onpremiseObj->onpremise_multiple_id);
                $multipleadd->countnew += 1;
                $multipleadd->save();
                 
                    if($multipleadd->total == $multipleadd->countnew){
                        
                        $multipleadd->countnew = 0;
                        $multipleadd->save();
                        
                     
                        $fetchmult = onpremise::where('onpremise_multiple_id', $onpremiseObj->onpremise_multiple_id)->pluck('id');
                        
                        $allpremises = onpremise::whereIn('id', $fetchmult)->get();
                        
                     
                        //  $kycD = kycdetail::where('user_id', $onpremiseObj->user_id)->first();
                        $OnpremiseInfo = OnpremiseInfo::whereIn('onpremise_id', $fetchmult)->get();
                 
                 
                        $lcenLGAs = ["Apapa", "Eti-osa", "Ikoyi-Obalende", "Lekki Phase 1", "Lagos Mainland", "Lagos Island", "Surulere", "Aguda/Itire-Ikate"];
                        $leastLGAs = ["Epe", "Ibeju-Lekki 1", "Ibeju-Lekki 2", "Ikorodu Central", "Ikorodu West", "Kosofe", "Magodo/Isheri", "Shomolu"];
                        $lwest1LGAs = ["Agege", "Ikeja", "Onigbongbo", "Computer Village", "Ifako-Ijaiye", "Mushin", "Oshodi/Isolo"];
                        $lwest2LGAs = ["Alimosho", "Ajeromi-Ifelodun", "Amuwo Odofin", "Badagry", "Ojo", "Mosan Okunola"];
                        if (in_array($onpremiseObj->lga, $lcenLGAs)) {
                            // The value of $mobileInput['lga'] is one of the allowed LGAs
                            $zone = "Lagos Central";
                        }elseif(in_array($onpremiseObj->lga, $leastLGAs)){
                            $zone = "Lagos East";
                        }elseif(in_array($onpremiseObj->lga, $lwest1LGAs)){
                            $zone = "Lagos West 1";
                        }elseif(in_array($onpremiseObj->lga, $lwest2LGAs)){
                            $zone = "Lagos West 2";
                        } else {
                            $listArray = ["Lagos Central", "Lagos East", "Lagos West 1", "Lagos West 2" ];
                            $selectedKey = array_rand($listArray);
                            $selectValue = $listArray[$selectedKey];
                            $zone = $selectValue;
                        }
                        
                         $HODe = UserAdmin::where('zone', $zone)->orWhere('zone2', $zone)->exists();
                         if($HODe){
                             $HOD = UserAdmin::where('admin_role_id', 5)
                            ->where(function($query) use ($zone) {
                                $query->where('zone', $zone)
                                      ->orWhere('zone2', $zone);
                            })
                            ->first();
                             $HODfn = $HOD->first_name;
                             $HODln = $HOD->last_name;
                         }else{
                             $HODfn = "Adekunle";
                             $HODln = "Afolabi";
                         }
                         
                         // Part 1: Current date in "Ymd" format (e.g., 2232024)
                         $part1 = date('Ymd');
                        
                         // Part 2: Random 3 uppercase letters (e.g., JJJ)
                         $part2 = strtoupper(Str::random(3));
                        
                         // Part 3: Random alphanumeric value (e.g., 1P)
                         $part3 = strtoupper(Str::random(2));
                        
                         // Part 4: Random number between 100000 and 999999 (e.g., 193974)
                         $part4 = mt_rand(100000, 999999);
                    
                         // Combine all parts into the final string
                         $barcoden = "{$part1}-{$part2}-{$part3}-{$part4}";
                         
                                
                        //  $startdate = Carbon::parse($onpremiseObj->installation_date)->tz('Africa/Lagos');
                        //  $enddate = Carbon::parse($onpremiseObj->created_at)->endOfYear();
                        
                         $startdate = Carbon::now()->startOfYear()->tz('Africa/Lagos');
                         $enddate = Carbon::now()->endOfYear();
                         
                         $combinedArray = [];
                         $combinedArray = array_map(function($onpremise, $premise) {
                         return [
                                 'key' => $onpremise['type_of_sign'],
                                 'value' => round((float)$onpremise['length_in_meter'] * (float)$onpremise['width_in_meter'], 2),
                                 'rate' => $onpremise['rate'],
                                 'number' => $onpremise['number_of_sign'],
                                 'address' => $premise['sign_address'] ?? null,
                                 'lga' => $premise['lga'] ?? null,
                                 'appid' => $premise['payment_id'] ?? null,
                             ];
                         }, $OnpremiseInfo->toArray(), $allpremises->toArray());
                         
    
                         $combinedArray = array_filter($combinedArray, function($item) {
                             return !empty($item['key']) && !empty($item['address']);
                         });
                                
                            $userDetails = User::where('id', $onpremiseObj->user_id)->get();
                            $totalFee = $getFindPrice->balance + $sumOfNewTotal;
                            $amountInWord = UtilMethods::getAmountInWords($totalFee);
            
                            $getDate = Carbon::parse($onpremiseObj->updated_at);
                            $getYear = $getDate->year;
                            $data = [
                                'custId' => $userDetails[0]['id'],
                                'email' => $onpremiseObj['email'],
                                'userType' => $userDetails[0]['user_type'],
                                'company' => $userDetails[0]['business_name'],
                                'officeAddress' => $onpremiseObj->sign_address,
                                'billYear' => $getYear,
                                'lga' => $onpremiseObj['lga'],
                                'appId' => $onpremiseObj->payment_id,
                                'billStartDate' => $startdate->format('jS F, Y'),
                                'billEndDate' => $enddate->format('jS F, Y'),
                                'zone' => $onpremiseObj['street_category'],
                                'arrears' => $getFindPrice->balance,
                                'current_charge' => $sumOfNewTotal,
                                'isfresh' => false,
                                'totalFee' => $totalFee,
                                'amountInWord' => $amountInWord
                            ];
            
            
                            $pdf = Pdf::loadView('BillInvoiceFirstPartyBulk', compact('data', 'combinedArray'))->setPaper('A3');
                            $fileObj = $pdf->download('BillInvoiceFirstPartyBulk.pdf');
            
                            // $getUserObj = User::find($userDetails[0]['user']['id']);
            
                            $emailcontent = EmailContent::getContent('onpremise_renewal_bill_content');
    
                            $body = $emailcontent;
                            $templateData = [
                                'body' => $body,
                                'name' => $userDetails[0]['business_name']
                            ];
                            $templateContent = view('hodeoitemplate', $templateData)->render();
                            UtilMethods::billgenonpremise($userDetails[0]['email'], $templateContent, $fileObj);
                            
                            $pdfContent = $pdf->output();
                            $filename = 'BillInvoiceBulk_' . now()->format('YmdHis') . '.pdf';
                            $relativePath = 'invoices/' . $filename;
                            $savePath = public_path($relativePath); // Full path to /public/invoices/
                             
                            if (!File::exists(public_path('invoices'))) {
                                File::makeDirectory(public_path('invoices'), 0755, true);
                            }
                            file_put_contents($savePath, $pdfContent);
                            $fileUrl = config('app.url') . '/public/' . $relativePath;
                            $adnewrec = new OnpremiseReceipts();
                            $adnewrec->link = $fileUrl;
                            $adnewrec->type = "Invoice";
                            //  $tosaveoutd = ThirdPartyOutdoor::find($getOutDoorObj[$i]['id']);
                            $onpremiseObj->onpremisereceipts()->save($adnewrec);
                    }
            }
                
                $onpremiseObj->permit_year = $year;
                $onpremiseObj->save();
            
        }
        }
    }

    // public function approveStreetLamp($streetLampId, Request $request) {
    //     $validate = Validator::make($request->all(),  [
    //         'comments' => 'nullable|string|max:255',
    //         'reports_from_branchmanger' => 'required|string|max:255',
    //         'report_file' => 'nullable|string',
    //         'accept_price' => 'required|boolean'
    //     ]);

    //     if($validate->fails()) {
    //         return response()->json(['errors' => $validate->errors()->all()], 422);
    //     }
    //     $user = Auth::user();

    //     $currentYear = Carbon::now()->year;
    //     $dayInYear = Carbon::createFromDate($currentYear, 1, 1)->
    //         diffInDays(Carbon::createFromDate($currentYear, 12, 31)) + 1;


    //     $streetLamp = StreetLampsAds::where('id', $streetLampId)->update(['status' => 'pending', 'hod_permit_status' => 'pending',
    //         'date_hod_approval' => Carbon::now()]);
    //     $getStreetLamp = StreetLampsAds::where('id', $streetLampId)->get();
    //     $date = Carbon::parse($getStreetLamp[0]['start_date']);
    //     $enddate = Carbon::parse($getStreetLamp[0]['due_date']);
    //     $endofYear = $date->copy()->endOfYear();
    //     $lastDayOfYear = $date->copy()->endOfYear();
        
    //     $dayRemaining = $date->copy()->diffInDays($enddate);
    //     $lastDayOfMonth = $date->copy()->endOfMonth();
        
    //     $noOfDayinYear = Carbon::now()->startOfYear()->diffInDays($lastDayOfYear) + 1;
        
    //     // Convert days to months by dividing by 30 (approximate days in a month)
    //     $monthsRemaining = intdiv($dayRemaining, 31);
        
    //     // Add one more month if there are extra days beyond a full month
    //     if ($dayRemaining % 31 > 0) {
    //         $monthsRemaining += 1;
    //     }

    //     $getFindPrice = AppHistoryStreetLamp::where('street_lamps_ads_id', $streetLampId)->get();
    //     $userId = User::where('id', $getStreetLamp[0]['user_id'])->get();
    //     //var_dump($userId[0]['id']); die();
    //     $streetLampObj  = StreetLampsAds::find($getStreetLamp[0]['id']);
    //     $getStreetLampInfo = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->get();
    //     $count = count($getStreetLampInfo) - 1;
    //     //var_dump($getStreetLamp[0]['duration']);die();

    //     for($i=0;$i<=$count; $i++) {
    //         $numberPole = $getStreetLampInfo[$i]['number_poles'];
    //         if ($getStreetLampInfo[$i]['street_category'] == 'Normal Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'FLEX') {
                    
    //                     if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 15000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 60000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (15000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 30000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 60000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         }else{
    //                         $permitPrice = 6000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 24000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Restrictive Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'FLEX') {
                    
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 30000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 70000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (30000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 35000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 70000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         }else{
    //                         $permitPrice = 8000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 27000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'High Street N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'FLEX') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 30000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 120000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (30000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 60000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 120000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 10000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 30000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Special N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'FLEX') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 60000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 120000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (60000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 60000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 120000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 13600 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 35000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         }
    //         if ($getStreetLampInfo[$i]['street_category'] == 'Normal Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'BACKLIT') {
                    
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 30000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 120000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (30000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 60000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 120000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 12000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 48000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Restrictive Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'BACKLIT') {
                    
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 60000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 140000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (60000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 70000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 140000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 16000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 54000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'High Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'BACKLIT') {
                    
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 60000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 240000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (60000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 120000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 240000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 20000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 60000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Special N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'BACKLIT ') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 120000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 240000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (120000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 120000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 240000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 27000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 70000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         }
    //         if ($getStreetLampInfo[$i]['street_category'] == 'Normal Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'LED') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 45000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 180000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (45000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 90000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 180000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 18000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 72000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Restrictive Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'LED') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 90000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 210000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (90000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 105000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 210000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 24000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 81000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'High Zone N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'LED') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 90000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 360000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (90000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 180000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 360000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 30000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 90000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         } elseif ($getStreetLampInfo[$i]['street_category'] == 'Special N') {
    //             if ($getStreetLampInfo[$i]['type_of_sign'] == 'LED') {
    //                 if (Carbon::today() < $endofYear) {
    //                         if($dayRemaining >= 365){
    //                         $permitPrice = 180000 * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 360000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }elseif($dayRemaining >= 183 && $dayRemaining < 365){
    //                         $permitPrice = (($dayRemaining + 1) * (180000 / $noOfDayinYear)) * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         if($dayRemaining > 182.4 && $dayRemaining < 184){
    //                             $adminstrativePrice = 180000 * $numberPole;
    //                         }else{
    //                             $adminstrativePrice = 360000 * $numberPole;
    //                         }
    //                         $dueDate = $lastDayOfYear; 
    //                         // var_dump($noOfDayinYear, 15000 / $noOfDayinYear);die();
    //                         }else{
    //                         $permitPrice = 48000 * $monthsRemaining * $numberPole;
    //                         $legal = (1 / 100) * $permitPrice;
    //                         $adminstrativePrice = 105000 * $numberPole;
    //                         $dueDate = $lastDayOfYear;
    //                         }
    //                     }
                        
    //                     StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->update(['permit_price' => $permitPrice,
    //                         'administrative_price' => $adminstrativePrice, 'legal_price' => $legal]);
    //             }
    //         }
    //     }
    //     if($request['accept_price'] == true) {
    //         $getPermitFees = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('permit_price');
    //         $getAdministrativeFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('administrative_price');
    //         $getLegalFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('legal_price');
    //         $totalFee = $getAdministrativeFee + $getPermitFees + $getLegalFee;
    //         //var_dump($getFindPrice[0]['user_id']); die();
    //         $getApplicant = User::where('id', $userId[0]['id'])->get();
    //         $getApplicantEmail = $getApplicant[0]['email'];
    //         $subject = 'Update on Street Lamps  Ads Application';
    //         $body = 'The Street Lamps your applied for was approved.' .  " " . "". 'Adminstrative Fee:' . $getAdministrativeFee . 'Permit Fee:' . $getPermitFees.""
    //           . 'Total Price:' . $totalFee .  " ". " " . $request['comments'] . " ". " "
    //             .$request['reports_from_branchmanger'];
    //         //$this->composeEmail($subject, $body, $getApplicantEmail);
    //         $templateData = [
    //             'body' => $body,
    //             'name' => $getApplicant[0]['business_name'],
    //         ];
    //         $templateContent = view('emailtemplate', $templateData)->render();
    //         $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
    //         $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
    //         if($getCreateby ) {
    //             $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
    //             $getCreatebyEmail = $getAdmin[0]['email'];
    //             $this->composeEmailV2($subject, $getCreatebyEmail,  $templateContent);
    //         }

    //         $streetLampAppHistory = new AppHistoryStreetLamp();
    //         $reportFile = $request['report_file'];
    //         $streetLampAppHistory->report_file = $this->convertBase64toPdf($reportFile);
    //         $streetLampAppHistory->purpose = $getStreetLamp[0]['name_of_display'];
    //         $streetLampAppHistory->who_performed_action = $user->id;
    //         $streetLampAppHistory->comments = $request['comments'];
    //         $streetLampAppHistory->reports_from_branchmanager = $request['reports_from_branchmanger'];
    //         $streetLampAppHistory->ads_price = $getFindPrice[0]['ads_price'];
    //         $streetLampObj->appHistoryStreetLamp()->save($streetLampAppHistory);

    //         $activityInfo = new AdminActivity();
    //         $fetchActivity = 'Approve an streetlamp ads with adsId' . $streetLampId;
    //         $activityInfo->action = $fetchActivity;
    //         $savedActivity = $user->adminActivity()->save($activityInfo);
    //         $streetLampApp = AppHistoryStreetLamp::where('street_lamps_ads_id', $getStreetLamp[0]['id'])->get();
    //     } else {
    //         $getPermitFees = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('permit_price');
    //         $getAdministrativeFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('administrative_price');
    //         $getLegalFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('legal_price');
    //         $totalFee = $getAdministrativeFee + $getPermitFees + $getLegalFee;
    //     }
    //     return response()->json(['Total' => $totalFee, 'PermitFee' => $getPermitFees, 'AdministrativeFee' =>$getAdministrativeFee, 'LegalPrice' => $getLegalFee], 200);

    // }
    
    public function approveStreetLamp($streetLampId, Request $request) {
        // Validate the request
        $validate = Validator::make($request->all(),  [
            'comments' => 'nullable|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string',
            'accept_price' => 'required|boolean'
        ]);
    
        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        
        // Get authenticated user
        $user = Auth::user();
        
        // Update street lamp status
        $streetLamp = StreetLampsAds::where('id', $streetLampId)->update([
            'status' => 'pending', 
            'hod_permit_status' => 'pending',
            'date_hod_approval' => Carbon::now()
        ]);
        
        // Get street lamp details
        $getStreetLamp = StreetLampsAds::where('id', $streetLampId)->first();
        if (!$getStreetLamp) {
            return response()->json(['error' => 'Street lamp not found'], 404);
        }
        
        // Calculate date-related values
        $date = Carbon::parse($getStreetLamp['start_date']);
        $enddate = Carbon::parse($getStreetLamp['due_date']);
        $endofYear = $date->copy()->endOfYear();
        $lastDayOfYear = $date->copy()->endOfYear();
        
        $dayRemaining = $date->copy()->diffInDays($enddate);
        $noOfDayinYear = Carbon::now()->startOfYear()->diffInDays($lastDayOfYear) + 1;
        
        // Convert days to months
        $monthsRemaining = intdiv($dayRemaining, 31);
        if ($dayRemaining % 31 > 0) {
            $monthsRemaining += 1;
        }
    
        // Get all street lamp info records
        $getStreetLampInfo = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->get();
        
        // Calculate prices for each info record
        foreach($getStreetLampInfo as $info) {
            $pricing = StreetLampPricing::where('street_category', $info['street_category'])
                ->where('type_of_sign', $info['type_of_sign'])
                ->first();
                
            if (!$pricing) continue;
                
            if (Carbon::today() < $endofYear) {
                if($dayRemaining >= 365) {
                    $permitPrice = $pricing->annual_permit_price * $info['number_poles'];
                    $legal = ($pricing->legal_percentage / 100) * $permitPrice;
                    $adminstrativePrice = $pricing->annual_admin_price * $info['number_poles'];
                    $dueDate = $lastDayOfYear;
                } elseif($dayRemaining >= 183 && $dayRemaining < 365) {
                    $permitPrice = (($dayRemaining + 1) * ($pricing->annual_permit_price / $noOfDayinYear)) * $info['number_poles'];
                    $legal = ($pricing->legal_percentage / 100) * $permitPrice;
                    $adminstrativePrice = $dayRemaining > 182.4 && $dayRemaining < 184 
                        ? $pricing->half_year_admin_price * $info['number_poles']
                        : $pricing->annual_admin_price * $info['number_poles'];
                    $dueDate = $lastDayOfYear;
                } else {
                    $permitPrice = $pricing->monthly_permit_price * $monthsRemaining * $info['number_poles'];
                    $legal = ($pricing->legal_percentage / 100) * $permitPrice;
                    $adminstrativePrice = $pricing->monthly_admin_price * $info['number_poles'];
                    $dueDate = $lastDayOfYear;
                }
                
                // Update the street lamp info with calculated prices
                StreetLampInfo::where('id', $info['id'])->update([
                    'permit_price' => $permitPrice,
                    'administrative_price' => $adminstrativePrice, 
                    'legal_price' => $legal,
                    'due_date' => $dueDate
                ]);
            }
        }
        
        // Handle price acceptance
        if($request['accept_price'] == true) {
            // Calculate total fees
            $getPermitFees = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('permit_price');
            $getAdministrativeFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('administrative_price');
            $getLegalFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('legal_price');
            $totalFee = $getAdministrativeFee + $getPermitFees + $getLegalFee;
            
            // Get applicant details
            $userId = $getStreetLamp['user_id'];
            $getApplicant = User::find($userId);
            if (!$getApplicant) {
                return response()->json(['error' => 'Applicant not found'], 404);
            }
            
            // Prepare and send email
            $emailsubject = EmailContent::getContent('streetlamp_decline_approve_subject');
            $emailcontent = EmailContent::getContent('streetlamp_approve_content');
            $subject = $emailsubject;
            $body = $emailcontent . " " . "". 
                    'Adminstrative Fee:' . $getAdministrativeFee . 
                    'Permit Fee:' . $getPermitFees . " " .
                    'Total Price:' . $totalFee . " " . " " . 
                    $request['comments'] . " " . " " .
                    $request['reports_from_branchmanger'];
            
            $templateData = [
                'body' => $body,
                'name' => $getApplicant['business_name'],
            ];
            
            $templateContent = view('emailtemplate', $templateData)->render();
            $this->composeEmailV2($subject, $getApplicant['email'], $templateContent);
            
            // Notify admin if created by one
            if ($getApplicant['created_by']) {
                $getAdmin = UserAdmin::find($getApplicant['created_by']);
                if ($getAdmin) {
                    $this->composeEmailV2($subject, $getAdmin['email'], $templateContent);
                }
            }
    
            // Create application history
            $streetLampObj = StreetLampsAds::find($streetLampId);
            $streetLampAppHistory = new AppHistoryStreetLamp();
            
            if ($request['report_file']) {
                $reportFile = $request['report_file'];
                $streetLampAppHistory->report_file = $this->convertBase64toPdf($reportFile);
            }
            
            $streetLampAppHistory->purpose = $getStreetLamp['name_of_display'];
            $streetLampAppHistory->who_performed_action = $user->id;
            $streetLampAppHistory->comments = $request['comments'];
            $streetLampAppHistory->reports_from_branchmanager = $request['reports_from_branchmanger'];
            $streetLampAppHistory->ads_price = $totalFee;
            
            $streetLampObj->appHistoryStreetLamp()->save($streetLampAppHistory);
    
            // Log admin activity
            $activityInfo = new AdminActivity();
            $activityInfo->action = 'Approve an streetlamp ads with adsId ' . $streetLampId;
            $user->adminActivity()->save($activityInfo);
        } else {
            // Calculate fees for response even if not accepted
            $getPermitFees = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('permit_price');
            $getAdministrativeFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('administrative_price');
            $getLegalFee = StreetLampInfo::where('street_lamps_ads_id', $streetLampId)->sum('legal_price');
            $totalFee = $getAdministrativeFee + $getPermitFees + $getLegalFee;
        }
        
        // Return the calculated fees
        return response()->json([
            'Total' => $totalFee ?? 0, 
            'PermitFee' => $getPermitFees ?? 0, 
            'AdministrativeFee' => $getAdministrativeFee ?? 0, 
            'LegalPrice' => $getLegalFee ?? 0
        ], 200);
    }
    
    public function getStreetLampPricing (){
        
        $getPrices = StreetLampPricing::all();
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function getStreetLampPricingDistinct (){
        
        $getPrices = StreetLampPricing::distinct()->pluck('type_of_sign');
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function deleteStreetLampPricing ($id){
        
        $getPrices = StreetLampPricing::find($id)->delete();
        return response()->json(['success' => true, 'data' => 'Pricing record deleted successfully'], 200);
    }
    
    public function updateStreetLampPricing(Request $request, $id) {
        
        $validator = Validator::make($request->all(), [
            'annual_permit_price' => ['required', 'numeric', 'min:0'],
            'half_year_permit_price' => ['required', 'numeric', 'min:0'],
            'monthly_permit_price' => ['required', 'numeric', 'min:0'],
            'annual_admin_price' => ['required', 'numeric', 'min:0'],
            'half_year_admin_price' => ['required', 'numeric', 'min:0'],
            'monthly_admin_price' => ['required', 'numeric', 'min:0'],
            'legal_percentage' => ['required', 'numeric', 'min:0'],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        // Find the record by ID
        $pricing = StreetLampPricing::findOrFail($id);
    
        $pricing->update($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record updated successfully'], 200);
    }
    
    public function createStreetLampPricing(Request $request) {
        
        $validator = Validator::make($request->all(), [
            'street_category' => ['required', 'string', 'max:255'],
            'type_of_sign' => ['required', 'string', 'max:255'],
            'annual_permit_price' => ['required', 'numeric', 'min:0'],
            'half_year_permit_price' => ['required', 'numeric', 'min:0'],
            'monthly_permit_price' => ['required', 'numeric', 'min:0'],
            'annual_admin_price' => ['required', 'numeric', 'min:0'],
            'half_year_admin_price' => ['required', 'numeric', 'min:0'],
            'monthly_admin_price' => ['required', 'numeric', 'min:0'],
            'legal_percentage' => ['required', 'numeric', 'min:0'],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        $pricing = StreetLampPricing::create($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record updated successfully'], 200);
    }
    
    public function getMobileAdsPricing (){
        
        $getPrices = MobileAdsPricing::all();
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function getMobileAdsPricingDistinct (){
        
        $getPrices = MobileAdsPricing::distinct()->pluck('vehicle_type');
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function deleteMobileAdsPricing ($id){
        
        $getPrices = MobileAdsPricing::find($id)->delete();
        return response()->json(['success' => true, 'data' => 'Pricing record deleted successfully'], 200);
    }
    
    public function updateMobileAdsPricing(Request $request, $id) {
        
        $validator = Validator::make($request->all(), [
            'vehicle_type' => ['required', 'string', 'max:255'],
            'branding_type' => ['required', 'string', 'max:255'],
            'price' => ['required', 'numeric', 'min:0'],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        // Find the record by ID
        $pricing = MobileAdsPricing::findOrFail($id);
    
        $pricing->update($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record updated successfully'], 200);
    }
    
    public function createMobileAdsPricing(Request $request) {
        
        $validator = Validator::make($request->all(), [
            'vehicle_type' => ['required', 'string', 'max:255'],
            'branding_type' => ['required', 'string', 'max:255'],
            'price' => ['required', 'numeric', 'min:0'],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        $pricing = MobileAdsPricing::create($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record created successfully'], 200);
    }
    
    public function getMobileAdsApplicationPricing (){
        
        $getPrices = MobileAdsApplicationPricing::all();
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function updateMobileAdsApplicationPricing(Request $request, $id) {
        
        $validator = Validator::make($request->all(), [
            'app_price' => ['required', 'numeric', 'min:0'],
            'min_number' => ['nullable', 'numeric', 'min:0'],
            'max_number' => ['nullable', 'numeric', 'min:0'],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        // Find the record by ID
        $pricing = MobileAdsApplicationPricing::findOrFail($id);
    
        $pricing->update($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record updated successfully'], 200);
    }
    
    public function getThirdPartyMobileAdsPricing (){
        
        $getPrices = ThirdPartyMobileAdsPricing::all();
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function getThirdPartyMobileAdsPricingDistinct (){
        
        $getPrices = ThirdPartyMobileAdsPricing::distinct()->pluck('vehicle_type');
        return response()->json(['success' => true, 'data' => $getPrices], 200);
    }
    
    public function deleteThirdPartyMobileAdsPricing ($id){
        
        $getPrices = ThirdPartyMobileAdsPricing::find($id)->delete();
        return response()->json(['success' => true, 'data' => 'Pricing record deleted successfully'], 200);
    }
    
    public function updateThirdPartyMobileAdsPricing(Request $request, $id) {
        
        $validator = Validator::make($request->all(), [
            'vehicle_type' => 'sometimes|required|string|max:255',
            'annual_price' => 'sometimes|required|numeric|min:0',
            'monthly_price' => 'nullable|numeric|min:0',
            'quarterly_price' => 'nullable|numeric|min:0',
            'biannual_price' => 'nullable|numeric|min:0',
            'daily_calculation_basis' => 'sometimes|boolean'
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        // Find the record by ID
        $pricing = ThirdPartyMobileAdsPricing::findOrFail($id);
    
        $pricing->update($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record updated successfully'], 200);
    }
    
    public function createThirdPartyMobileAdsPricing(Request $request) {
        
        $validator = Validator::make($request->all(), [
            'vehicle_type' => 'sometimes|required|string|max:255',
            'annual_price' => 'sometimes|required|numeric|min:0',
            'monthly_price' => 'nullable|numeric|min:0',
            'quarterly_price' => 'nullable|numeric|min:0',
            'biannual_price' => 'nullable|numeric|min:0',
            'daily_calculation_basis' => 'sometimes|boolean'
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $validated = $validator->validated();
    
        $pricing = ThirdPartyMobileAdsPricing::create($validated);
    
        return response()->json(['success' => true, 'data' => 'Pricing record created successfully'], 200);
    }

    public function approveExpressionInterestStreetLamp($streetLampId, Request $request) {
        $validate = Validator::make($request->all(),  [
            'comments' => 'required|string|max:255',
            'reports_from_branchmanger' => 'required|string|max:255',
            'report_file' => 'nullable|string',
            'streetInfo' => 'present|array',
            'streetInfo.streetdetails.*.id' => 'required|numeric',
            'streetInfo.streetdetails.*.number_poles' => 'required|integer',
            'streetinfo.streetdetails.*.street_category' => 'required|string'
        ]);

        if($validate->fails()) {
            return response()->json(['errors' => $validate->errors()->all()], 422);
        }
        $user = Auth::user();

        $approveInput = $request->all();

        $streetLamp = StreetLampsAds::where('id', $streetLampId)->update(['eoi_status' => 'approved', 'date_hod_approval' => Carbon::now()]);
        $getStreetLamp = StreetLampsAds::where('id', $streetLampId)->get();
        $getFindPrice = AppHistoryStreetLamp::where('street_lamps_ads_id', $streetLampId)->get();
        $streetLampObj  = StreetLampsAds::find($getStreetLamp[0]['id']);

        $getApplicant = User::where('id', $getStreetLamp[0]['user_id'])->get();
        $getApplicantEmail = $getApplicant[0]['email'];
        $emailsubject = EmailContent::getContent('streetlamp_decline_approve_subject');
        $emailcontent = EmailContent::getContent('streetlamp_eoi_approve_content');
        $subject = $emailsubject;
        $body = $emailcontent . " " . $request['comments']. " "
            . $request['reports_from_branchmanger'];
        $templateData = [
            'body' => $body,
            'name' => $getApplicant[0]['business_name'],
        ];
        $templateContent = view('emailtemplate', $templateData)->render();
        $this->composeEmailV2($subject, $getApplicantEmail,  $templateContent);
        $getCreateby = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->exists();
        if($getCreateby ) {
            $getAdmin = UserAdmin::where('id', (string)$getApplicant[0]['created_by'])->get();
            $getCreatebyEmail = $getAdmin[0]['email'];
            $this->composeEmailV2($subject, $getCreatebyEmail,  $templateContent);
        }
        //$this->composeEmail($subject, $body, $getApplicantEmail);

        $count = count($approveInput['streetInfo']['streetdetails']) - 1;
        for($i=0;$i<=$count; $i++) {
                $updateStreet = StreetLampInfo::where('id', $approveInput['streetInfo']['streetdetails'][$i]['id'])->update(['street_category' =>
                $approveInput['streetInfo']['streetdetails'][$i]['street_category'], 'number_poles' => $approveInput['streetInfo']['streetdetails'][$i]['number_poles'] ]);
        }

        $streetLampAppHistory = new AppHistoryStreetLamp();
        $reportFile = $request['report_file'];
        $streetLampAppHistory->report_file = $this->convertBase64toPdf($reportFile);
        $streetLampAppHistory->purpose = $getStreetLamp[0]['name_of_display'];
        $streetLampAppHistory->who_performed_action = $user->id;
        $streetLampAppHistory->comments = $request['comments'];
        $streetLampAppHistory->reports_from_branchmanager = $request['reports_from_branchmanger'];
        $streetLampAppHistory->ads_price = $getFindPrice[0]['ads_price'];
        $streetLampObj->appHistoryStreetLamp()->save($streetLampAppHistory);

        $activityInfo = new AdminActivity();
        $fetchActivity = 'Approve an streetlamp ads with adsId'. $streetLampId;
        $activityInfo->action = $fetchActivity;
        $savedActivity = $user->adminActivity()->save($activityInfo);
        $streetLampApp = StreetLampInfo::where('street_lamps_ads_id', $getStreetLamp[0]['id'])->get();
        return response()->json(['data' => $streetLampApp], 200);

    }

    protected function convertBase64toPdf($base64Doc) {

        $pdfFile = explode('base64,',$base64Doc);
        $pdfFile = end($pdfFile);
        $pdfFile = str_replace(' ', '+', $pdfFile);
        //$filename =
        $uniqueid = uniqid();
        $file =  "/reportfile/" . $uniqueid . '.pdf';

        Storage::disk('public')->put($file,base64_decode($pdfFile));

        $sourcePath = storage_path('app/public' . $file); // Get the source path in the storage directory
        $destinationPath = public_path('reportfile/' . $uniqueid . '.pdf'); // Define the destination path in the public directory

        // Move the file from the storage directory to the public directory
        File::move($sourcePath, $destinationPath);

        $url = env('APP_URL').'/public'.$file;
        return $url;
    }

    protected function domainExists($email)
    {
        // Extract the domain from the email address
        $parts = explode('@', $email);
        $domain = array_pop($parts);

        // Perform a DNS lookup for the domain
        $mxRecords = [];
        if (checkdnsrr($domain, 'MX')) {
            // MX records found, domain exists
            return true;
        } else {
            // No MX records found, domain does not exist
            return false;
        }
    }

    public function composeEmail($subject, $body,  $userEmail)
    {
        require base_path('vendor/autoload.php');

        $mail = new PHPMailer(true);
        $mail->SMTPDebug = 0;
        $mail->isSMTP();
        $mail->Host = 'smtp-relay.brevo.com'; //ssl://smtp.gmail.com
        $mail->SMTPAuth = true;
        $mail->Username = 'macdonnad@gmail.com';
        $mail->Password = 'xsmtpsib-93267ec9551960673300f309d7edd9a807648eb7aac5b10b6f80f2e106c7f010-dMSfPhNXDW84pqvY';
        // $mail->SMTPSecure = 'ssl';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;
        $mail->setFrom('noreply@lasaa.lg.gov.ng', 'Lasaa');
        $mail->addAddress($userEmail);
        $mail->addReplyTo('noreply@lasaa.lg.gov.ng', 'Lasaa');

        $mail->isHTML(true);

        $mail->Subject = $subject;
        $mail->Body = "" .$body;
        $mail->send();

    }

    public function composeEmailV2($subject, $userEmail, $emailContent) {

        if($this->domainExists($userEmail)) {
            Log::info("Domain Exists");
        } else {
            Log::error("Domain does not exist");
        }

        require base_path('vendor/autoload.php');

        try {
            $mail = new PHPMailer(true);
            $mail->SMTPDebug = 0;
            $mail->isSMTP();
            $mail->Host = 'smtp-relay.brevo.com'; //ssl://smtp.gmail.com
            $mail->SMTPAuth = true;
            $mail->Username = 'macdonnad@gmail.com';
            $mail->Password = 'xsmtpsib-93267ec9551960673300f309d7edd9a807648eb7aac5b10b6f80f2e106c7f010-dMSfPhNXDW84pqvY';
            // $mail->SMTPSecure = 'ssl';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;
            $mail->setFrom('noreply@lasaa.lg.gov.ng', 'Lasaa');
            $mail->addAddress($userEmail);
            $mail->addReplyTo('noreply@lasaa.lg.gov.ng', 'Lasaa');

            $mail->isHTML(true);
            Log::info($userEmail);
            $mail->Subject = $subject;
            $mail->Body = $emailContent;
            $mail->send();
            Log::info("message sent");
        } catch (Exception $exception) {
//            error_log('Email delivery failed: ' . $mail->ErrorInfo);
            $message = $exception->getMessage();
            Log::error($message);
            return true;
        }
    }
    
    public function getOnpremiseDownloadables($id) {
        $user = Auth::user();
        $usercheck = onpremise::where('id', $id)->first();
        if($usercheck->onpremise_multiple_id != null){
            $getmultiple =  onpremise::where('id', $id)->first();
              $multiple = Onpremise::where('onpremise_multiple_id', $getmultiple->onpremise_multiple_id)->orderBy('id', 'desc')->pluck('id')->toArray();
            //   var_dump($multiple->id);die();
            $check = OnpremiseReceipts::whereIn('onpremise_id', $multiple)->exists();
            if($check){
                $getreceipts = OnpremiseReceipts::whereIn('onpremise_id', $multiple)->get()->toArray();
                return response()->json(['data' => $getreceipts], 200);
            }else{
                return response()->json(['data' => 'No Downloadables Yet!'], 422);
            }
              
        }else{
           $check = OnpremiseReceipts::where('onpremise_id', $id)->exists();
            if($check){
                $getreceipts = OnpremiseReceipts::where('onpremise_id', $id)->get()->toArray();
                
                return response()->json(['data' => $getreceipts], 200);
            
                
            }else{
                return response()->json(['data' => 'No Downloadables Yet!'], 422);
            } 
        }
        
        
    }

}