<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppHistoryFirstPartyTemporaryAds extends Model
{
    use HasFactory;

    protected $table = 'app_history_first_party_temporary_ads';

    protected $fillable = [
       'who_performed_action',
        'comments',
        'purpose'
    ];
    
    protected $casts = [
        'ads_price' => 'double'
    ];

    public function firstPartyTemporaryAds() {
        return $this->belongsTo(FirstPartyTemporaryAds::class);
    }
}
