<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnPremiseChange extends Model
{
    use HasFactory;

    protected $table = 'onpremise_change';

    protected $fillable = [
        'onpremise_info_id',
        'type_of_sign',
        'number_of_sign',
        'length_in_meter',
        'width_in_meter',
        'ratetoremove',
        'ratetoadd',
        'photo_montage',
        'status',
        'rm_status',
        'cp_status',
        'hod_status',
        'billing_status',
        'audit_status',
        'product_on_sign',
        'bm_comment',
        'rm_comment',
        'hod_comment',
        'billing_comment',
        'cp_comment',
        'audit_comment'
    ];
    
    protected $casts = [
        'ratetoremove' => 'float',
        'ratetoadd' => 'float',
        'product_on_sign' => 'boolean',
    ];

    public function onpremise() {
        return $this->belongsTo(onpremise::class);
    }
}
