<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnpremiseInfo extends Model
{
    use HasFactory;

    protected $table = 'onpremise_info';

    protected $fillable = [
        'onpremise_id',
        'type_of_sign',
        'number_of_sign',
        'length_in_meter',
        'width_in_meter',
        'photo_montage',
        'sign_to_remove',
        'rate',
        'previous_rate',
        'product_on_sign',
        'photo_montage_remove'
    ];
    
    protected $casts = [
        'number_of_sign' => 'integer',
        'sign_to_remove' => 'integer',
        'sign_to_add' => 'integer',
        'rate' => 'float',
        'product_on_sign' => 'boolean',
        'previous_rate' => 'float'
    ];

    public function onpremise() {
        return $this->belongsTo(onpremise::class);
    }
}
