<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SmallFormatDetails extends Model
{
    use HasFactory;

    protected $table = 'small_format_details';
    protected $fillable = [
        'type_signs',
        'dimension_sign',
        'setback_distance',
        'length',
        'breadth',
        'sign_format',
        'sign_site',
        'illumination',
        'interactivity',
        'electricity_source',
        'first_permit_pay',
        'permit_year',
        'rm_comment',
        'hod_comment',
        'md_comment'
    ];
    
    protected $casts = [
       'first_permit_pay' => 'boolean',
       'ads_price' => 'integer',
       'annual_price' => 'integer',
    ];

    public function smallFormatAds() {
        return $this->belongsTo(SmallFormatAds::class);
    }

    public function appHistorySmallFormatDetails() {
        return $this->hasMany(AppHistorySmallFormatDetails::class);
    }
}
