<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ThirdPartyMobile extends Model
{
    use HasFactory;

    protected $table = 'thirdparty_mobile_ads';

    protected $fillable = [
        'brand_name',
        'paymentId',
        'Application_pay_status',
        'vehicle_registration',
        'status',
        'permit_letter',
        'licenseId',
        'qrcode',

        'start_date',
        'payment_cycle',
        'image_montage',
        'type_of_ads',
        'duration'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function thirdPartyMobileAppHistory() {
        return $this->hasOne(ThirdPartyMobileAppHistory::class);
    }

    public function thirdPartyMobilePermitStep() {
        return $this->hasMany(ThirdPartyMobilePermitStep::class);
    }

    public function vehicleThirdPartyMobile() {
        return $this->hasMany(VehicleThirdPartyMobile::class);
    }

    public function thirdPartyMobileVehicleLincense() {
        return $this->hasMany(ThirdPartyMobileVehicleLicense::class);
    }

    public function paymentThirdPartyMobile() {
        return $this->hasMany(PaymentThirdPartyMobile::class);
    }
}
