<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id',
        'first_name',
        'last_name',
        'email',
        'password',
        'phone_number',
        'business_name',
        'user_type',
        'is_institution'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'kyc_status' => 'boolean',
        'account_active' => 'boolean',
        'verified_account' => 'boolean',
        'email_verified_at' => 'datetime',
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_institution' => 'boolean',
    ];

    public $incrementing = false;

    public function kycdetail() {
        return $this->hasOne(kycdetail::class);
    }

    public function payment() {
        return $this->hasMany(paymentStreetLamp::class);
    }

    public function mobilead() {
        return $this->hasMany(mobilead::class);
    }

    public function  onpremise() {
        return $this->hasMany(onpremise::class);
    }

    public function streetLamps() {
        return $this->hasMany(StreetLampsAds::class);
    }

    public function expressionOfStreetLamps() {
        return $this->hasMany(ExpressionOfStreetLamps::class);
    }

    public function paymentOnpremise() {
        return $this->hasMany(PaymentOnPremise::class);
    }

    public function thirdPartyMobile() {
        return $this->hasMany(ThirdPartyMobile::class);
    }

    public function  paymentThirdPartyMobile() {
        return $this->hasMany(PaymentThirdPartyMobile::class);
    }

    public function mobilePayment() {
        return $this->hasMany(MobilePayment::class);
    }

    public function userWallet() {
        return $this->hasOne(UserWallet::class);
    }

    public function kycThirdParty() {
        return $this->hasOne(KycThirdParty::class);
    }

    public function thirdPartyOutdoor() {
        return $this->hasMany(ThirdPartyOutdoor::class);
    }

    public function paymentThirdPartyOutdoorSignage() {
        return $this->hasMany(PaymentThirdPartyOutdoorSignage::class);
    }

    public function firstPartyTemporaryAds() {
        return $this->hasMany(FirstPartyTemporaryAds::class);
    }

    public function paymentFirstPartyTemporaryAds() {
        return $this->hasMany(PaymentFirstPartyTemporaryAds::class);
    }

    public function smallFormatAds() {
         return $this->hasMany(SmallFormatAds::class);
    }

    public function paymentSmallFormatAds() {
        return $this->hasMany(PaymentSmallFormatAds::class);
    }
}
