<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWallet extends Model
{
    use HasFactory;

    protected $table = 'user_wallet';

    protected $fillable = [
       'balance',
       'small_format_wallet',
       'temporary_wallet',
       'outdoor_wallet',
       'onpremise_wallet'
    ];

    protected $casts = [
        'balance' => 'double',
        'application_balance' => 'double',
        'mobile_balance' => 'double',
        'pav_balance' => 'double',
        'streetlamp_processing_balance' => 'double',
        'streetlamp_administrative_balance' => 'double',
        'small_format_wallet' => 'double',
        'temporary_wallet' => 'double',
        'outdoor_wallet' => 'double',
        'onpremise_wallet' => 'double',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function walletTransaction() {
        return $this->hasMany(WalletTransaction::class);
    }
}
