<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class mobilead extends Model
{
    use HasFactory;


    protected $table = 'mobile_ads';

    protected $fillable = [
        'brand_name',
        'paymentId',
        'Application_pay_status',
        'vehicle_registration',
        'vehicle_type',
        'status',
        'permit_letter',
        'licenseId',
        'qrcode',
        'lga',
        'payment_cycle',
        'image_montage',
        'type_of_ads',
        'duration',
        'assigned_officer',
        'zone'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function appHistoryMobile() {
        return $this->hasOne(AppHistoryMobile::class);
    }

    public function payment() {
        return $this->hasOne(paymentStreetLamp::class);
    }

    public function permitStepMobile() {
        return $this->hasMany(PermitStepMobile::class);
    }

    public function vehicleMobile() {
        return $this->hasMany(VehicleMobileAds::class);
    }

    public function mobileAdsVehicleLicense() {
        return $this->hasMany(MobileAdsVehicleLicense::class);
    }

    public function mobilePayment() {
        return $this->hasMany(MobilePayment::class);
    }
}
