<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class onpremise extends Model
{
    use HasFactory;

    protected $table = 'on_premise';

    protected $fillable = [
        'Application_pay_status',
        'status',
        'rm_status',
        'hod_status',
        'billing_status',
        'permit_letter',
        'licenseId',
        'qrcode',
        'payment_cycle',
        'initial_amount_due',
        'purpose_of_application',
        'type_of_sign',
        'sign_address',
        'number_of_sign',
        'dimension_in_meter',
        'name_of_owner',
        'business_name',
        'phone_number',
        'email',
        'photo_montage',
        'property_type',
        'lga',
        'zone',
        'bank_and_others',
        'bm_comment',
        'rm_comment',
        'hod_comment',
        'billing_comment',
        'account_comment',
        'audit_comment',
        'onpremise_multiple_id'
    ];
    
    protected $casts = [
        'bank_and_others' => 'boolean'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function payment() {
        return $this->hasOne(paymentStreetLamp::class);
    }

    public function appHistory() {
        return $this->hasOne(Apphistory::class);
    }

    public function permitStepOnpremise() {
        return $this->hasOne(PermitStepOnpremise::class);
    }

    public function paymentOnpremise() {
        return $this->hasOne(PaymentOnPremise::class);
    }

    public function onpremiseInfo() {
        return $this->hasMany(OnpremiseInfo::class);
    }
    
    public function OnPremiseRemoval() {
        return $this->hasMany(OnPremiseRemoval::class);
    }
    
    public function OnPremiseAdditional() {
        return $this->hasMany(OnPremiseAdditional::class);
    }
    
    public function OnPremiseChange() {
        return $this->hasMany(OnPremiseChange::class);
    }
    
    public function onpremisereceipts() {
        return $this->hasMany(OnpremiseReceipts::class);
    }
    
    public function onpremisemultiple()
    {
        return $this->belongsTo(OnPremiseMultiple::class, 'onpremise_multiple_id');
    }
}
